/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       value.c
**     SYSTEM   NAME:       Config
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     0.1
**     CREATION DATE:       1992/7/28
**
** DESCRIPTION:             Configuration storage/retreival.
**                          For each value a Set, Get and Del should
**                          be present.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <dnpap.h>
#include "config.h"


/* Boolean */

BOOLEAN ConfigSetValueBoolean(CONFIG_ENTRY *e, BOOLEAN b)
{
    ConfigClear(e);
    e->type=CONFIG_TYPE_BOOLEAN;
    e->value.Boolean=b;
    return TRUE;
}

BOOLEAN ConfigGetValueBoolean(CONFIG_ENTRY *e, BOOLEAN *b)
{
    if (e->type!=CONFIG_TYPE_BOOLEAN)
        return FALSE;
    *b=e->value.Boolean;
    return TRUE;
}

BOOLEAN ConfigDelValueBoolean(CONFIG_ENTRY *e)
{
    if (e->type!=CONFIG_TYPE_BOOLEAN)
        return FALSE;
    e->type=CONFIG_TYPE_NULL;
    return TRUE;
}


/* Short */

BOOLEAN ConfigSetValueShort(CONFIG_ENTRY *e, short s)
{
    ConfigClear(e);
    e->type=CONFIG_TYPE_SHORT;
    e->value.Short=s;
    return TRUE;
}

BOOLEAN ConfigGetValueShort(CONFIG_ENTRY *e, short *s)
{
    if (e->type!=CONFIG_TYPE_SHORT)
        return FALSE;
    *s=e->value.Short;
    return TRUE;
}

BOOLEAN ConfigDelValueShort(CONFIG_ENTRY *e)
{
    if (e->type!=CONFIG_TYPE_SHORT)
        return FALSE;
    e->type=CONFIG_TYPE_NULL;
    return TRUE;
}


/* Long */

BOOLEAN ConfigSetValueLong(CONFIG_ENTRY *e, LONG l)
{
    ConfigClear(e);
    e->type=CONFIG_TYPE_LONG;
    e->value.Long=l;
    return TRUE;
}
    
BOOLEAN ConfigGetValueLong(CONFIG_ENTRY *e, LONG *l)
{
    if (e->type!=CONFIG_TYPE_LONG)
        return FALSE;
    *l=e->value.Long;
    return TRUE;
}

BOOLEAN ConfigDelValueLong(CONFIG_ENTRY *e)
{
    if (e->type!=CONFIG_TYPE_LONG)
        return FALSE;
    e->type=CONFIG_TYPE_NULL;
    return TRUE;
}


/* IPAddr */

BOOLEAN ConfigSetValueIPAddr(CONFIG_ENTRY *e, IPADDR a)
{
    ConfigClear(e);
    e->type=CONFIG_TYPE_IPADDR;
    e->value.IPAddr=a;
    return TRUE;
}
    
BOOLEAN ConfigGetValueIPAddr(CONFIG_ENTRY *e, IPADDR *a)
{
    if (e->type!=CONFIG_TYPE_IPADDR)
        return FALSE;
    *a=e->value.IPAddr;
    return TRUE;
}

BOOLEAN ConfigDelValueIPAddr(CONFIG_ENTRY *e)
{
    if (e->type!=CONFIG_TYPE_IPADDR)
        return FALSE;
    e->type=CONFIG_TYPE_NULL;
    return TRUE;
}


/* Double */

BOOLEAN ConfigSetValueDouble(CONFIG_ENTRY *e, double d)
{
    ConfigClear(e);
    e->type=CONFIG_TYPE_DOUBLE;
    e->value.Double=d;
    return TRUE;
}
    
BOOLEAN ConfigGetValueDouble(CONFIG_ENTRY *e, double *d)
{
    if (e->type!=CONFIG_TYPE_DOUBLE)
        return FALSE;
    *d=e->value.Double;
    return TRUE;
}

BOOLEAN ConfigDelValueDouble(CONFIG_ENTRY *e)
{
    if (e->type!=CONFIG_TYPE_DOUBLE)
        return FALSE;
    e->type=CONFIG_TYPE_NULL;
    return TRUE;
}


/* String */

BOOLEAN ConfigSetValueString(CONFIG_ENTRY *e, char *s)
{
    char *p;
    
    p=DnpapMalloc(strlen(s)+1);
    if (p==0)
        return FALSE;
    strcpy(p, s);
    
    ConfigClear(e);
    e->type=CONFIG_TYPE_STRING;
    e->value.String=p;
    return TRUE;
}

BOOLEAN ConfigGetValueString(CONFIG_ENTRY *e, char **s)
{
    if (e->type!=CONFIG_TYPE_STRING)
        return FALSE;
    *s=e->value.String;
    return TRUE;
}

BOOLEAN ConfigDelValueString(CONFIG_ENTRY *e)
{
    if (e->type!=CONFIG_TYPE_STRING)
        return FALSE;
    DnpapFree(e->value.String);
    e->type=CONFIG_TYPE_NULL;
    return TRUE;
}


/* Bytes */

BOOLEAN ConfigSetValueBytes(CONFIG_ENTRY *e, BYTE *b, USHORT n)
{
    BYTE *p;
    
    p=DnpapMalloc(n);
    if (p==0)
        return FALSE;
    memcpy(p, b, n);
    
    ConfigClear(e);
    e->type=CONFIG_TYPE_BYTES;
    e->value.Bytes.buffer=p;
    e->value.Bytes.size=n;
    return TRUE;
}

BOOLEAN ConfigGetValueBytes(CONFIG_ENTRY *e, BYTE **b, USHORT *n)
{
    if (e->type!=CONFIG_TYPE_BYTES)
        return FALSE;
    *b=e->value.Bytes.buffer;
    *n=e->value.Bytes.size;
    return TRUE;
}

BOOLEAN ConfigDelValueBytes(CONFIG_ENTRY *e)
{
    if (e->type!=CONFIG_TYPE_BYTES)
        return FALSE;
    DnpapFree(e->value.Bytes.buffer);
    e->type=CONFIG_TYPE_NULL;
    return TRUE;
}


/* LongBuf */

BOOLEAN ConfigSetValueLongBuf(CONFIG_ENTRY *e, LONG *b, USHORT n)
{
    LONG *p;
    
    p=DnpapMalloc(n*sizeof(LONG));
    if (p==0)
        return FALSE;
    memcpy(p, b, n*sizeof(LONG));
    
    ConfigClear(e);
    e->type=CONFIG_TYPE_LONGBUF;
    e->value.LongBuf.buffer=p;
    e->value.LongBuf.size=n;
    return TRUE;
}

BOOLEAN ConfigGetValueLongBuf(CONFIG_ENTRY *e, LONG **b, USHORT *n)
{
    if (e->type!=CONFIG_TYPE_LONGBUF)
        return FALSE;
    *b=e->value.LongBuf.buffer;
    *n=e->value.LongBuf.size;
    return TRUE;
}

BOOLEAN ConfigDelValueLongBuf(CONFIG_ENTRY *e)
{
    if (e->type!=CONFIG_TYPE_LONGBUF)
        return FALSE;
    DnpapFree(e->value.LongBuf.buffer);
    e->type=CONFIG_TYPE_NULL;
    return TRUE;
}
