/**********************************************************************
** MODULE INFORMATION*
**********************
**      FILE     NAME:       maxmem.c
**      SYSTEM   NAME:       maxmem
**      ORIGINAL AUTHOR(S):  Alfred Kayser
**      VERSION  NUMBER:     1.0
**      CREATION DATE:       91/09/16
**
** DESCRIPTION: Memory functions.
***********************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:   $Revision: $  
** AUTHOR:     $Author: $ 
** DATE:       $Date: $
** LOG:        $Log: $
**********************************************************************/
#define LIBRARY

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <dnpap.h>
#include <mibsup.h>

#include "maxmem.h"
#include "maxmib.h"


EXPORT LONG maxmemChunk;
EXPORT LONG maxmemMax;
EXPORT LONG maxmemUsed;


EXPORT WORD memoryMax (SNMP_OBJECT *Obj, WORD IdLen)
{
    if (MibSimple(Obj, IdLen) == FALSE)
        return (SNMP_NOSUCHNAME);
    Obj->Syntax.LngInt = maxmemMax;
    return (SNMP_NOERROR);
}

EXPORT WORD memoryChunk (SNMP_OBJECT *Obj, WORD IdLen)
{
    if (MibSimple(Obj, IdLen) == FALSE)
        return (SNMP_NOSUCHNAME);
    Obj->Syntax.LngInt = maxmemChunk;
    return (SNMP_NOERROR);
}

EXPORT WORD memoryUsed (SNMP_OBJECT *Obj, WORD IdLen)
{
    if (MibSimple(Obj, IdLen) == FALSE)
        return (SNMP_NOSUCHNAME);
    Obj->Syntax.LngInt = maxmemUsed;
    return (SNMP_NOERROR);
}
