#ifndef _MAC_H_
#define _MAC_H_


#include <dnpap.h>
#include <chain.h>
#include <protocol.h>

#define MAC_ARP_NONE           0
#define MAC_ARP_ETHERNET_10MB  1
#define MAC_ARP_ETHERNET_3MB   2
#define MAC_ARP_AMATEUR_AX25   3
#define MAC_ARP_PROTEON        4
#define MAC_ARP_CHAOS          5
#define MAC_ARP_IEEE_802       6
#define MAC_ARP_ARCNET         7

#define MAC_TYPE_OTHER               1
#define MAC_TYPE_REGULAR_1822        2
#define MAC_TYPE_HDH_1822            3
#define MAC_TYPE_DDN_X25             4
#define MAC_TYPE_RFC877_X25          5
#define MAC_TYPE_ETHERNET_CSMACD     6
#define MAC_TYPE_88023_CSMACD        7
#define MAC_TYPE_88024_TOKENBUS      8
#define MAC_TYPE_88025_TOKENRING     9
#define MAC_TYPE_88026_MAN           10
#define MAC_TYPE_SOFT_LOOPBACK       24



#define MAC_PROT_IP                 0x0800
#define MAC_PROT_ARP                0x0806


typedef struct _MAC_IFACE   MAC_IFACE;
typedef struct _MAC_TYPE    MAC_TYPE;
typedef struct _MAC_PROT    MAC_PROT;
typedef struct _MAC_COLL    MAC_COLL;
typedef struct _MAC_HDR     MAC_HDR;
typedef struct _MAC_STAT    MAC_STAT;
typedef struct _MAC_INFO    MAC_INFO;
typedef struct _MAC_FRAME   MAC_FRAME;
typedef struct _MAC_PERF    MAC_PERF;

struct _MAC_IFACE
{
    BOOLEAN     (*Send)(MAC_IFACE *iface, CHAIN *chain);
    BOOLEAN     (*Stat)(MAC_IFACE *iface, MAC_STAT *stat);
    BYTE        descr[16];
    WORD        type;
    WORD        index;
    WORD        mtu;
    WORD        speed;
    BOOLEAN     statusAdmin;
    BOOLEAN     statusOper;
    WORD        arp;
    BYTE        addr[16];
    BYTE        addrBroadcast[16];
    WORD        addrLength;
    void        *specific;
    MAC_IFACE   *next;
};

struct _MAC_TYPE
{
    CHAIN       *(*Encode)(CHAIN *chain, MAC_HDR *hdr);
    CHAIN       *(*Decode)(CHAIN *chain, MAC_HDR *hdr);
    WORD        type;
    MAC_TYPE    *next;
};


struct _MAC_PROT
{
    BOOLEAN     (*Rcve)(MAC_IFACE *iface, CHAIN *chain, MAC_HDR *hdr);
    WORD        type;
    MAC_PROT    *next;
};


struct _MAC_COLL
{
    BOOLEAN     (*Rcve)(MAC_COLL *coll, PROT_PKT *pkt);
    void        *specific;
    MAC_COLL    *next;
};



struct _MAC_HDR
{
    BYTE        *src;
    BYTE        *dst;
    WORD        type;
    BOOLEAN     broadcast;
};

struct _MAC_STAT
{
    ULONG           inOctets;
    ULONG           inUcastPkts;
    ULONG           inNUcastPkts;
    ULONG           inDiscards;
    ULONG           inErrors;
    ULONG           inUnknownProtos;
    ULONG           outOctets;
    ULONG           outUcastPkts;
    ULONG           outNUcastPkts;
    ULONG           outDiscards;
    ULONG           outErrors;
    ULONG           outQLen;
    ULONG           LostPkts;
    ULONG           Octets;
    ULONG           Pkts; 
    ULONG           BroadcastPkts; 
    ULONG           MulticastPkts;
    ULONG           CRCAlignErrors;                 
    ULONG           UndersizePkts;                  
    ULONG           OversizePkts;                   
    ULONG           Fragments;                      
    ULONG           Jabbers;                        
    ULONG           Collisions; 
    ULONG           BufferedPkts; 
    ULONG           DiscardedPkts;
    ULONG           StackedPkts;
    ULONG           TruncatedPkts;
};

struct _MAC_INFO
{
    ULONG       time;
	USHORT      length;
    USHORT      copied;
    BOOLEAN     promiscuous;
};

struct _MAC_PERF
{
    BOOLEAN         on;
    ULONG           pkts;
    ULONG           octets;
    ULONG           timeTotal;
    ULONG           timeMin;
    ULONG           timeMax;
};

BOOLEAN     MacInit(void);

BOOLEAN     MacIfaceRegister(MAC_IFACE *iface); 
BOOLEAN     MacIfaceRemove(MAC_IFACE *iface);

BOOLEAN     MacTypeRegister(MAC_TYPE *mac); 
BOOLEAN     MacTypeRemove(MAC_TYPE *mac);

BOOLEAN     MacProtRegister(MAC_PROT *prot); 
BOOLEAN     MacProtRemove(MAC_PROT *prot);

BOOLEAN     MacCollRegister(MAC_COLL *coll);
BOOLEAN     MacCollRemove(MAC_COLL *coll);

BOOLEAN     MacSend(MAC_IFACE *iface, CHAIN *chain, MAC_HDR *hdr);
BOOLEAN     MacRcve(MAC_IFACE *iface, CHAIN *chain, MAC_INFO *info);


MAC_IFACE   *MacIfaceFind(BYTE *descr);
MAC_IFACE   *MacIfaceGet(WORD index);

BOOLEAN     MacStatistics(MAC_IFACE *iface, MAC_STAT *stat);

BOOLEAN     MacPerfStatistics(MAC_PERF *perf);
BOOLEAN     MacPerfSwitch(BOOLEAN on);



#endif
