#include <time.h>
#include <stdio.h>
#include <string.h>
#include <config.h>
#include "mac.h"

extern ULONG SnorTime(void);
#define MAC_TIME SnorTime()

static MAC_TYPE *TypeFind(WORD type);
static MAC_PROT *ProtFind(WORD type);


MAC_PROT        *macProtList=0;
MAC_TYPE        *macTypeList=0;
MAC_IFACE       *macIfaceList=0;
MAC_COLL        *macCollList=0;

MAC_PERF        macPerf;



BOOLEAN MacInit(void)
{
    BYTE            name[255];
    BYTE            *descr;
    BYTE            *addr;
    USHORT          n,i;
    MAC_IFACE       *mac;
    static BOOLEAN  init = FALSE;
    
    if (!init)
    {
        i = 1;
        sprintf(name, "mac.iface.name.%d", i);
        while (ConfigGetString(name, &descr))
        {
            mac = MacIfaceFind(descr);
            if (mac!=0)
            {
                mac->index = i;
                
                sprintf(name, "mac.iface.mtu.%d", i);
                ConfigGetShort(name, &mac->mtu);
            
                sprintf(name, "mac.iface.speed.%d", i);
                ConfigGetShort(name, &mac->speed);

                sprintf(name, "mac.iface.up.%d", i);
                ConfigGetBoolean(name, &mac->statusAdmin);
            
                sprintf(name, "mac.iface.addrLength.%d", i);
                ConfigGetShort(name, &mac->addrLength);

                sprintf(name, "mac.iface.addr.%d", i);
                if (ConfigGetBytes(name, &addr, &n))
                    memcpy(mac->addr, addr, n);
            
                sprintf(name, "mac.iface.addrBroadcast.%d", i);
                if (ConfigGetBytes(name, &addr, &n))
                    memcpy(mac->addrBroadcast, addr, n);
            }

            i++;
            sprintf(name, "mac.iface.name.%d", i);
        }
        
        macPerf.on=FALSE;
        macPerf.pkts=0UL;
        macPerf.octets=0UL;
        macPerf.timeTotal=0UL;
        macPerf.timeMin=0xffffffffUL;
        macPerf.timeMax=0UL;
        
        init = TRUE;
    }
    return init;
}




BOOLEAN MacIfaceRegister(MAC_IFACE *iface)
{
    iface->next = macIfaceList;
    macIfaceList = iface;

    return TRUE;
}


BOOLEAN MacIfaceRemove(MAC_IFACE *iface)
{
    MAC_IFACE **p;
    
    p=&macIfaceList;
    while (*p!=0)
    {
        if (*p==iface)
            *p=(*p)->next;
        else
            p=&(*p)->next;
    }
    return TRUE;
}

BOOLEAN MacTypeRegister(MAC_TYPE *type)
{
    type->next = macTypeList;
    macTypeList = type;

    return TRUE;
}

BOOLEAN MacTypeRemove(MAC_TYPE *type)
{
    MAC_TYPE **p;
    
    p=&macTypeList;
    while (*p!=0)
    {
        if (*p==type)
            *p=(*p)->next;
        else
            p=&(*p)->next;
    }
    return TRUE;
}

BOOLEAN MacCollRegister(MAC_COLL *coll)
{
    coll->next = macCollList;
    macCollList = coll;

    return TRUE;
}

BOOLEAN MacCollRemove(MAC_COLL *coll)
{
    MAC_COLL **p;
    
    p=&macCollList;
    while (*p!=0)
    {
        if (*p==coll)
            *p=(*p)->next;
        else
            p=&(*p)->next;
    }
    return TRUE;
}

BOOLEAN MacProtRegister(MAC_PROT *prot)
{
    prot->next = macProtList;
    macProtList = prot;

    return TRUE;

}

BOOLEAN MacProtRemove(MAC_PROT *prot)
{
    MAC_PROT **p;
    
    p=&macProtList;
    while (*p!=0)
    {
        if (*p==prot)
            *p=(*p)->next;
        else
            p=&(*p)->next;
    }
    return TRUE;
}


BOOLEAN MacSend(MAC_IFACE *iface, CHAIN *chain, MAC_HDR *hdr)
{
    MAC_TYPE *type;
    CHAIN    *new;
    
    type = TypeFind(iface->type);
    if (type != 0)
    {
        new = type->Encode(chain, hdr);
        if (new != 0)
        {
            iface->Send(iface, new);
            if (new != chain)
                ChainFree(new);
        }
    }
    return TRUE;

}

BOOLEAN MacRcve(MAC_IFACE *iface, CHAIN *chain, MAC_INFO *info)
{
    MAC_COLL    *coll;
    MAC_TYPE    *type;
    MAC_PROT    *prot;
    MAC_HDR     hdr;
    CHAIN       *new;
    PROT_PKT    pkt;
    ULONG       start, diff;
    BOOLEAN     on;

    if ((on = macPerf.on) != FALSE)
        start = MAC_TIME;

    if (macCollList != 0)
    {
        if (ProtFrame(&pkt, chain->buffer+chain->offset,
            chain->length, info->length, info->time, iface->type, iface->index))
        {
            for (coll=macCollList; coll!=0; coll=coll->next)
                coll->Rcve(coll, &pkt);
            ProtFree(&pkt);
        }
    }

    type = TypeFind(iface->type);
    if (type!=0)
    {
        new = type->Decode(chain, &hdr);
        if (new != 0)
        {
            prot = ProtFind(hdr.type);
            if (prot!=0)
            {
                prot->Rcve(iface, new, &hdr);

            }
            if (new != chain)
                ChainFree(new);
        }
    }
    
    if (on && macPerf.on)
    {
        diff = MAC_TIME - start;
        macPerf.pkts++;
        macPerf.octets += info->copied;
        macPerf.timeTotal += diff;
        if (diff < macPerf.timeMin)
                macPerf.timeMin = diff;
        if (diff > macPerf.timeMax)
                macPerf.timeMax = diff;
    }

    return TRUE;
}


MAC_IFACE *MacIfaceFind(BYTE *descr)
{
    MAC_IFACE *p;
    
    for (p=macIfaceList; p!=0; p=p->next)
    {
        if (strcmp(p->descr, descr)==0)
            return p;
    }
    return 0;
}


MAC_IFACE *MacIfaceGet(WORD index)
{
    MAC_IFACE *p;
    
    for (p=macIfaceList; p!=0; p=p->next)
    {
        if (p->index==index)
            return p;
    }
    return 0;
}


BOOLEAN MacStatistics(MAC_IFACE *iface, MAC_STAT *stat)
{
    return iface->Stat(iface, stat);
}


BOOLEAN MacPerfStatistics(MAC_PERF *perf)
{
    memcpy(perf, &macPerf, sizeof(MAC_PERF));
    return TRUE;
}


BOOLEAN MacPerfSwitch(BOOLEAN on)
{
    macPerf.on = on;
    macPerf.pkts=0UL;
    macPerf.octets=0UL;
    macPerf.timeTotal=0UL;
    macPerf.timeMin=0xffffffffUL;
    macPerf.timeMax=0UL;
    return TRUE;
}


static MAC_TYPE *TypeFind(WORD type)
{
    MAC_TYPE *p;
    
    for (p=macTypeList; p!=0; p=p->next)
    {
        if (p->type==type)
            return p;
    }
    return 0;
}


static MAC_PROT *ProtFind(WORD type)
{
    MAC_PROT *p;
    
    for (p=macProtList; p!=0; p=p->next)
    {
        if (p->type==type)
            return p;
    }
    return 0;
}
