#include <memory.h>
#include <stdio.h>
#define  INCL_BASE
#include <os2.h>
#include <dnpap.h>
#include <timer.h>
#include <block.h>
#include <mac.h>
#include <snor.h>
#include <ether.h>
#include "ip.h"

static BOOLEAN Rcve(CHAIN *chain, IP_HDR *ipHdr);




void main(void)
{
    MAC_IFACE   *ifaceMac;
    IP_IFACE    ifaceIp;
    IP_PROT     ip;
    
    if (!IpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"IpInit");
        DnpapExit(1);
    }
    
    if (!ArpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"ArpInit");
        DnpapExit(1);
    }
    
    if (!EtherInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"EtherInit");
        DnpapExit(1);
    }
    
    if (!TimerInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"TimerInit");
        DnpapExit(1);
    }

    if (!BlockInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"BlockInit");
        DnpapExit(1);
    }

    if (!SnorInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"SnorInit");
        DnpapExit(1);
    }
    
    ifaceMac = MacIfaceFind("NEUS0$");
    if (ifaceMac==0)
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Iface NEUS0$ not found");
        DnpapExit(1);
    }
    
    printf("%02x:%02x:%02x:%02x:%02x:%02x\n",
        (WORD)ifaceMac->addr[0],
        (WORD)ifaceMac->addr[1],
        (WORD)ifaceMac->addr[2],
        (WORD)ifaceMac->addr[3],
        (WORD)ifaceMac->addr[4],
        (WORD)ifaceMac->addr[5]);

    ip.prot = IP_PROT_ICMP;
    ip.Rcve = Rcve;

    if (!IpProtRegister(&ip))
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"IpProtRegister");
        DnpapExit(1);
    }

    ifaceIp.iface   = ifaceMac;
    ifaceIp.up      = TRUE;
    ifaceIp.addr    = 0x82a19104;
    ifaceIp.mask    = 0xffff0000;


    if (!IpIfaceRegister(&ifaceIp))
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"IpIfaceRegister");
        DnpapExit(1);
    }

    if (!Block())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Block");
        DnpapExit(1);
    }

    SnorExit();


}


static BOOLEAN Rcve(CHAIN *chain, IP_HDR *ipHdr)
{
    DWORD src, dst;

    src = IpH2NDWord(ipHdr->src);
    dst = IpH2NDWord(ipHdr->dst);

    printf("ICMP %d.%d.%d.%d -> %d.%d.%d.%d %d\n",
        (WORD)((BYTE *)&src)[0],
        (WORD)((BYTE *)&src)[1],
        (WORD)((BYTE *)&src)[2],
        (WORD)((BYTE *)&src)[3],
        (WORD)((BYTE *)&dst)[0],
        (WORD)((BYTE *)&dst)[1],
        (WORD)((BYTE *)&dst)[2],
        (WORD)((BYTE *)&dst)[3],
        ChainLength(chain));

    return TRUE;
}
