#include <stdio.h>
#include "ip.h"
#include "iphdr.h"
#include "ipprot.h"
#include "iproute.h"
#include "ipiface.h"
#include "ipreas.h"


BOOLEAN IpRcve(MAC_IFACE *iface, CHAIN *chain, MAC_HDR *macHdr)
{
    IP_HDR  ipHdr;
    CHAIN   *new, *reas;
    IP_PROT *prot;
    BOOLEAN success = FALSE;

    new = IpHdrDecode(chain, &ipHdr);
    if (new != 0)
    {
        if (IpIfaceIsForMe(ipHdr.dst))
        {
            if (ipHdr.offset == 0 &&
                (ipHdr.flags & IP_FLAG_MORE_FRAGMENTS) != IP_FLAG_MORE_FRAGMENTS)
            {
                prot = IpProtFind(ipHdr.prot);
                if (prot != 0)
                    success = prot->Rcve(new, &ipHdr);
            }
            else
            {
                if (IpReas(new, &reas, &ipHdr))
                {
                    prot = IpProtFind(ipHdr.prot);
                    if (prot != 0)
                        success = prot->Rcve(reas, &ipHdr);
                    ChainFree(reas);
                }
                else
                {
                    success = TRUE;
                }
            }
        }
    
        if (new != chain)
            ChainFree(new);
    }
  
    return success;
}



