#ifndef _DFILTERC_H
#define _DFILTERC_H

#include <dnpap.h>
#include <snmp.h>


typedef struct _DNPAP_FILTER
{
    LONG    Channel;
    LONG    HostTable;
    LONG    Matrix;
    LONG    PktDataOffset;
    BYTE*   PktData;
    BOOLEAN PktDataBytes;
    BYTE*   PktDataMask;
    BOOLEAN PktDataMaskBytes;
    BYTE*   PktDataNotMask;
    BOOLEAN PktDataNotMaskBytes;
    BOOLEAN PktDataNotMaskAllZero;
    WORD    PktDataLen;
    WORD    PktDataMaskLen;
    WORD    PktDataNotMaskLen;
    LONG    PktStatus;
    LONG    PktStatusMask;
    LONG    PktStatusNotMask;
    BYTE    Owner[SNMP_SIZE_BUFCHR];
    WORD    OwnerLen;
    LONG    Status;

} DNPAP_FILTER;


BOOLEAN DnpapFilterCInit(DNPAP_FILTER *filter);
BOOLEAN DnpapFilterCStart(DNPAP_FILTER *filter);
BOOLEAN DnpapFilterCStop(DNPAP_FILTER *filter);


#endif
