#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <dnpap.h>
#include <message.h>
#include <mac.h>
#include <protocol.h>

#include "state.h"
#include "statc.h"


static VOID StatMacCallback(MAC_COLL *collector, PROT_PKT *pkt);



/*****************************************************************
** NAME:        StatCInit
** SYNOPSIS:    BOOLEAN StatCInit (ETHER_STATS *etherStats)
** PARAMETERS:  pointer to data etherStats entry
** DESCRIPTION: initializes collector.
** REMARKS:     called when status is CREATE_REQUEST: see statm.c
** RETURNS:     TRUE: everything OK
**              FALSE: net not initialized
*******************************************************************/

BOOLEAN StatCInit (ETHER_STATS *etherStats)
{
LONG source[] = {1,3,6,1,2,1,2,2,1,1,1};
    
    etherStats->SourceLen = sizeof(source)/sizeof(long);
    memcpy (etherStats->Source, source, sizeof(source));

    if ((etherStats->Iface =
        MacIfaceGet((WORD) etherStats->Source[etherStats->SourceLen-1])) == NULL)
    {
        DnpapMessage(DMC_ERROR, STAT_NETINIT, "etherStat: network initialization failed");
        return (FALSE);
    }
    return TRUE;
}

/*****************************************************************
** NAME:        StatCStart
** SYNOPSIS:    BOOLEAN StatCStart (ETHER_STATS *etherStats)
** PARAMETERS:  pointer to data etherStats entry
** DESCRIPTION: starts collector.
** REMARKS:     called when status is VALID: see statm.c
** RETURNS:     TRUE: everything OK
**              FALSE: net not registered
*******************************************************************/

BOOLEAN StatCStart (ETHER_STATS *etherStats)
{
    etherStats->Coll.Rcve       = StatMacCallback;
    etherStats->Coll.specific   = etherStats;
    if (!MacCollRegister(&(etherStats->Coll)))
    {
        DnpapMessage(DMC_ERROR, STAT_NETINIT, "etherStat: network initialization failed");
        return (FALSE);
    }

    MacStatistics(etherStats->Iface, &etherStats->BaseStat);

    etherStats->Octets = 0; 
    etherStats->Pkts = 0; 
    etherStats->Pkts64Octets = 0; 
    etherStats->Pkts65to127Octets = 0; 
    etherStats->Pkts128to255Octets = 0; 
    etherStats->Pkts256to511Octets = 0;
    etherStats->Pkts512to1023Octets = 0;
    etherStats->Pkts1024to1518Octets = 0;

    return TRUE;
}

/*****************************************************************
** NAME:        StatCStop 
** SYNOPSIS:    BOOLEAN StatCStop (ETHER_STATS *etherStats)
** PARAMETERS:  pointer to etherStats entry
** DESCRIPTION: stops collector.
** REMARKS:     called when status is INVALID: see statm.c
** RETURNS:     TRUE: net registration removed 
*******************************************************************/

BOOLEAN StatCStop (ETHER_STATS *etherStats)
{
    MacCollRemove(&(etherStats->Coll));
    return TRUE;
}

/*****************************************************************
** NAME:        StatMacCallback
** PARAMETERS:  see Net manual
** DESCRIPTION: analyses packets received from net
** REMARKS:     none
** RETURNS:     VOID
*******************************************************************/

static VOID StatMacCallback(MAC_COLL *collector, PROT_PKT *pkt)
{
PROT_OBJ Interface = {1, {1,2}};
PROT_OBJ Size = {1, {1,4}};
LWORD size;
ETHER_STATS *etherStats = collector->specific;

    if (ProtGetField(pkt,&Interface) == TRUE &&
        Interface.Syntax.LngInt == etherStats->Source[etherStats->SourceLen-1])
    {
        if (ProtGetField(pkt,&Size) == TRUE)
        {
            etherStats->Pkts++;
            
            size = Size.Syntax.LngUns + 4L;
            etherStats->Octets += size;
            if (size == 64)
                etherStats->Pkts64Octets++;
            if (size >= 65)
            {
                if (size <= 127)
                    etherStats->Pkts65to127Octets++;
                else if (size <= 255)
                    etherStats->Pkts128to255Octets++; 
                else if (size <= 511)
                    etherStats->Pkts256to511Octets++;
                else if (size <= 1023)
                    etherStats->Pkts512to1023Octets++;
                else if (size <= 1518)
                    etherStats->Pkts1024to1518Octets++;
            }
        }
    }

    return;
}                       

