#define INCL_BASE
#include <os2.h>
#include <dnpap.h>
#include <timer.h>
#include "block.h"




BLOCK *blockList[16];
DEFINEMUXSEMLIST(blockSemList,16);
BOOLEAN blockAgain=TRUE;


BOOLEAN BlockInit(void)
{
    static BOOLEAN init=FALSE;

    if (!init)
    {
        blockSemList.cmxs = 0;
        init = TRUE;
    }
    return init;
}


BOOLEAN BlockRegister(BLOCK *block)
{
    USHORT i;                                  

    i=blockSemList.cmxs++;
    blockSemList.amxs[i].zero=0;
    blockSemList.amxs[i].hsem=block->hsem;
    blockList[i]=block;
    return TRUE;
}


void BlockStop(void)
{
    blockAgain = FALSE;
}



BOOLEAN Block(void)
{
    LONG    t;
    USHORT  r;
    SHORT   i;                                  

    while (blockAgain)
    {
        t = TimerRemaining();

        if (t < 0)
            t = SEM_INDEFINITE_WAIT;

        r = DosMuxSemWait(&i, &blockSemList, t);

        switch (r)
        {
            case 0:
                if (!blockList[i]->Check(blockList[i]))
                    return FALSE;
                break;
            case ERROR_SEM_TIMEOUT:
                if (!TimerCheck())
                    return FALSE;
                break;
            default:
                return FALSE;
        }

    }
    return TRUE;

}





BOOLEAN BlockCheck(void)
{
    USHORT  r;
    SHORT   i;                                  

    if (!TimerCheck())
        return FALSE;

    r = DosMuxSemWait(&i, &blockSemList, SEM_IMMEDIATE_RETURN);

    switch (r)
    {
        case 0:
            return (blockList[i]->Check(blockList[i]));
        case ERROR_SEM_TIMEOUT:
            return TRUE;
        default:
            return FALSE;
    }
}
