.*----------------------------------------------------------
.* WPSAM -- Workplace Shell Access Manager
.*
.* IPF Dokumentation
.*
.* Version 3.0 - 28.7.1995
.*----------------------------------------------------------
:userdoc.
:title.WPSam
:docprof toc=123.

.*----------------------------------------------------------
.*  WPSam (Einleitungsseite)
.*----------------------------------------------------------
:h1.WPSam
:lines align=center.
:artwork align=center name='WPSAM.BMP'.

:font facename=Helv size=24x24.
WPSam:font. Version 3.0

der :font facename=Helv size=24x24.Workplace Shell Access Manager:font.

(C) :artwork align=center name='NB.BMP' runin. Noller &amp. Breining Software, 1993...1995


Compuserve&colon. 100101,3201
Fido-net&colon. 2&colon.246/1406
Telefon&colon. (49)7191-960345

    * * * * * * * * * * * * * * * * * * * * * * * * *
:elines.

.*----------------------------------------------------------
.*  Einleitung
.*----------------------------------------------------------
:h1.Einleitung

:p.:hp4.WPSam:ehp4. ist eine Erweiterung der Workplace Shell von OS/2, die es ermglicht,
einen Satz verschiedener Arbeitsoberflchen auf einem PC zu halten. Zwischen diesen
Arbeitsoberflchen kann whrend einer Sitzung umgeschaltet werden, ohne den
PC dazwischen neu zu starten. Es mssen dazu nicht einmal gerade laufende Programme
beendet werden.

:p.Die einzelnen Arbeitsoberflchen knnen durch Passwrter geschtzt werden, die Paworteingabe
kann ber einen :link reftype=hd refid=MAGSUPP.Magnetkartenleser:elink. erfolgen.

:p.Fr dieses Programm sind eine Vielzahl von Anwendungen vorstellbar&colon.
:ul.
:li.Mssen auf einem Rechner verschiedene Aufgaben durchgefhrt werden, kann fr jede
einzelne eine eigene Arbeitsoberflche eingerichtet werden (z. B. Programmentwicklung
und Textverarbeitung).
:li.Ein PC kann mehreren Benutzern gehren, von denen jeder bestimmte Vorlieben fr das
Aussehen "seiner" Arbeitsoberflche hat.
:li.Es ist sogar mglich, eine private Arbeitsoberflche auf einem Netzwerk-Server fr
jeden einzelnen Benutzer in diesem Netz zu halten. Jeder dieser Benutzer kann seine
private Shell auf jedem PC dieses Netzwerks starten.
:li.Die eigene "Arbeitsoberflche in der Westentasche", d. h. auf Diskette wurde getestet
und funktioniert, ist jedoch intolerabel langsam.
:eul.

.*----------------------------------------------------------
.*  Begriffe
.*----------------------------------------------------------
:h1 id=TERM.Begriffe
:p.Auf den folgenden Seiten werden einige Begriffe definiert, die fr das Verstndnis dieser Anleitung notwendig sind.

:h2 id=DT.Arbeitsoberflche und Benutzerumgebung
:p.Das mitgelieferte Programm :hp4.InitOS2:ehp4. kann dazu verwendet werden, Sitzungen ohne Workplace-Shell bzw.
sogar ohne Presentation Manager zu starten. In diesem Fall ist die Verwendung des Begriffes :hp1.Arbeitsoberflche:ehp1.
nicht mehr angebracht. Daher wird hier synonym das Wort :hp1.Benutzerumgebung:ehp1. verwendet.

:h2 id=PRIVDT.Private Arbeitsoberflche
:p.OS/2 sucht seine Informationen zu den Einstellungen einer spezifischen Arbeitsoberflche in zwei sogenannten
Profildateien, der Benutzerprofildatei :hp2.OS2.INI:ehp2. und der Systemprofildatei :hp2.OS2SYS.INI:ehp2..
Letztere ist dazu gedacht, alle systemspezifischen Informationen zu halten, wie z. B. die verschiedenen
Layoutpaletten, die Druckertreiber, Fonts usw.

:p.Beim Umschalten verschiedener Arbeitsoberflchen verlangt OS/2, da die Systemprofildatei
beibehalten wird. Lediglich die Benutzerprofildatei wird umgeschaltet.

:p.Eine Arbeitsoberflche, die eine eigene Systemprofildatei besitzt, wird daher im folgenden :hp1.private Arbeitsoberflche:ehp1.
genannt. Sie kann nur whrend des Systemstarts ausgewhlt werden (falls das Programm :hp4.InitOS2:ehp4. installiert ist).
Deren Systemprofildatei bleibt bis zum nchsten Systemabschlu aktiv.
Dies hat zur Folge, da jede mit :hp4.WPSam:ehp4. angelegte Arbeitsoberflche zu einer bestimmten
privaten Arbeitsoberflche gehrt.

:h2 id=DEFDT.Default-Arbeitsoberflche
:p.Die Arbeitsoberflche, die bei der Installation des Systems erstellt wurde, wird im folgenden als :hp1.Default-Arbeitsoberflche:ehp1.
bezeichnet. Sie wird von :hp4.WPSam:ehp4. wie eine normale :link reftype=hd refid=PRIVDT.private Arbeitsoberflche:elink.
behandelt.
:p.Sie wird aus :hp4.InitOS2.EXE:ehp4. durch die Eingabe von :hp2.ROOT:ehp2. gestartet.

:h2 id=ROOTDT.Stammarbeitsoberflche
:p.Die :hp1.Stammarbeitsoberflche:ehp1. ist die Arbeitsoberflche, die eine zur aktuellen Arbeitsoberflche zugehrige
Systemprofildatei :hp4.OS2SYS.INI:ehp4. besitzt. Wurde :hp4.InitOS2.EXE:ehp4. nicht installiert, ist dies
die :link reftype=hd refid=DEFDT.Default-Arbeitsoberflche:elink..

:p.Nach Installation von :hp4.InitOS2.EXE:ehp4. ist die zugehrige
:link reftype=hd refid=PRIVDT.private Arbeitsoberflche:elink. die Stammarbeitsoberflche.



.*----------------------------------------------------------
.*  Lieferungsumfang
.*----------------------------------------------------------
:h1 id=LUMF.Lieferungsumfang

:p.Das gesamte Programmpaket besteht aus 4 Teilen, den Programmen :hp4.InitOS2.EXE:ehp4.
und :hp4.SAMMY.EXE:ehp4., sowie den DLL-Dateien :hp4.WPSAM.DLL:ehp4. bzw. :hp4.WPSAMF.DLL:ehp4..
Der folgende Abschnitt beschreibt in kurzen Worten deren Funktion. Das Verstndnis der Funktion
ist fr den Gebrauch von :hp4.WPSam:ehp4. nicht unbedingt erforderlich. Sie knnen daher diesen
Abschnitt berspringen und sofort mit der :link reftype=hd refid=INSTALL.Installation:elink.
oder, falls :hp4.WPSam:ehp4. bereits installiert ist, mit der
:link reftype=hd refid=EINREF.Einrichtung eines Benutzers:elink. fortfahren.

:p.:hp7.InitOS2:ehp7.
:p.Dieses Programm liefert einen Anmelde-Dialog fr den Benutzer bereits whrend
dem Startproze des Betriebssystems. Dies bietet den Vorteil, da der Rechner
fr alle unberechtigten Benutzer gesperrt ist, vorausgesetzt, alle
:link reftype=hd refid=DT.Benutzerumgebungen:elink.
sind mit einem Pawort versehen.
Es gibt drei Typen von Benutzerumgebungen&colon.
:ol.
:li.:hp1.OS/2-Gesamtbildschirm&colon.:ehp1. Der Rechner startet nach dem
Anmeldevorgang nur einen OS/2-Gesamtbildschirmmodus. Von hier knnen jedoch trotzdem
alle Typen von Programmen gestartet werden, da OS/2 beim Aufruf von PM-Programmen
automatisch den Presentation-Manager startet.
Durch Eingabe von :hp1.PMSHELL:ehp1. kann die Arbeitsoberflche auch von Hand gestartet werden.
(Falls gewnscht, lt sich dies natrlich durch entsprechende Einstellungen unterbinden.)
:lp.Dieser Umgebungstyp bietet den Vorteil einer sehr kurzen Boot-Zeit. Das ist manchmal
ntzlich, wenn man den Rechner "nur mal kurz einschalten" mu, um z. B. eine Diskette zu
kopieren. Auerdem knnen hier Aktionen durchgefhrt werden, fr die man normalerweise
mit einer Installtionsdiskette booten mu, z. B. das Restaurieren einer Sicherung
der Arbeitsoberflche.
:li.:hp1.Presentation-Manager&colon.:ehp1. Der Rechner startet den
Presentation-Manager. Es wird nur ein Programm (z. B. eine OS/2-Befehlszeile im Fenster)
geffnet. Dies ist dann von Nutzen, wenn ein Benutzer eines Rechners nur ein ganz
bestimmtes Programm starten darf.
:li.:hp1.Workplace-Shell&colon.:ehp1. Dies ist der Normalfall. Es wird die
gesamte objektorientierte Arbeitsoberflche von OS/2 gestartet. Jeder Benutzer kann sich
seine Arbeitsoberflche nach eigenen Vorstellungen gestalten und einrichten.
:eol.

:p.:hp7.WPSam:ehp7.
:p.Diese DLL-Datei beinhaltet eine Objekt-Klasse, die einen modifizierten Ordner darstellt,
der eine einzelne Arbeitsoberflche reprsentiert.
Er enthlt alle privaten Einstellungen dieser Arbeitsoberflche, sowie die fr deren Start notwendigen
Dateien und Verzeichnisse. Der Order selbst
kann durch ein Pawort geschtzt werden. Durch Objekte dieser Klasse werden auch Arbeitsoberflchen
angelegt, die nur durch :hp4.InitOS2:ehp4. gestartet werden knnen, beispielsweise
die Umgebungstypen 1 und 2 (siehe oben) oder sogenannte
:link reftype=hd refid=PRIVDT.private Arbeitsoberflchen:elink..
:hp4.WPSam:ehp4. ermglicht es, da eine neue Arbeitsoberflche gestartet werden kann,
ohne den Rechner neu zu booten. Dazu mu nur deren Symbol doppelt angeklickt werden. Ist
sie vom Typ 1 oder 2, weigert sich :hp4.WPSam:ehp4., diese Arbeitsoberflche zu starten.

:p.:hp7.WPSamF:ehp7.
:p.Diese DLL-Datei ersetzt die Standard-Klasse der Arbeitsoberflchen, :hp1.WPDesktop:ehp1. und ist
im wesentlichen mit dieser identisch. Es kommen lediglich zwei Erweiterungen dazu&colon.
:ol compact.
:li.Einen zustzlichen Eintrag im Kontextmen, um die Umschaltung zur
:link reftype=hd refid=ROOTDT.Stammarbeitsoberflche:elink. zu ermglichen.
:li.Eine zustzliche Einstellseite, um einige Punkte im Kontextmen entfernen zu knnen.
:eol.

:p.:hp7.Sammy:ehp7.
:p.Dieses Programm ist fr die Umschaltung der verschiedenen Arbeitsoberflchen zustndig.
:p.Auerdem verwaltet es die Umschaltung von Umgebungsvariablen beim Wechsel auf eine
andere Arbeitsoberflche.
Beispielsweise verwendet ein Benutzer einen 16-Bit Compiler, ein anderer einen 32-Bit Compiler,
so da unterschiedliche PATH, INCLUDE und LIB-Variable verwendet werden mssen.

.*----------------------------------------------------------
.*  Installation
.*----------------------------------------------------------
:h1 id=INSTALL.Installation

Die Installation des gesamten Programmpaketes kann sowohl mit dem Installationsprogramm als auch
manuell erfolgen. Es werden aus diesem Grund hier beide Methoden beschrieben.

:h2.Installationsprogramm

Das Installationsprogramm untersttzt
:ul.
:li.die Installation,
:li.den Update sowie
:li.die Deinstallation
:eul.
:p.des gesamten Programmpaketes.

Die Bedienung ist denkbar einfach&colon. einfach die Installationsdiskette einlegen und
:hp2.SAMINST:ehp2. aufrufen. Eine kurze Erluterung erscheint im Hauptfenster des
Installationsprogramms, das selbstverstndlich auch ber eine Online-Hilfe verfgt.

:note.Das Installationsprogramm mu immer aus der
:link reftype=hd refid=DEFDT.Default-Arbeitsoberflche:elink. aufgerufen werden!
Nur in dieser knnen dann weitere
:link reftype=hd refid=WPSE3.globale Arbeitsoberflchen:elink. angelegt werden.

:h2.Manuelle Installation
:p.Diese Art der Installation ist nur geeignet fr fortgeschrittene OS/2-Benutzer, die den
prinzipiellen Aufbau des Betriebssystems kennen. Die folgende Information wurde nur
hinzugefgt, um interessierten Anwendern ein besseres Verstndnis der
Applikation zu geben und eventuell Modifikationen der Installation zu erlauben.

:p.:hp7.InitOS2:ehp7.
:p.Dieses Programm ersetzt die :hp1.Protected Mode Shell:ehp1. des Betriebssystemes.
Aus diesem Grund mu in der Datei :hp2.CONFIG.SYS:ehp2. die :hp2.PROTSHELL:ehp2.-Anweisung
gendert und eine Umgebungsvariable eingefgt werden.
:p.:hp5.Beispiel&colon.:ehp5.
:parml.
:pt.alte Anweisung&colon.
:pd.:cgraphic.PROTSHELL=C&colon.&bsl.OS2&bsl.PMSHELL.EXE:ecgraphic.
:pt.neue Anweisungen&colon.
:pd.:cgraphic.PROTSHELL=C&colon.&bsl.WPSAM&bsl.INITOS2.EXE C&colon.&bsl.OS2&bsl.PMSHELL.EXE
- - -  g e s t r i c h e n  - - -
SET SAM=<desktoppath>[;<desktoppath>]:ecgraphic.
:pt.<desktoppath> bezeichnet hier den Pfad auf die Verzeichnisse mit den Arbeitsoberflchen, defaultmig also
:pd.:cgraphic.C&colon.&bsl.WPSAM&bsl.BENUTZER:ecgraphic.
:eparml.

:p.:hp7.Sammy:ehp7.
:p.Dieses Programm wird anstelle der Workplace-Shell gestartet. Dazu mu die Umgebungsvariable
:hp2.RUNWORKPLACE:ehp2. gendert werden und die alte Workplace-Shell in einer neuen Variable
:hp2.SAMWORKPLACE:ehp2. vermerkt werden.

:p.:hp5.Beispiel&colon.:ehp5.
:parml.
:pt.alte Anweisung&colon.
:pd.:cgraphic.SET RUNWORKPLACE=C&colon.&bsl.OS2&bsl.PMSHELL.EXE:ecgraphic.
:pt.neue Anweisungen&colon.
:pd.:cgraphic.SET RUNWORKPLACE=C&colon.&bsl.WPSAM&bsl.SAMMY.EXE
SET SAMWORKPLACE=C&colon.&bsl.OS2&bsl.PMSHELL.EXE:ecgraphic.
:eparml.

:p.:hp7.WPSam:ehp7. und :hp7.WPSamF:ehp7.
:p.Die Installation dieser DLL-Dateien ist etwas aufwendiger. Dazu mssen 2 neue Klassen in der
Workplace-Shell (und zwar in der
:link reftype=hd refid=DEFDT.Default-Arbeitsoberflche:elink.)
registriert werden. Diese heien :hp2.WPSam:ehp2. und :hp2.WPSamF:ehp2.
(Schreibweise beachten!). Dies geschieht in REXX mit dem Befehl :hp1.SysRegisterObjectClass:ehp1..

:note.Sollen aus einer beliebigen
:link reftype=hd refid=PRIVDT.privaten Arbeitsoberflche:elink.
weitere Arbeitsoberflchen gestartet werden knnen, so sind diese zwei Klassen auch dort zu registrieren.
Diese Vorgehensweise wird vom Installationsprogramm nicht untersttzt und mu durch ein REXX-Script
erzeugt werden.

.*----------------------------------------------------------
.*  Einrichten einer neuen Arbeitsoberflche
.*----------------------------------------------------------
:h1 id=EINREF.Einrichten einer neuen Arbeitsoberflche

.*-- Einfhrung ------------------------------------------
:hp2.Einfhrung:ehp2.

:p.Das Einrichten einer neuen Arbeitsoberflche richtet sich nach der Vorgehensweise des CUA-Standards&colon.
es mu nur eine Schablone aus dem Schablonenordner gezogen werden.

.*-- Erstellen einer neuen Benutzerumgebung -----------------------------------
:h2.Erstellen einer neuen Benutzerumgebung
:p.Das Erstellen einer neuen Arbeitsoberflche ist sehr einfach&colon. Es mu nur der
Schablonen-Ordner geffnet werden und eine :hp1.WPSam-Schablone:ehp1. irgendwohin gezogen
werden. Das System generiert dann eine neue Arbeitsoberflche. Teile dieser
Generierung werden erst beim ersten ffnen der neuen Arbeitsoberflche durchgefhrt. Bitte
haben Sie dabei etwas Geduld. Ab dem zweiten Mal wird dann sehr flink umgeschaltet.

:p.Obwohl einige Benutzer mglicherweise eine unordentliche Arbeitsoberflche bevorzugen,
macht es Sinn, wenigstens auf der
:link reftype=hd refid=ROOTDT.Stammarbeitsoberflche:elink. einen Ordner anzulegen, der
alle Benutzersymbole enthalten soll. Der beste Weg dazu ist es, ein
Unterverzeichnis anzulegen und eine Referenz dieses Verzeichnisses auf der
Arbeitsoberflche zu erstellen.

:p.Wenn Sie :hp4.WPSam:ehp4. mit dem Installationsprogramm installiert haben, dann ist dieser
Ordner bereits angelegt. Suchen Sie auf Ihrer Arbeitsoberflche den Ordner mit dem
Namen "Benutzer".

:p.:lm margin=5.
:font facename=Helv size=14x10.
:hp2.Fr den ungebten Benutzer&colon.:ehp2.
:ol compact.
:li.Den Schablonen-Ordner ffnen.
:li.Den Laufwerks-Ordner ffnen.
:li.Das Laufwerk ffnen, auf dem das Verzeichnis angelegt werden soll.
:li.Eine Ordner-Schablone vom Schablonen-Ordner auf das Laufwerk in das Unterverzeichnis
ziehen, in dem das neue Verzeichnis entstehen soll.
:li.Auf den Namen des neuen Verzeichnisses mit der rechten Maustaste klicken, whrend
die :hp1.Alt:ehp1. Taste festgehalten wird.
:li.Den Namen des Verzeichnisses von :hp1.Ordner:ehp1. in einen beliebigen Namen
umbenennen (z. B: Benutzer).
:li.Auf das neue Verzeichnis mit der rechten Maustaste klicken (d. h. das Kontextmen
des Objektes ffnen).
:li.:hp1.Referenz erstellen:ehp1. auswhlen.
:li.Aus der nun erscheinenden Liste :hp1.Arbeitsoberflche:ehp1. auswhlen.
:eol.
:font.
:lm margin=1.

.*-- Einstellen einer neuen Benutzerumgebung -------------------------------
:h2.Einstellen einer neuen Benutzerumgebung
:p.Nach dem ffnen des Einstellungen-Notizbuches eines Arbeitsoberflchensymbols erkennt
man die Seiten eines normalen :hp1.Ordners:ehp1.. Zustzlich sind zwei weitere
Indexzungen dazugekommen, :hp4.WPSam:ehp4. und :hp4.InitOS2:ehp4..
:hp4.WPSam:ehp4. seinerseits besteht aus insgesamt drei Seiten.

.*-- WPSam Einstellungen Seite 1 --------------------------------
:h2 scroll=none.WPSam Einstellungen Seite 1
:link reftype=hd res=001 auto split group=10
  vpx=left vpy=top vpcx=35% vpcy=100%
  scroll=vertical titlebar=none.
:link reftype=hd res=002 auto split group=11
  vpx=right vpy=top vpcx=65% vpcy=100%
  scroll=both titlebar=none.

.*   WPSam Einstellungen Seite 1: Secondary 1
:h2 res=001 group=10 hide.t2
:p.Das Bild zeigt die Einstellungsseite fr das Pawort im Einstellungs-Notizbuch
einer Arbeitsoberflche. Hier kann ein Pawort eingegeben, gendert bzw. aktiviert werden.
:p.Wenn der Auswahlknopf :hp1.Pawort aktivieren:ehp1. gedrckt wird, kann die
Arbeitsoberflche nur gestartet, gelscht bzw. gendert werden, wenn das Pawort
bekannt ist.
:p.Das Pawort kann nur gendert werden, wenn das alte bekannt ist, unabhngig vom Zustand
des :hp1.Pawort aktivieren:ehp1. Knopfes.
:p.Wird vom System das Vorhandensein eines :link reftype=hd refid=MAGSUPP.Magnetkartenlesers:elink. erkannt,
erscheinen ber den Eingabefeldern andere Texte.
Der Hinweis :hp1.Altes/Neues Pawort oder Magnetkarte:ehp1. deutet an, da auer einer
manuellen Paworteingabe auch das Durchziehen einer Magnetkarte durch den
Kartenleser erlaubt ist.

.*   WPSam Einstellungen Seite 1: Secondary 2
:h2 res=002 group=11 hide.t1
:artwork align=left name='USRPG1GR.BMP'.
:p.WPSam Notizbuchseite 1 der Arbeitsoberflcheneinstellungen.

.*-- WPSam Einstellungen Seite 2 --------------------------------
:h2 scroll=none.WPSam Einstellungen Seite 2
:link reftype=hd res=003 auto split group=10
  vpx=left vpy=top vpcx=35% vpcy=100%
  scroll=vertical titlebar=none.
:link reftype=hd res=004 auto split group=11
  vpx=right vpy=top vpcx=65% vpcy=100%
  scroll=both titlebar=none.

.*   WPSam Einstellungen Seite 2: Secondary 1
:h2 res=003 group=10 hide.t2
:p.Das Bild zeigt die zweite Einstellungsseite  im Einstellungs-Notizbuch einer Arbeitsoberflche.
Diese Seite umfat folgende Features&colon.
:ul.
:li.:hp2.Umbenennen:ehp2.&colon. Wenn aktiviert, kann der Name der Arbeitsoberflche gendert werden.
:li.:hp2.Verschieben:ehp2.&colon. Wenn aktiviert, kann das Symbol in einen anderen
Ordner verschoben werden.
:li.:hp2.Dropping:ehp2.&colon. Wenn aktiviert, knnen andere Symbole auf die
Arbeitsoberflche fallen gelassen werden.
Das heit, da andere Benutzer Symbole hinzufgen knnen, ohne das
Pawort zu kennen! Um Miverstndnissen vorzubeugen&colon. Das :hp4.WPSam:ehp4.-Symbol ist streng
genommen ein modifizierter Ordner. Wenn man ein Symbol hinzufgt, erscheint dieses nur
in diesem Ordner (man sieht es beispielsweise, wenn man die Symbolanzeige dieses Ordners ffnet).
Das Symbol wird :hp8.NICHT:ehp8. auf der zugehrigen Arbeitsoberflche erscheinen!
:eul.

:p.Die Umgebungsvariable, die auf dieser Seite eingegeben werden knnen, werden von
:link reftype=hd refid=LUMF.InitOS2:elink. und
:link reftype=hd refid=LUMF.Sammy:elink. ausgewertet.
Sie mssen in der Form :hp2.VARIABLE=INHALT:ehp2. eingegeben werden.
Umgebungsvariable, die in der Datei CONFIG.SYS standardmig eingetragen
sind, knnen gelscht werden, indem ein leerer Inhalt angegeben wird, also&colon.
:hp2.VARIABLE=:ehp2..

.*   WPSam Einstellungen Seite 2: Secondary 2
:h2 res=004 group=11 hide.t1
:artwork align=left name='USRPG2GR.BMP'.
:p.WPSam Notizbuchseite 2 der Arbeitsoberflcheneinstellungen.

.*-- WPSam Einstellungen Seite 3 --------------------------------
:h2 id=WPSE3 scroll=none.WPSam Einstellungen Seite 3
:link reftype=hd res=005 auto split group=10
  vpx=left vpy=top vpcx=35% vpcy=100%
  scroll=vertical titlebar=none.
:link reftype=hd res=006 auto split group=11
  vpx=right vpy=top vpcx=65% vpcy=100%
  scroll=both titlebar=none.

.*   WPSam Einstellungen Seite 3: Secondary 1
:h2 res=005 group=10 hide.t2
:p.Wenn eine Arbeitsoberflche das erste Mal gestartet wird, wird zumindest eine neue Benutzerprofildatei
:hp2.OS2.INI:ehp2. generiert. Die Generierung einer Systemprofildatei :hp2.OS2SYS.INI:ehp2.
hngt von der :hp1.Global/:link reftype=hd refid=PRIVDT.Privat:elink.:ehp1. Einstellung ab.
Die Quellen, die fr diesen Compiliervorgang genutzt werden, sind die zwei Dateien
:hp1.INI.RC:ehp1. und :hp1.INISYS.RC:ehp1. im OS2-Verzeichnis. Diese knnen direkt verwendet
werden oder den eigenen Bedrfnissen angepat werden.
Wenn jemanden beispielsweise das :hp1.WPPower:ehp1.-Symbol strt, weil er keinen PC mit Power-Management
besitzt, kann er die entsprechende Zeile aus der RC-Datei entfernen.
Wer sich etwas auskennt, kann auch das Aussehen der Windows-Arbeitsoberflche simulieren,
indem er sich eine neue RC-Datei aus :hp1.INI.RC:ehp1. und :hp1.WIN_30.RC:ehp1. erzeugt.
Es empfiehlt sich jedoch, nie die Originaldateien, sondern immer Kopien davon zu modifizieren!

:caution.Solche nderungen sollte jedoch wirklich nur jemand machen, der genau wei, was er tut!
Im Fall einer fehlerhaften .RC-Datei wird die gewnschte Arbeitsoberflche nicht gestartet oder der
Rcksprung zur Stammarbeitsoberflche funktioniert nicht mehr! Sollte dieser Fall wirklich
einmal eintreten, ist der Rechner neu zu starten und die fehlerhafte Arbeitsoberflche zu lschen!
:ecaution.
:p.Wenn die Generierung einer Arbeitsoberflche abgeschlossen ist (nach der ersten Aktivierung),
knnen die Einstellungen dieser Seite nicht mehr gendert werden!

:p.In manchen Fllen kann es von Interesse sein, eine Arbeitsoberflche auf verschiedenen
Maschinen (z. B. in einem Netzwerk) zu verwenden. Hier stt man mit dem Konzept zweier
Profildateien auf ein Problem, da diese zwei Dateien Informationen enthalten, die zusammengehren.
Angenommen, es wird auf einem Rechner nur ein System-Profil fr mehrere Arbeitsoberflchen verwendet.
Wenn eine dieser Arbeitsoberflchen nun ber ein Netzwerk auf einem anderen Rechner mit einem
anderen System-Profil verwendet wird, kann dies zu einem Systemfehler fhren.

:p.Um dies zu vermeiden, kann hier die Verwendung eines privaten System-Profiles
ausgewhlt werden. Da das Umschalten zwischen verschiedenen System-Profilen in einem laufenden
System von OS/2 nicht vorgesehen ist, knnen Arbeitsoberflchen mit privaten
System-Profilen nur von :link reftype=hd refid=LUMF.InitOS2:elink. aus gestartet werden.

.*   WPSam Einstellungen Seite 3: Secondary 2
:h2 res=006 group=11 hide.t1
:artwork align=left name='USRPG3GR.BMP'.
:p.WPSam Notizbuchseite 3 der Arbeitsoberflcheneinstellungen.


.*-- Init OS2 Einstellungen --------------------------------
:h2 scroll=none.Init OS2 Einstellungen
:link reftype=hd res=007 auto split group=10
  vpx=left vpy=top vpcx=35% vpcy=100%
  scroll=vertical titlebar=none.
:link reftype=hd res=008 auto split group=11
  vpx=right vpy=top vpcx=65% vpcy=100%
  scroll=both titlebar=none.

.*   Init OS2 Einstellungen: Secondary 1
:h2 res=007 group=10 hide.t2
:p.Diese Seite beinhaltet die Einstellmglichkeiten der Arbeitsoberflche fr das
Programm :link reftype=hd refid=LUMF.InitOS2:elink.. Hier wird beispielsweise der Typ der zu
startenden Arbeitsoberflche festgelegt.

:p.Der Default der ProtShell ist das Programm, das bei :hp4.InitOS2:ehp4. als Argument in
der Datei CONFIG.SYS steht. Dies ist normalerweise PMSHELL.EXE.

:p.Wird das Eingabefeld aktiviert, kann hier eine andere Shell eingegeben werden.
Normalerweise wird hier CMD.EXE vorgegeben. Dies bedeutet, da bei Start der Benutzer-ID
von :hp4.InitOS2:ehp4. aus nur ein OS/2-Gesamtbildschirm geffnet wird.

:p.Fr den Start einer PM-Oberflche ohne Workplace-Shell ist hier ebenfalls
:hp1.Default:ehp1. zu aktivieren. Zustzlich mu in Einstellungsseite 2 von WPSam
eine Umgebungsvariable :hp1.SAMWORKPLACE=x&colon.&bsl.OS2&bsl.CMD.EXE:ehp1. eingegeben werden.

:p.Eine Arbeitsoberflche kann von :hp4.InitOS2:ehp4. aus nur gestartet werden, wenn der Auswahlknopf
:hp1.Benutzer in 'Init OS/2' Men bernehmen:ehp1. aktiviert ist.

.*   Init OS2 Einstellungen: Secondary 2
:h2 res=008 group=11 hide.t1
:artwork align=left name='USRPG4GR.BMP'.
:p.Init OS2 Notizbuchseite der Arbeitsoberflcheneinstellungen.

.*----------------------------------------------------------
.*  Benutzung von InitOS2
.*----------------------------------------------------------
:h1.Benutzung von InitOS2
:p.:hp2.InitOS2:ehp2. erlaubt es, einen Rechner vor unbefugter Benutzung zu schtzen.
Voraussetzung dafr ist, da dieser ber ein BIOS verfgt, bei dem die
Boot-Reihenfolge C: A: eingestellt und die BIOS-Einstellungen per Pawort
gesichert werden knnen.

:p.Auerdem bietet :hp2.InitOS2:ehp2. die Mglichkeit, Sitzungen ohne
Workplace Shell bzw. ohne Presentation-Manager zu starten.
Durch entsprechende Modifikation der Umgebungsvariablen fr solche
Benutzerumgebungen kann sogar erreicht werden, da man aus einer solchen
Sitzung den PM auch nicht nachtrglich starten kann.
Diese Mglichkeiten sind z. B. wichtig, wenn an bestimmten Einsatzorten
vermieden werden soll, da der Benutzer des Rechners ein anderes als das
vorgesehene Programm starten kann.

.*-- Init OS2 Hauptfenster --------------------------------
:h2 scroll=none.InitOS/2 Hauptfenster
:link reftype=hd res=009 auto split group=10
  vpx=left vpy=top vpcx=52% vpcy=100%
  scroll=horizontal titlebar=none.
:link reftype=hd res=010 auto split group=11
  vpx=right vpy=top vpcx=48% vpcy=100%
  scroll=vertical titlebar=none.

.*   InitOS/2 Hauptfenster: Secondary 1
:h2 res=009 group=10 hide.t1
:artwork align=left name='INITMAIN.BMP'.
:p.InitOS/2 Hauptfenster

.*   InitOS/2 Hauptfenster: Secondary 2
:h2 res=010 group=11 hide.t2
:p.Das nebenstehende Bild zeigt das Fenster, mit dem sich :hp4.InitOS2:ehp4. nach
dem Startvorgang des Rechners meldet. Die Benutzung ist sehr einfach.
Um eine Benutzer-ID zu starten, ist lediglich in die zwei Eingabefelder
der Benutzername und gegebenenfalls das Pawort einzugeben. Nach Drcken
der Eingabetaste (oder des OK-Knopfes) wird der Benutzer gestartet.
:p.Die "Navigation" durch diese Dialogbox wurde an den CUA-Standard angelehnt.
So erreicht man das nchste Eingabefeld oder einen Knopf mit der Tabulatortaste.
:p.Folgende Knpfe sind vorhanden&colon.
:ul.
:li.OK&colon. Starten der Benutzerumgebung. Dies ist der Default-Knopf und wird auch mit
der Return-Taste erreicht, wenn sich der Cursor auf einem der Eingabefelder
befindet.
:li.Default starten&colon. :hp2.InitOS2:ehp2. lt es zu, eine
Default-Benutzerumgebung zu definieren.
Diese kann nach einer einstellbaren Zeit
automatisch gestartet werden, wenn der Benutzer keine Eingaben vornimmt.
Sie kann auch durch Drcken dieses Knopfes oder der
F2-Taste sofort gestartet werden.
:li.Setup&colon. Dieser Knopf startet eine Dialogbox, die fr den Systemverwalter
vorgesehen ist und die deshalb mit einem Pawort gesichert werden kann.
Setup kann auch durch Drcken von F9 gestartet werden.
:li.Systemabschlu&colon. Dieser Knopf (auch ber die F10-Taste erreichbar) bereitet
den Rechner zum Ausschalten vor.
:eul.
:p.Wird vom System das Vorhandensein eines :link reftype=hd refid=MAGSUPP.Magnetkartenlesers:elink.
 erkannt, wird der Text :hp1.Pawort:ehp1. abgendert in :hp1.Pawort oder Magnetkarte:ehp1..
In diesem Fall kann statt der manuellen Paworteingabe auch eine Magnetkarte durch
den Leser gezogen werden.
Wurde kein Benutzer angegeben, wird automatisch nach dem ersten passenden gesucht und dieser gestartet.

.*-- Init OS2 Setup --------------------------------
:h2 scroll=none.InitOS/2 Setup
:link reftype=hd res=011 auto split group=10
  vpx=left vpy=top vpcx=40% vpcy=100%
  scroll=horizontal titlebar=none.
:link reftype=hd res=012 auto split group=11
  vpx=right vpy=top vpcx=60% vpcy=100%
  scroll=vertical titlebar=none.

.*   InitOS/2 Setup: Secondary 1
:h2 res=011 group=10 hide.t1
:p.:artwork align=left name='INITPWD.BMP'.
:p.InitOS/2 Administrator-Pawort

:p.:artwork align=left name='INITSET.BMP'.
:p.InitOS/2 Setup

.*   InitOS/2 Setup: Secondary 2
:h2 res=012 group=11 hide.t2
:p.Wird im Hauptfenster :hp1.Setup:ehp1. gedrckt, erscheint das Pawortfeld
fr das Systemverwalter-Pawort (falls eines existiert). Nach korrekter Eingabe wird die
Setup-Dialogbox gestartet.
:p.Das Setup-Fenster enthlt folgende Einstellmglichkeiten&colon.
:ul.
:li.:hp1.Default-Benutzer&colon.:ehp1. Hier wird die Arbeitsoberflche eingestellt,
die automatisch gestartet wird, wenn innerhalb der Timeout-Zeit keine Taste
gedrckt wird.
:li.:hp1.Timeout&colon.:ehp1. Nach dieser Zeit wird die
Default-Benutzerumgebung gestartet, wenn keine Taste gedrckt wird. Ist eines der Felder
:hp1.Default-Benutzer:ehp1. bzw. :hp1.Timeout:ehp1. leer, ist
dieses Feature deaktiviert.
:li.:hp1.Administrator-Pawort / Wiederholung&colon.:ehp1. Hier kann ein
Systemverwalter-Pawort eingegeben werden. Um Schreibfehler zu erkennen,
mu dieses zwei mal erfolgen.
:li.:hp1.OK&colon.:ehp1. Hiermit wird die Dialogbox beendet. Die
:link reftype=hd refid=DEFDT.Default-Arbeitsoberflche:elink.
und das Administrator-Pawort werden gesichert. Dieser Knopf ist der Default-Knopf und kann
daher mit der Eingabetaste erreicht werden.
:li.:hp1.Pawort lschen&colon.:ehp1. Wurde in den zwei Pawort-Feldern kein
Pawort vor dem Beenden der Dialogbox eingegeben, behlt :hp4.InitOS2:ehp4. das alte Pawort.
Dieses lt sich durch Drcken dieser Taste lschen.
:li.:hp1.Abbruch&colon.:ehp1. Nach Drcken dieser Taste wird die Dialogbox geschlossen, ohne die
eingestellten Werte zu bernehmen. Diese Taste kann auch durch Drcken von
Escape erreicht werden.
:eul.

.*----------------------------------------------------------
.*  Benutzung von WPSam
.*----------------------------------------------------------
:h1.Benutzung von WPSam
:p.Die Benutzung des Programmes ist sehr einfach; die Bedienung entspricht
voll dem CUA 91-Standard.

:p.Das Konzept wurde ebenfalls an den brigen Aufbau der Workplace Shell
angelehnt. So wird jede Arbeitsoberflche durch ein Symbol reprsentiert. Dieses
Symbol stellt ein Objekt der Klasse
:link reftype=hd refid=LUMF.WPSam:elink. dar, das von einem normalen
Ordner abgeleitet wurde. Man erkennt dies daran, da die Einstellungen eines
solchen Objektes dieselben Seiten wie die eines Ordners enthalten. Es wurden
lediglich einige fr die Funktion des Programmes notwendige Seiten hinzugefgt.
Wird eine solche "Benutzer-Arbeitsoberflche" als Symbolanzeige geffnet, erkennt man
darin einige Dateien, die fr den Betrieb einer Arbeitsoberflche wichtig sind.
Fr :link reftype=hd refid=WPSE3.globale Arbeitsoberflchen:elink.
 ist dies die Benutzerprofildatei :hp2.OS2.INI:ehp2. sowie der
Arbeitsoberflchen-Ordner :hp1.Arbeitsoberflche_Benutzer:ehp1..

:p.Diese Dateien werden automatisch generiert, wenn die Arbeitsoberflche das erste Mal
gestartet wird. Sie werden auch fr Benutzerumgebungen vom
:link reftype=hd refid=LUMF.Typ 1 (OS/2-Gesamtbildschirm-Benutzer):elink. bzw.
fr :link reftype=hd refid=LUMF.Typ 2 (Presentation-Manager-Benutzer):elink.
bentigt. Der Grund ist der, da man prinzipiell durch Aufruf von PMSHELL
jederzeit die Workplace Shell aus einer solchen Benutzerumgebung starten kann.
Sind diese Dateien noch nicht vorhanden, gilt die Benutzerumgebung als noch
:hp1.nicht initialisiert:ehp1..

:h2.Starten einer Benutzer-Arbeitsoberflche
:p.Zum Start einer Arbeitsoberflche einfach doppelt auf das
Benutzersymbol klicken. Wenn dieses nicht
durch ein Pawort geschtzt ist, wird die Arbeitsoberflche sofort gestartet.
Wenn es sich um den ersten Start der Arbeitsoberflche handelt, werden zuerst die
erforderlichen :hp1.INI:ehp1.-Dateien generiert.

:p.:hp1.WPSam:ehp1. prft nicht den Typ einer Benutzerumgebung, sondern startet
:hp6.immer:ehp6. die Workplace Shell. Andere Typen knnen nur mit :hp1.InitOS2:ehp1.
gestartet werden.

:p.Ist eine Arbeitsoberflche durch ein Pawort gesichert, erscheint ein
Dialogfenster, in dem nach dem Pawort gefragt wird. Der Start wird
(natrlich!) verweigert, wenn das falsche Pawort eingegeben wurde. Der Fehlversuch wird
auerdem protokolliert.

:h2.Rckkehr zur Stammarbeitsoberflche
:p.Fr die Rckkehr in die
:link reftype=hd refid=ROOTDT.Stammarbeitsoberflche:elink. mu das Kontextmen der
Arbeitsoberflche (durch Klicken mit der rechten Maustaste
auf eine leere Flche der Arbeitsoberflche) geffnet und der Menpunkt
:hp1.Stammarbeitsoberflche:ehp1. ausgewhlt werden (siehe das folgende Bild).

:artwork align=center name='DTCTXGR.BMP'.

Nach einer Sicherung der aktuellen Arbeitsoberflche wird diese geschlossen und
auf die Stammarbeitsoberflche gewechselt.

:h2.Einsehen des Protokolles
:p.Jeder erfolgreiche oder nicht erfolgreiche Start einer Benutzerumgebung wird
automatisch protokolliert. Die letzten 100 Vorgnge knnen so jederzeit nachvollzogen
werden. Dies geschieht durch ffnen der :hp1.Einstellungen:ehp1. des WPSam-Symbols.
Wird dort der Index :hp1.Datei:ehp1. ausgewhlt, erscheint auf Seite 3
das Protokoll-Feld.

.*----------------------------------------------------------
.*  Magnetkartenuntersttzung
.*----------------------------------------------------------
:h1 id=MAGSUPP.Magnetkartenuntersttzung
:p.Die Paworteingaben des Systems knnen alternativ ber einen Magnetkartenleser
erfolgen. Voraussetzung ist das Vorhandensein einer DLL-Datei :hp1.MAGCALLS.DLL:ehp1..
Diese gehrt zum Lieferumfang der OS/2-Untersttzung der Kartenleser.
Getestet wurden die Gerte der Firmen IBM (4717) und DESKO (MSL4717-x).
Geeignet sind alle Magnetkarten, bei denen die Spur 2 beschrieben ist.
Hierfr knnen spezielle Karten der Firma DESKO verwendet werden, es reicht jedoch
jede handelsbliche Karte, wie EC-Karte oder eine Kreditkarte.
Werden andere Karten (wie Kantinenkarten o. .) eingesetzt, ist sicherzustellen, da der Inhalt
von Spur 2 nie verndert wird.
Ist der Inhalt der Spur 2 bekannt, kann die Paworteingabe auch von Hand durch Eingabe
der Daten dieser Spur erfolgen.
Bei Kreditkarten ist dies jedoch nicht praktikabel, da das Pawort sehr lang ist.

:p.:hp4.InitOS2:ehp4. ist in der Lage, eine Benutzerumgebung anhand des Pawortes zu erkennen, das ber eine
Magnetkarte eingegeben wurde.
Wird dieselbe Karte jedoch fr mehrere Benutzerumgebungen verwendet, wird immer die (alphabetisch) erste
gestartet.

.*----------------------------------------------------------
.*  Geplante Erweiterungen
.*----------------------------------------------------------
:h1.Geplante Erweiterungen
:p.Es gibt noch viele Ideen fr Erweiterungen, die in die nchsten Versionen von
:hp4.WPSam:ehp4. einflieen werden. Vor allem :hp4.InitOS2:ehp4. ist ein sehr
neues Programm, so da hier sicher noch einige wnschenswerte Eigenschaften fehlen.
Hier einige Beispiele&colon.
:ul compact.
:li.Der Window-Manager von InitOS2 soll um einige Controls erweitert werden.
So soll eine Listbox dazu dienen, die Auswahl von Benutzernumgebungen (vor allem mit langen Namen)
zu vereinfachen.
Auerdem sollen die Farben einstellbar gemacht werden.
:li.Der Parser der Umgebungsvariablen soll so erweitert werden, da er %var%-Variable
versteht.
:li.Ein interaktives Programm soll die Generierung von .RC-Files ermglichen.
:eul.

:p.Falls Sie ebenfalls irgendwelche Features vermissen, zgern Sie bitte nicht,
diese uns mitzuteilen.

.*----------------------------------------------------------
.*  Registrierung
.*----------------------------------------------------------
:h1.Registrierung

:p.:p.:hp4.WPSam:ehp4. ist keine Shareware! Trotzdem wollen wir interessierten Anwendern
die Mglichkeit geben, die Software zu testen. Aus diesem Grund wird :hp4.WPSam:ehp4.
als vollstndiges Produkt verteilt. Er umfat fr nicht
registrierte Benutzer jedoch nur die Berechtigung zum Testen der Applikation.
Es knnen beliebig viele Arbeitsoberflchen angelegt werden, diese arbeiten aber
nur 21 Tage lang. Wenn Ihnen das Programm gefllt, mssen Sie diese
Arbeitsoberflchen nicht lschen. Nach der Registrierung von :hp4.WPSam:ehp4.
funktionieren sie wieder.

:p.Wenn Sie das Programm :hp4.WPSam:ehp4. registrieren, knnen Sie mit dem von uns
gelieferten Pawort die aktuelle, sowie die nachfolgende Version von :hp4.WPSam:ehp4.
verwenden.
Dies erlaubt einen schnellen Update ber Internet und Fido-net.

:p.Wenn Sie keinen Hndler kennen, der :hp4.WPSam:ehp4. vorrtig hat, dann knnen Sie
Einzellizenzen auch direkt bei uns bestellen. Dabei bieten wir Schlern,
Studenten und Rentnern, gegen entsprechenden Nachweis und ausschlielich per
Vorkasse, eine besonders gnstige Lizenz an. Fr Firmen und ffentliche
Einrichtungen gelten gnstige Staffelpreise. Bitte fragen Sie
schriftlich oder per FAX an.

.*   Registriervorgang
:h2.Registriervorgang

:p.Den Punkt :hp1.Produktinformation:ehp1. im Kontextmen eines
Benutzersymbols oder der Schablone im Schablonenordner auswhlen.
Wenn die Version auf dem Rechner noch nicht registriert ist, wird in
dem erscheinenden Fenster nach einem Namen und einem Registrierpawort gefragt
(siehe Bild).

:artwork align=center name='REGGR.BMP'.

Wenn diese zwei Zeilen korrekt eingegeben wurden, erscheint in Zukunft in diesem
Fenster nur noch der Name, fr den das Programm registriert wurde.

:p.Der Name mu korrekt eingegeben werden, da das Pawort daraus abgeleitet wurde.
Auch die Leerzeichen mssen exakt eingegeben werden. Gro- und Kleinschreibung
des Names ist jedoch ohne Belang. Das Pawort erhalten Sie von uns nach Bezahlung
der Registriergebhr.

:p.Das Pawort ist ziemlich lang (14 Zeichen), weil es den Namen, die Seriennummer
und die Versionsnummer enthlt.

.*   Bestellformular
:h2.Bestellformular

:lm margin=5.
:lines.
                                        ___________________, den ___.____.____




Noller &amp. Breining Software
Tannenstrasse 18

D-71554 Weissach im Tal



:hp2.Bestellung:ehp2.

Ich bestelle hiermit die aktuelle Version von WPSam. Ich wei, da
dieses Programm ohne jede Art von Garantie herausgegeben wird.:elines.
:p.Der gewnschte Lizenztyp ist&colon.:dl compact tsize=5.
:dt.:artwork runin name='sq.bmp'.
:dd.Schler/Student/Rentner (DM 20.--).
:dt.:artwork runin name='sq.bmp'.
:dd.persnliche Lizenz (DM 60.--).
:edl.
:p.Bitte senden Sie mir die Software auf:dl compact tsize=5.
:dt.:artwork runin name='sq.bmp'.
:dd.3" Diskette oder
:dt.:artwork runin name='sq.bmp'.
:dd.5" Diskette zu.
:edl.
:p.Die Bezahlung des Preises kann &colon.:dl compact tsize=5.
:dt.:artwork runin name='sq.bmp'.
:dd.per Vorkasse oder
:dt.:artwork runin name='sq.bmp'.
:dd.gegen Rechnung erfolgen.
:edl.
:p.Bei persnlichen Lizenzen fr Schler und Studenten mssen wir aber
(aufgrund des geringen Betrages) auf Vorkasse per Scheck oder Geldschein
bestehen. Wir akzeptieren in diesem Fall keine auslndischen Schecks.
:p.Bitte senden Sie sie an folgende Adresse&colon.
:cgraphic.:font facename=Courier size=10x10.
Name, Vorname&colon.             ___________________________________________

Strae, Nr.&colon.               ___________________________________________

PLZ, Stadt&colon.                ___________________________________________

Land&colon.                      ___________________________________________
:ecgraphic.

:p.:font facename=Courier size=10x10.__________________________________:font.
:p.(Unterschrift, Datum)                                               V 3.0
:lm margin=1.

.*----------------------------------------------------------
.*  Versionen
.*----------------------------------------------------------
:h1.Versionen
:cgraphic.:hp2.
   3.0  Untersttzung der SOM 2 Runtime.

   2.1  Untersttzung von Magnetkartenlesern.

   2.0  Auslieferung von SAMMY und INITOS2. Die Umschaltung auf andere
        Benutzer wurde abgendert.

   1.2  Deutsche Version verfgbar. Entfernen der "20 Sekunden-Pause".
        Erster Release von InitOS2 zusammen mit WPSam.

   1.2 Benutzer-Arbeitsoberflchen sichern ihre Fensterpositonen.
        Umorganisation der erweiterten Attribute. Registrierfhigkeit.

   1.1  Workplace Shell Untersttzung fr OS/2 2.x

   1.0  Erste ffentliche Version von SAM fr OS/2 1.x.
:ehp2.:ecgraphic.
:euserdoc.
