/* ----------------------------------------------------------
** BASIC.CMD
** The Secure Workplace for OS/2
** Creates the Sign-ON, Sign-OFF, and Shutdown Objects
** on the desktop
**
** NOTE: Change the ICONFILE path if you use a
**       different Install Directory
** ---------------------------------------------------------*/
'@echo off'

/* ---------------------------------------------------------
** Load the REXX Utility functions
** --------------------------------------------------------*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* ---------------------------------------------------------
** Create the Shutdown Object on the desktop
** --------------------------------------------------------*/
class    = "WPProgram"
location = "<WP_DESKTOP>"
title    = "System Shutdown"
setup    = "EXENAME=shutdown.exe;PARAMETERS=/NOLOGO /NOPROMPT;PROGTYPE=PM;OBJECTID=<SWU_SHUTDOWN>;"
action   = "R"
result   = SysCreateObject(class, title, location, setup, action)

/* ---------------------------------------------------------
** Create the Sign OFF Object on the desktop
** --------------------------------------------------------*/
class    = "WPAbstract"
location = "<WP_DESKTOP>"
title    = "Sign-OFF"
setup    = "ICONFILE=C:\SWP\BIN\SIGNOFF.ICO;OBJECTID=<SWU_LOGOFF>;"
action   = "R"
result   = SysCreateObject(class, title, location, setup, action)

/* ---------------------------------------------------------
** Create the Sign-ON Object on the desktop
** --------------------------------------------------------*/
class    = "WPAbstract"
location = "<WP_DESKTOP>"
title    = "Sign-ON"
setup    = "ICONFILE=C:\SWP\BIN\SIGNOFF.ICO;OBJECTID=<SWU_LOGON>;"
action   = "R"
result   = SysCreateObject(class, title, location, setup, action)

 