/*********************************************************************/
/* Installation script for eM Bee 3: Junior! 							   */
/*  (c) 1998 Jan-Helge Bergesen													*/
/*********************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'

call SysLoadFuncs

/*
	Initiate some global vars.
*/
GLOBVAR='Testvar'

SAY '[1;44;37m'
call SysCls
SAY 'Welcome to the installation of [33meM Bee 3: Junior![37m                               '
SAY '-------------------------------------------------------------------------------'
SAY '[0m This script will perform the following tasks:'
SAY '   [36m*[0m Copy the files to a specified location (optional)'
SAY '   [36m*[0m Create a folder on the desktop for Junior!'
SAY '   [36m*[0m Create program objects'
SAY '   [36m*[0m Create a shadow of Junior!''s program object in your startup folder'
SAY ' '
SAY '[1;37;41m Do you wish to continue?( Y/N )[0m[1m'

PULL ans

if ans='Y' then
	do
		call FileCopy
      call CreateFolder
		Val='OBJECTID=<WP_MB3JRPRG>;EXENAME='f.1
		/** Working DIR ?? */
		IF SysCreateObject( 'WPProgram', 'eM Bee 3: Junior!', '<WP_MB3JR>', Val ) THEN
			DO
				Val='EXENAME=VIEw.EXE;PARAMETERS='f.2
				IF SysCreateObject( 'WPProgram', 'eM Bee 3: Help!', '<WP_MB3JR>', Val ) THEN
					DO
						Val=f.3
						IF SysCreateShadow( Val, '<WP_MB3JR>' ) THEN
							DO
								Val=f.4
								IF SysCreateShadow( Val, '<WP_MB3JR>' ) THEN
									IF f.5\='' THEN
									DO
										Val=f.5
                              RC = SysCreateShadow( Val, '<WP_MB3JR>' )
									END
							END
						ELSE
							SAY '[1;37;41mFailed when creating objects[0m'
					END
				ELSE
					SAY '[1;37;41mFailed when creating objects[0m'
			END
		ELSE
			SAY '[1;37;41mFailed when creating objects[0m'
		
		SAY '[1;37;41mWould you like a shadow of the program object in you startup folder? ( Y/N )[0m[1m'
		PULL ans
		IF ans = 'Y' THEN
			IF SysCreateShadow( '<WP_MB3JRPRG>', '<WP_START>' ) THEN
				SAY '[1;37;42mStartup folder updated![0m'
			ELSE
				SAY '[1;37;41mStartup folder [33mNOT[37m updated![0m'
	end
else
	do
		SAY ' '
		SAY 'Oh, well... another time then maybe??[0m'
	end

/***** clean up our mess **********************************************/
call SysDropFuncs
EXIT


/**********************************/
/* File copy routine 				 */
/**********************************/
FileCopy: procedure expose f.
EXE_NAME = 'MB3Jr.EXE'
EXE_LOC = 'C:\os2\apps'
DLL_NAME = 'MB3DLL.DLL'
DLL_LOC = EXE_LOC
INF_NAME = 'MB3Jr.INF'
INF_LOC = DLL_LOC
SRC_NAME = 'Src.ZIP'

		call SysCls
		SAY '[1;44;37mFile copying                                                                   '
		SAY '-------------------------------------------------------------------------------'
		SAY '[0m'
		SAY '[1;42;37mShould the files be copied somewhere else?( Y/N )'
		SAY '[ N = this is the right directory ][0m[1m'
		PULL Should
		if Should = 'Y' then
			do
				SAY ' '
				SAY 'Where would you like the program itself ('EXE_NAME') to be located?'
				SAY 'Default: [1m'EXE_LOC'[0m'
				SAY '[1;42;37mChange this? ( Y/N )[0m[1m'
				PULL Should
				IF Should='Y' then
				DO
					Should = 'G'
					DO WHILE Should \= 'Y'
						SAY '[1;41;37mEnter new location:[0m[1m'
						PARSE PULL EXE_LOC
						DLL_LOC = EXE_LOC
						INF_LOC = EXE_LOC
						SAY ' '
						SAY ' 'EXE_NAME'-> ' EXE_LOC
						SAY '[1;41;37mThis correct?( Y/N )[0m[1m'
						PULL Should
					end
				END
				SAY ' '
				SAY 'Would you like the hook DLL ('DLL_NAME') to be placed in a separate directory?'
				SAY '(this must be listed in your LIBPATH in config.sys)'
				SAY 'Default: [1m'DLL_LOC'[0m'
				SAY '[1;42;37mChange this? ( Y/N )[0m[1m'
				PULL Should
				IF Should = 'Y' THEN
				DO
					Should='g'
					DO WHILE Should \= 'Y'
						SAY '[1;41;37mEnter new location:[0m[1m'
						PARSE PULL DLL_LOC
						SAY ' '
						SAY ' ' DLL_NAME ' -> ' DLL_LOC
						SAY '[1;42;37mThis correct?( Y/N )[0m[1m'
						PULL Should
					end
				END
				SAY ' '
				SAY 'Would you like the help ('INF_NAME') to be placed in a separate directory?'
				SAY '(this must be listed in your BOOKSHELF in config.sys)'
				SAY 'Default: [1m'INF_LOC'[0m'
				SAY '[1;42;37mChange this? ( Y/N )[0m[1m'
				PULL Should
				IF Should = 'Y' THEN
				DO
					Should='g'
					DO WHILE Should \= 'Y'
						SAY '[1;41;37mEnter new location:[0m[1m'
						PARSE PULL INF_LOC
						SAY ' '
						SAY ' ' INF_NAME ' -> ' INF_LOC
						SAY '[1;42;37mThis correct?( Y/N )[0m[1m'
						PULL Should
					end
				END
				call SysCls
				SAY "[1;44;37mPerforming copy                                                                "
				SAY '-------------------------------------------------------------------------------[0m'
				call TestAllFilesPresent
				SAY 'All files in distribution accounted for!'
				call TestCreate( EXE_LOC )
				SAY 'Copy: 'EXE_NAME' to 'EXE_LOC
				ADDRESS CMD '@copy 'EXE_NAME' 'EXE_LOC
				IF DLL_LOC \= EXE_LOC THEN
					DO
						call TestCreate( DLL_LOC )
					END
				SAY 'Copy: 'DLL_NAME' to 'DLL_LOC
				ADDRESS CMD '@copy 'DLL_NAME' 'DLL_LOC
				IF INF_LOC \= EXE_LOC THEN
					DO
						call TestCreate( INF_LOC )
					END
				SAY 'Copy: 'INF_NAME' to 'INF_LOC
				ADDRESS CMD '@copy 'INF_NAME' 'INF_LOC
				SAY 'Copy: 'LICENCE.TXT' to 'EXE_LOC
				ADDRESS CMD '@COPY LICENCE.TXT 'EXE_LOC
				SAY 'Copy: 'READ.ME' to 'EXE_LOC
				ADDRESS CMD '@COPY READ.ME 'EXE_LOC
				SAY ' '
				SAY '[1;42;37mShould the source-code be unzipped?( Y/N ) ( req. unzip ) [0m[1m'
				PULL Should
				IF Should = 'Y' THEN
					DO
						SAY '[1;42;37mWhere to?[0m[1m'
						PARSE PULL UzHere
						ADDRESS 'unzip src.zip -d 'UzHere
					END
				ELSE
					DO
						UzHere='NO_GO'
						SAY '[1;42;37mCopy the source code archive be copied somewhere?(Y/N)'
						PULL a
						IF a='Y' THEN
							DO
								CpyHere = EXE_LOC
								SAY '[1;42;37mCopy to 'CpyHere'? (Y/N)[0m[1m'
								PULL a
								IF a \= 'Y' THEN
									PARSE PULL CpyHere
								
								ADDRESS CMD '@copy src.zip 'CpyHere
							END
						ELSE
							CpyHere='NO_GO'
					END
					f.1=EXE_LOC'\'EXE_NAME
					f.2=INF_LOC'\'INF_NAME
					f.3=EXE_LOC'\LICENCE.TXT'
					f.4=EXE_LOC'\Read.Me'
					IF UzHere\='NO_GO' THEN
						DO
							f.5=UzHere
							f.6='unzipped'
						END
					ELSE
						DO
							f.5=CpyHere'\Src.Zip'
							f.6='Copied'
						END
				return
			end
		else
        do
            TMP=DIRECTORY()
            f.1=TMP'\'EXE_NAME
            f.2=TMP'\'INF_NAME
            f.3=TMP'\'LICENCE.TXT
            f.4=TMP'\'Read.Me
            f.5=TMP'\'src.zip
            f.6='Copied'
        end
			return

TestCreate: procedure
	arg DIR_TO_CREATE
		RC = SysFileTree( DIR_TO_CREATE, EXEL, 'D' )
		IF EXEL.0 = 0 THEN
		DO
			SAY '[1;41;37m'DIR_TO_CREATE' doesn''t seem to exist![0m[1m'
			SAY '[1;41;37mCreate 'DIR_TO_CREATE'?( Y/N)[0m[1m'
			PULL Should
			IF Should='Y' THEN
				DO
					RC=SysMkDir(DIR_TO_CREATE )
					IF RC \= 0 THEN
					DO
						SAY '[1;41;37mFailed to create dir..bailing out[0m'
						Exit 2
					END
			   END
			ELSE
				DO
					SAY '[1;41;37mCannot continue..bailing out[0m'
					Exit 2
				END
		END		
	return

TestAllFilesPresent: procedure
	Files.1='MB3Jr.EXE'
	Files.2='MB3DLL.DLL'
	Files.3='MB3Jr.INF'
	Files.4='LICENCE.TXT'
	Files.5='SRC.zip'
	Files.6='Read.Me'
	
	DO I=1 to 6
		RC = SysFileTree( Files.I , Found , 'F' )
		IF Found.0 = 0 THEN
		DO
			SAY '[1;41;37mThe file 'Files.I' couldn''t be found!'
			SAY 'Please obtain a proper copy of eM Bee 3:Junior![0m'
			Exit
		END
	END
	return

CreateFolder: procedure
		IF SysCreateObject( 'WPFolder', 'eM Bee 3: Junior!', '<WP_DESKTOP>', 'OBJECTID=<WP_MB3JR>', 'replace' ) THEN
			SAY '[1;42;37mFolder created successfully[0m[1m'
		ELSE
			DO
				SAY '[1;41;37mCouldn''t create folder...bailing out[0m[1m'
				Exit 3
			END
	return
			

