/* retrieve ThinkPad X220T hid report descriptor */
rc=RxFuncAdd('SysGetMessage','RexxUtil','SysGetMessage')

/* obtain device driver name */
parse upper arg ddName SuperfluousArguments
if ddName = '' then ddName = '$X220TD$'

/* verify that the direct control driver exists in config.sys */
if stream(ddName,'command','query exists') \= '\DEV\' || ddName
then do
  say 'DEVICE=?:\OS2\BOOT\USBECD.SYS required in CONFIG.SYS'
  /* wait */
  '@pause'
  exit
  end

/* acquire the device driver */
rc=stream(ddName,'command','open')
if rc \= 'READY:'
then do
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddName)
  say 'acquire driver failed!'
  /* wait */
  '@pause'
  exit
  end

/* get hid class report descriptor */
oiBuffer = substr(x2c(81 06 00 22 00 00 00 01),1,8+256,x2c(EE))
oiHeader = 'GetDescriptor: HID Report'
call IssueWriteFunction
/* wait */
'@pause'

ofn = 'rtablet.bin'
'@if exist' ofn 'del' ofn
ofs = c2d(substr(oiBuffer,7,1))

/* put hid class report descriptor */
call charout ofn, substr(oiBuffer,9,ofs)
say 'Report Descriptor written to' ofn
/* wait */
'@pause'

/* release the device driver */
rc=stream(ddName,'command','close')
exit

IssueWriteFunction:
/* usb control transfer */
say
say oiHeader
say c2x(oiBuffer) /* show supplied data */
rc=charout(ddName,oiBuffer) /* supply and obtain setup and data packet */
say c2x(oiBuffer) /* show obtained data */
say

CheckCompletionCode:
/* check completion code */
rc=stream(ddName,'description')
if rc \= 'READY:'
then do
  say oiHeader' - failure!'
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddName)
  /* wait */
  '@pause'
  exit
  end
return
