/* Sony Vaio Pro13 Touch events to xsmouse.sys */
rc=RxFuncAdd('SysGetMessage','RexxUtil','SysGetMessage')

/* set log file name */
ddNameR='afinger.log'

/* report afinger.cmd started */
info='<============<afinger.cmd> started on <'||date()||'> at <'||time()'>============>'
rc=lineout(ddNameR,info) ; say info

/* set device driver names */
ddNameI='$FINGER$' ; ddNameO='XSMOUSE$'

/* verify that the direct control driver exists in config.sys */
if stream(ddNameI,'command','query exists') \= '\DEV\' || ddNameI
then do
  info='DEVICE=?:\OS2\BOOT\USBECD.SYS required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* acquire the direct control driver */
rc=stream(ddNameI,'command','open write')
if rc \= 'READY:'
then do
  info=rc||' Device driver '||ddNameI||' currently in use. Please try later.'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* set configuration - configured */
rc=charout(ddNameI,x2c(00 09 01 00 00 00 00 00))
rc=stream(ddNameI,'description')
if rc \= 'READY:'
then do
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameI)
  say 'set configuration failed!'
  /* wait */
  '@pause'
  exit
  end

/* verify that the emulate mouse driver exists in config.sys */
if stream(ddNameO,'command','query exists') \= '\DEV\' || ddNameO
then do
  info='DEVICE=?:\OS2\BOOT\XSMOUSE.SYS required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* acquire the emulate mouse driver */
rc=stream(ddNameO,'command','open')
if rc \= 'READY:'
then do
  info=rc||' Device driver '||ddNameO||' currently in use. Please try later.'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* set finger fixed extends */
xMinFinger=0 ; xMaxFinger=4095
yMinFinger=0 ; yMaxFinger=4095

/* initialize mouse events */
But1Down=x2c(0600) ; But2Down=x2c(1800)
But3Down=x2c(6000) ; ButsDown=x2c(1E00)
MoveOnly=x2c(0100) ; NoButMov=x2c(0000)

/* set screen fixed extends */
xMaxScreen=1920 ; yMaxScreen=1080

/* move cursor to center */
xMin=0 ; xMax=xMaxScreen ; xPos=trunc(xMax/2)
yMin=0 ; yMax=yMaxScreen ; yPos=trunc(yMax/2)
xMaxOut=reverse(d2c(xMaxScreen,2))
yMaxOut=reverse(d2c(yMaxScreen,2))
call xsMouse(MoveOnly)
ButzDown=But2Down

/* use finger extends */
xMin=xMinFinger ; xMax=xMaxFinger
yMin=yMinFinger ; yMax=yMaxFinger

/* initialize */
oiBuffer = substr(x2c(EC 00 00 00 81 03 40 00),1,8+64,x2c(EE))

/* catch these here to release the mouse */
signal on error; signal on failure; signal on halt;
signal on novalue; signal on syntax;

do forever
  call GetPacket
  event=substr(oiBuffer,10,3)
  xPos=c2d(reverse(substr(oiBuffer,13,2)))
  yPos=c2d(reverse(substr(oiBuffer,15,2)))
  cntr=c2d(reverse(substr(oiBuffer,61,2)))
  used=c2d(left(event,1)) /* fingers */
  if cntr==0 & used==1 then ButzDown=But2Down
  if cntr==0 & used==2 then ButzDown=ButsDown
  select
    when event==x2c(010000) then call xsMouse(NoButMov)
    when event==x2c(010001) then iterate
    when event==x2c(010100) then call xsMouse(But1Down)
    when event==x2c(010101) then iterate
    when event==x2c(020000) then call xsMouse(NoButMov)
    when event==x2c(020100) then call xsMouse(ButzDown)
    otherwise call Unknown
    end
  end

/* cleanup */
signal ProcessComplete
exit

GetPacket:
rc=charout(ddNameI,oiBuffer)
rc=stream(ddNameI,'description')
if rc \= 'READY:'
then do
  /* obtain error message */
  parse value rc with sState ':' mNumber
  if mNumber == 95 /* character i/o call interrupted */
  then rc=stream(ddNameI,'command','open') /* retry */
  else do
    /* issue error message */
    say SysGetMessage(mNumber,,ddNameI)
    say 'get finger packet failed!'
    /* wait */
    '@pause'
    exit
    end
  end
return

Unknown:
/* show packet */
packet=c2x(substr(oiBuffer,9))
output='Packet='||packet||',Huh?'
rc=lineout(ddNameR,output)
say output
return

xsMouse:
parse arg EvntFlgs
/* calculate current screen position */
xCur=trunc(((xPos-xMin)*xMaxScreen)/(xMax-xMin))
yCur=trunc(((yPos-yMin)*yMaxScreen)/(yMax-yMin))

/* prepare event buffer */
xPosOut=reverse(d2c(xCur,2))
yPosOut=reverse(d2c(yCur,2))
oBuffer = EvntFlgs||yPosOut||xPosOut||yMaxOut||xMaxOut

/* write this event */
rc=charout(ddNameO,oBuffer)
rc=stream(ddNameO,'description')
/* check completion code */
if rc \= 'READY:'
then do
  say
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameO)
  /* wait */
  '@pause'
  exit
  end
return

/* report signal information */
error: failure: halt: novalue: syntax:
parse source system invokation filename
info=condition('c')||' condition raised at line '||sigl||' of'||'0D0A'x
info=info||filename||'0D0A'x||'|'||sourceline(sigl)
rc=lineout(ddNameR,info) ; say info

ProcessComplete:
/* release the emulate mouse driver */
rc=stream(ddNameO,'command','close')
/* release the direct control driver */
rc=stream(ddNameI,'command','close')

/* report afinger.cmd stopped */
info='<============<afinger.cmd> stopped on <'||date()||'> at <'||time()'>============>'
rc=lineout(ddNameR,info) ; say info
exit
