/* Lenovo ThinkPad x60efs finger/stylus events to xsmouse.sys */
rc=RxFuncAdd('SysGetMessage','RexxUtil','SysGetMessage')
rc=RxFuncAdd('SysSleep','RexxUtil','SysSleep')

/* set log file name */
ddNameR='x60efs.log'

/* report x60efs.cmd started */
info='<============<x60efs.cmd> started on <'||date()||'> at <'||time()'>============>'
rc=lineout(ddNameR,info) ; say info

/* set device driver names */
ddNameI='COM1' ; ddNameO='XSMOUSE$'

/* verify that the com port driver exists in config.sys */
if stream(ddNameI,'command','query exists') \= '\DEV\' || ddNameI
then do
  info='DEVICE=?:\OS2\BOOT\COM.SYS (1,200,5,I) required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* setup communication mode */
'MODE '||ddNameI||':38400,N,8,1,TO=OFF'

/* verify that the emulate mouse driver exists in config.sys */
if stream(ddNameO,'command','query exists') \= '\DEV\' || ddNameO
then do
  info='DEVICE=?:\OS2\BOOT\XSMOUSE.SYS required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* acquire the emulate mouse driver */
rc=stream(ddNameO,'command','open')
if rc \= 'READY:'
then do
  info=rc||' Device driver '||ddNameO||' currently in use. Please try later.'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* set digitizer size */
xdmm=245.76 ; /* millimeter */
ydmm=184.32 ; /* millimeter */

/* convert digitizer size */
xdmi=(xdmm*10000)/254 ; /* mInch */
ydmi=(ydmm*10000)/254 ; /* mInch */

/* set digitizer resolution */
xppi=2540/4 ; /* points/inch */
yppi=2540/4 ; /* points/inch */

/* set finger fixed extends */
xMaxFinger=1023 ; yMaxFinger=1023

/* set stylus fixed extends */
xMaxStylus=trunc((xdmi*xppi)/1000)
yMaxStylus=trunc((ydmi*yppi)/1000)

/* set finger margins */
xMinFinger=trunc(xMaxFinger/10)
xMaxFinger=xMaxFinger-xMinFinger
yMinFinger=trunc(yMaxFinger/10)
yMaxFinger=yMaxFinger-yMinFinger

/* report finger extends */
extends='xSize='||xdmm||' mm. xMinFinger='||xMinFinger||' points. xMaxFinger='||xMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm. yMinFinger='||yMinFinger||' points. yMaxFinger='||yMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends

/* set stylus margins */
xMinStylus=trunc(xMaxStylus/10)
xMaxStylus=xMaxStylus-xMinStylus
yMinStylus=trunc(yMaxStylus/10)
yMaxStylus=yMaxStylus-yMinStylus

/* report stylus extends */
extends='xSize='||xdmm||' mm. xMinStylus='||xMinStylus||' points. xMaxStylus='||xMaxStylus||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm. yMinStylus='||yMinStylus||' points. yMaxStylus='||yMaxStylus||' points.'
rc=lineout(ddNameR,extends) ; say extends

/* initialize mouse events */
But1Down=x2c(0600) ; But2Down=x2c(1800)
MoveOnly=x2c(0100) ; NoButMov=x2c(0000)

/* set screen fixed extends */
xMaxScreen=1023 ; yMaxScreen=767

/* move cursor to center */
xMin=0 ; xMax=xMaxScreen ; xPos=trunc(xMax/2)
yMin=0 ; yMax=yMaxScreen ; yPos=trunc(yMax/2)
xMaxOut=reverse(d2c(xMaxScreen,2))
yMaxOut=reverse(d2c(yMaxScreen,2))
call xsMouse(MoveOnly)

/* catch these here to release the mouse */
signal on error; signal on failure; signal on halt;
signal on novalue; signal on syntax;

/* initialize */
byte.0='00'x ; i=0

do forever
  call GetPacket
/*
**     bit    7     6     5     4     3     2     1     0
**         Ŀ
**  byte.1   1    0    0    1    0    0    0   Bt0 
**         Ĵ
**  byte.2   0   x13  x12  x11  x10  x09  x08  x07 
**         Ĵ
**  byte.3   0   x06  x05  x04  x03  x02  x01  x00 
**         Ĵ
**  byte.4   0   y13  y12  y11  y10  y09  y08  y07 
**         Ĵ
**  byte.5   0   y06  y05  y04  y03  y02  y01  y00 
**         
**
**     bit    7     6     5     4     3     2     1     0
**         Ŀ
**  byte.1   1    0   Prx   0    0    0   Bt1  Bt0 
**         Ĵ
**  byte.2   0   x13  x12  x11  x10  x09  x08  x07 
**         Ĵ
**  byte.3   0   x06  x05  x04  x03  x02  x01  x00 
**         Ĵ
**  byte.4   0   y13  y12  y11  y10  y09  y08  y07 
**         Ĵ
**  byte.5   0   y06  y05  y04  y03  y02  y01  y00 
**         Ĵ
**  byte.6   0   z11  z10  z09  z08  z07  z06  z05 
**         Ĵ
**  byte.7   0   z04  z03  z02  z01  z00   ?    ?  
**         Ĵ
**  byte.8   0    0    0    0    0    0    0    0  
**         Ĵ
**  byte.9   0    0    0    0    0    0    0    0  
**         
*/
  sBtn=c2d(bitand(byte.1,'0F'x))
  xPos=128*c2d(byte.2)+c2d(byte.3)
  yPos=128*c2d(byte.4)+c2d(byte.5)
  event=byte.1
  select
    when event=='90'x then call Finger(NoButMov)
    when event=='91'x then call Finger(But1Down)
    when event=='80'x then call Stylus(NoButMov)
    when event=='A0'x then call Stylus(MoveOnly)
    when event=='A1'x then call Stylus(But1Down)
    when event=='A2'x then call Stylus(But2Down)
    when event=='A3'x then call Stylus(But2Down)
    otherwise call Unknown
    end
  end

/* cleanup */
signal ProcessComplete
exit

GetPacket:
do until i==6|i==10
  byte.1=byte.i ; i=1
  do until bitand(byte.i,'80'x)=='80'x
    i=i+1 ; byte.i=charin(ddNameI)
    end
  end
return

Finger:
parse arg type
/* suppress finger */
if byte.0=='20'x then return
/* finger calibration */
if xPos<xMinFinger then xMinFinger=xPos
if xPos>xMaxFinger then xMaxFinger=xPos
if yPos<yMinFinger then yMinFinger=yPos
if yPos>yMaxFinger then yMaxFinger=yPos
/* use finger extends */
xMin=xMinFinger ; xMax=xMaxFinger
yMin=yMinFinger ; yMax=yMaxFinger
/* use finger pointer */
call xsMouse(type)
return

Stylus:
parse arg type
/* suppress finger */
byte.0=bitand(byte.1,'20'x)
/* stylus calibration */
if xPos<xMinStylus then xMinStylus=xPos
if xPos>xMaxStylus then xMaxStylus=xPos
if yPos<yMinStylus then yMinStylus=yPos
if yPos>yMaxStylus then yMaxStylus=yPos
/* use stylus extends */
xMin=xMinStylus ; xMax=xMaxStylus
yMin=yMinStylus ; yMax=yMaxStylus
/* use stylus pointer */
call xsMouse(type)
return

Unknown:
/* show packet */
packet=c2x(byte.1||byte.2||byte.3||byte.4||byte.5)
if i==10 then packet=packet||c2x(byte.6||byte.7||byte.8||byte.9)
output='Packet='||packet||',Huh?'
rc=lineout(ddNameR,output)
say output
return

xsMouse:
parse arg EvntFlgs
/* calculate current screen position */
xCur=trunc(((xPos-xMin)*xMaxScreen)/(xMax-xMin))
yCur=trunc(((yPos-yMin)*yMaxScreen)/(yMax-yMin))

/* prepare event buffer */
xPosOut=reverse(d2c(xCur,2))
yPosOut=reverse(d2c(yCur,2))
oBuffer = EvntFlgs||yPosOut||xPosOut||yMaxOut||xMaxOut

/* write this event */
rc=charout(ddNameO,oBuffer)
rc=stream(ddNameO,'description')
/* check completion code */
if rc \= 'READY:'
then do
  say
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameO)
  /* wait */
  '@pause'
  exit
  end
return

/* report signal information */
error: failure: halt: novalue: syntax:
parse source system invokation filename
info=condition('c')||' condition raised at line '||sigl||' of'||'0D0A'x
info=info||filename||'0D0A'x||'|'||sourceline(sigl)
rc=lineout(ddNameR,info) ; say info

/* report finger extends */
extends='xSize='||xdmm||' mm. xMinFinger='||xMinFinger||' points. xMaxFinger='||xMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm. yMinFinger='||yMinFinger||' points. yMaxFinger='||yMaxFinger||' points.'
rc=lineout(ddNameR,extends) ; say extends

/* report stylus extends */
extends='xSize='||xdmm||' mm. xMinStylus='||xMinStylus||' points. xMaxStylus='||xMaxStylus||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm. yMinStylus='||yMinStylus||' points. yMaxStylus='||yMaxStylus||' points.'
rc=lineout(ddNameR,extends) ; say extends

ProcessComplete:
/* release the emulate mouse driver */
rc=stream(ddNameO,'command','close')

/* report x60efs.cmd stopped */
info='<============<x60efs.cmd> stopped on <'||date()||'> at <'||time()'>============>'
rc=lineout(ddNameR,info) ; say info
exit
