/*
    Animated Mouse Pointer
    Copyright (C) 1997 Christian Langanke

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

*/
/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.41
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.41
 */

#pragma info( nogen )

#ifndef SOM_Module_wpawptr_Source
#define SOM_Module_wpawptr_Source
#endif
#define WPAnimatedMousePointer_Class_Source
#define M_WPAnimatedMousePointer_Class_Source

#include "wpamptr.ih"

// include own stuff
#include "wpamptr.rch"
#include "macros.h"
#include "debug.h"
#include "wmuser.h"
#include "mptrcnr.h"
#include "mptrutil.h"
#include "mptrppl.h"
#include "mptrset.h"
#include "mptrlset.h"
#include "mptrpag1.h"
#include "wpfsys.h"

typedef struct _WPSWINDOWDATA
{
  PHANDLERDATA phd;
  HMODULE      hmodResource;
  SOMAny*      somSelf;
  PSZ          pszResource; // analog zum Testprogramm
} WPSWINDOWDATA, *PWPSWINDOWDATA;

// -------------------------------------------------------------------------------------

int APIENTRY
InitDll( void )
{
  BOOL    fSuccess;
  APIRET  rc = NO_ERROR;
  HMODULE hmodResource = NULLHANDLE;

  FUNCENTER();

  do {
    // Resource lib laden
    rc = LoadResourceLib( &hmodResource );
    if( rc != NO_ERROR ) {
      break;
    }

    // nun initilalisieren
    rc = InitializePointerlist( WinQueryAnchorBlock( HWND_DESKTOP ), hmodResource );
  } while( FALSE );

  // cleanup
  if( hmodResource ) {
    DosFreeModule( hmodResource );
  }

  fSuccess = ( rc == NO_ERROR );
  return fSuccess;
}

int APIENTRY
UnInitDll( void )
{
  // never called on shutdown, so TRUE in anyway
  return TRUE;
}

// -------------------------------------------------------------------------------------

MRESULT EXPENTRY
AnimatedMousePointerPageProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  PWPSWINDOWDATA pwd = WinQueryWindowPtr( hwnd, QWL_USER );
  SOMAny* somSelf;
  WPAnimatedMousePointerData* somThis;
  APIRET  rc;

  if( pwd ) {
    // Zugriff auf Klassenvariablen immer ermglichen
    somSelf = pwd->somSelf;
    somThis = WPAnimatedMousePointerGetData( somSelf );
  }

  switch( msg ) {
    case WM_INITDLG:
    {
      PFNWP pfnwpOriginal;

      // store windowdata
      pwd = malloc( sizeof( WPSWINDOWDATA ));
      memset( pwd, 0, sizeof( WPSWINDOWDATA ));
      pwd->somSelf = (SOMAny*)mp2;
      WinSetWindowPtr( hwnd, QWL_USER, pwd );
      somSelf = pwd->somSelf;
      somThis = WPAnimatedMousePointerGetData( somSelf );

      // store window handle
      _hwndNotebookPage = hwnd;

      translate(hwnd);

      // Resource Module handle speichern
      pwd->hmodResource = _clsQueryResourceModuleHandle( _WPAnimatedMousePointer );


      // ### integrated code begin

      // auf SubcommandHandler subclassen
      pfnwpOriginal = WinSubclassWindow( hwnd, DialogHandlerProc );

      // ausserdem der Subclass-Funktion auch WM_INITDLG zukommen lassen
      // Pointer auf HANDLERDATA wird an erster Stelle in WINDOWDATA bergeben
      if(( pwd->phd = malloc( sizeof( HANDLERDATA ))) != 0 ) {
        memset( pwd->phd, 0, sizeof( HANDLERDATA ));
        pwd->phd->hmodResource       = pwd->hmodResource;
        pwd->phd->somSelf            = somSelf;
        pwd->phd->pfnwpOriginal      = pfnwpOriginal;
        pwd->phd->ppcnrrec           = &_pcnrrec;
      }
      return DialogHandlerProc( hwnd, msg, 0, 0 );
    // ### integrated code end
    }

    // ### integrated code begin
    #define SETTINGS_LOADSET      "CLASSLIST=WPFolder;STARTFOLDER=%s;SUBTREESRCH=NO;DEFAULTCRITERIA=YES;"
    #define SETTINGS_FINDPOINTER  "CLASSLIST=WPPointer;STARTFOLDER=%s;SUBTREESRCH=NO;DEFAULTCRITERIA=YES;"

    case WM_USER_SERVICE:
    {
      switch( LONGFROMMP( mp1 )) {
        case SERVICE_RESTORE:
          DEBUGMSG( "SERVICE: restore" NEWLINE, 0 );
          ScanSetupString( hwnd, PVOIDFROMMP( mp2 ), _pszCurrentSettings, FALSE, FALSE );
          break;   // SERVICE_RESTORE

        case SERVICE_SAVE:
          DEBUGMSG( "SERVICE: save" NEWLINE, 0 );
          _wpSaveImmediate( somSelf );
          break;   // SERVICE_SAVE

        case SERVICE_HELP:
        {
          ULONG ulPanelId = LONGFROMMP( mp2 );
          PSZ   pszHelpLibrary = _clsQueryHelpLibrary( _WPAnimatedMousePointer );

          DEBUGMSG( "SERVICE: help %u in %s" NEWLINE, ulPanelId _c_ pszHelpLibrary );
          _wpDisplayHelp( somSelf, ulPanelId, pszHelpLibrary );
          break;   // SERVICE_HELP
        }

        case SERVICE_HELPMENU:
        {
          ULONG  ulMenuId = LONGFROMMP( mp2 );
          BOOL   fResult;
          APIRET rc;

          fResult = _wpMenuItemSelected( somSelf, hwnd, ulMenuId );
          rc = ( fResult ) ? 0 : ERRORIDERROR( WinGetLastError( WinQueryAnchorBlock( hwnd )));
          DEBUGMSG( "SERVICE: menu help %u (result=%u rc=%u/0x%08x)" NEWLINE, ulMenuId _c_ fResult _c_ rc _c_ rc );
          break;   // SERVICE_HELP
        }

        case SERVICE_FIND:
        {
          APIRET rc;
          CHAR   szFullname[ _MAX_PATH];

          DEBUGMSG( "SERVICE: Find Pointer" NEWLINE, 0 );
          rc = FindFiles( _WPAnimatedMousePointer, somSelf, HWND_DESKTOP, hwnd,
                          _clsQueryResourceModuleHandle( _WPAnimatedMousePointer ),
                          ( mp2 ) ? PVOIDFROMMP( mp2 ) : DEFAULT_ANIMATIONPATH,
                          szFullname, sizeof( szFullname ), FALSE );
          if( rc == NO_ERROR ) {
            return strdup( szFullname );
          } else {
            return NULL;
          }
        }

        case SERVICE_LOAD:
        {
          APIRET rc;
          CHAR   szFullname[ _MAX_PATH];

          DEBUGMSG( "SERVICE: Load Set" NEWLINE, 0 );

          rc = FindFiles( _WPAnimatedMousePointer, somSelf, HWND_DESKTOP, hwnd,
                          _clsQueryResourceModuleHandle( _WPAnimatedMousePointer ),
                          ( mp2 ) ? PVOIDFROMMP( mp2 ) : DEFAULT_ANIMATIONPATH,
                          szFullname, sizeof( szFullname ), TRUE );

          if( rc == NO_ERROR ) {
            return strdup( szFullname );
          } else {
            return NULL;
          }
        }
      }
      break; // end case WM_USER_SERVICE:
    }

      // ### integrated code end

    case WM_DESTROY:
      // reset window handle
      _hwndNotebookPage = NULLHANDLE;
      _pcnrrec          = NULL;
      break;
  }

  return WinDefDlgProc( hwnd, msg, mp1, mp2 );
}

// -------------------------------------------------------------------------------------

SOM_Scope ULONG SOMLINK
AWptr_InsertAnimatedMousePointerPage( WPAnimatedMousePointer* somSelf, HWND hwndDlg )
{
  PAGEINFO pi;
  ULONG    rc;
  CHAR     szTabName[ MAX_RES_STRLEN];
  HAB      hab          = WinQueryAnchorBlock( HWND_DESKTOP );
  HMODULE  hmodResource = _clsQueryResourceModuleHandle( _WPAnimatedMousePointer );

  WPAnimatedMousePointerData* somThis = WPAnimatedMousePointerGetData( somSelf );

  WPAnimatedMousePointerMethodDebug( "WPAnimatedMousePointer", "AWptr_InsertAnimatedMousePointerPage" );
  FUNCENTER();

  LOADSTRING( IDTAB_NBPAGE, szTabName );

  memset((PCH)&pi, 0, sizeof( PAGEINFO ));
  pi.cb                  = sizeof( PAGEINFO );
  pi.hwndPage            = NULLHANDLE;
  pi.usPageStyleFlags    = BKA_MAJOR;
  pi.usPageInsertFlags   = BKA_FIRST;
  pi.usSettingsFlags     = SETTINGS_PAGE_NUMBERS;
  pi.pfnwp               = AnimatedMousePointerPageProc;
  pi.resid               = hmodResource;
  pi.dlgid               = IsWARP3() ? IDDLG_DLG_ANIMATEDWAITPOINTER_230 : IDDLG_DLG_ANIMATEDWAITPOINTER;
  pi.pszName             = szTabName;
  pi.pCreateParams       = somSelf;
  pi.idDefaultHelpPanel  = IDPNL_USAGE_NBPAGE;
  pi.pszHelpLibraryName  = _clsQueryHelpLibrary( _WPAnimatedMousePointer );

  rc = _wpInsertSettingsPage( somSelf, hwndDlg, &pi );
  return rc;
}

// -------------------------------------------------------------------------------------

SOM_Scope ULONG SOMLINK
AWptr_wpAddMousePtrPage( WPAnimatedMousePointer* somSelf, HWND hwndNotebook )
{
  ULONG ulResult;

  WPAnimatedMousePointerData* somThis = WPAnimatedMousePointerGetData( somSelf );

  WPAnimatedMousePointerMethodDebug( "WPAnimatedMousePointer", "AWptr_wpAddMousePtrPage" );
  FUNCENTER();

  if( _clsQueryClassReplaceActive( _WPAnimatedMousePointer )) {
    return _InsertAnimatedMousePointerPage( somSelf, hwndNotebook );
  } else {
    return WPAnimatedMousePointer_parent_WPMouse_wpAddMousePtrPage( somSelf,
                                                                    hwndNotebook );
  }
}

// -------------------------------------------------------------------------------------

SOM_Scope void SOMLINK
AWptr_wpInitData( WPAnimatedMousePointer* somSelf )
{
  WPAnimatedMousePointerData* somThis = WPAnimatedMousePointerGetData( somSelf );

  WPAnimatedMousePointerMethodDebug( "WPAnimatedMousePointer", "AWptr_wpInitData" );
  FUNCENTER();

  _pszCurrentSettings = NULL;
  _hwndNotebookPage   = NULLHANDLE;
  _pcnrrec            = NULL;

  WPAnimatedMousePointer_parent_WPMouse_wpInitData( somSelf );
}

// -------------------------------------------------------------------------------------

SOM_Scope void SOMLINK
AWptr_wpUnInitData( WPAnimatedMousePointer* somSelf )
{
  WPAnimatedMousePointerData* somThis = WPAnimatedMousePointerGetData( somSelf );

  WPAnimatedMousePointerMethodDebug( "WPAnimatedMousePointer", "AWptr_wpUnInitData" );
  FUNCENTER();

  if( _pszCurrentSettings ) {
    free( _pszCurrentSettings );
  }

  WPAnimatedMousePointer_parent_WPMouse_wpUnInitData( somSelf );
}

// -------------------------------------------------------------------------------------

SOM_Scope BOOL SOMLINK
AWptr_wpSaveState( WPAnimatedMousePointer* somSelf )
{
  APIRET rc             = NO_ERROR;
  PSZ    pszSettingsTmp = NULL;
  PSZ    pszSettings    = NULL;
  ULONG  ulMaxLen       = 0;

  WPAnimatedMousePointerData* somThis = WPAnimatedMousePointerGetData( somSelf );

  WPAnimatedMousePointerMethodDebug( "WPAnimatedMousePointer", "AWptr_wpSaveState" );
  FUNCENTER();

  do
  {
    // Settings holen
    rc = QueryCurrentSettings( &pszSettingsTmp );
    if( rc != NO_ERROR ) {
      break;
    }
    if( *pszSettingsTmp == 0 ) {
      break;
    }

    // SOM Speicher holen
    pszSettings = _wpAllocMem( somSelf, strlen( pszSettingsTmp ) + 1, &rc );
    if( !pszSettings ) {
      break;
    }

    // Settings kopieren
    strcpy( pszSettings, pszSettingsTmp );

    // alte Settings verwerfen
    if( _pszCurrentSettings != NULL ) {
      _wpFreeMem( somSelf, _pszCurrentSettings );
    }
    _pszCurrentSettings = pszSettings;

    // jetzt speichern
    _wpSaveString( somSelf, "WPAnimatedMousePointer", 1, pszSettings );
    if( getAnimationInitDelay() != getDefaultAnimationInitDelay()) {
      _wpSaveLong( somSelf, "WPAnimatedMousePointer", 2, getAnimationInitDelay());
    } else {
      _wpSaveLong( somSelf, "WPAnimatedMousePointer", 2, -1 );
    }
  } while( FALSE );

  // cleanup
  if( pszSettingsTmp ) {
    free( pszSettingsTmp );
  }

  return WPAnimatedMousePointer_parent_WPMouse_wpSaveState( somSelf );
}

// -------------------------------------------------------------------------------------

SOM_Scope BOOL SOMLINK
AWptr_wpRestoreState( WPAnimatedMousePointer* somSelf, ULONG ulReserved )
{
  APIRET rc          = NO_ERROR;
  PSZ    pszSettings = NULL;
  ULONG  ulMaxLen    = 0;
  ULONG  ulAnimationInitDelay = 0;

  WPAnimatedMousePointerData* somThis = WPAnimatedMousePointerGetData( somSelf );

  WPAnimatedMousePointerMethodDebug( "WPAnimatedMousePointer", "AWptr_wpRestoreState" );
  FUNCENTER();

  do
  {
    // numerischen Wert fr Animtion Init delay holen
    if(( !_wpRestoreLong( somSelf, "WPAnimatedMousePointer", 2, &ulAnimationInitDelay )) ||
       ( ulAnimationInitDelay == -1 )) {
      ulAnimationInitDelay = getDefaultAnimationInitDelay();
    }
    setAnimationInitDelay( ulAnimationInitDelay );

    // bentigte Lnge abfragen
    if( !_wpRestoreString( somSelf, "WPAnimatedMousePointer", 1, NULL, &ulMaxLen )) {
      break;
    }

    if( ulMaxLen == 0 ) {
      break;
    }

    // Speicher holen
    pszSettings = _wpAllocMem( somSelf, ulMaxLen, &rc );
    if( rc != NO_ERROR ) {
      break;
    }

    // Settings holen
    _wpRestoreString( somSelf, "WPAnimatedMousePointer", 1, pszSettings, &ulMaxLen );
    DEBUGMSG( "SOM: restored settings" NEWLINE, 0 );
    DEBUGMSG( "SOM: %s" NEWLINE, pszSettings );

    // alte Settings verwerfen
    if( _pszCurrentSettings != NULL ) {
      _wpFreeMem( somSelf, _pszCurrentSettings );
    }
    _pszCurrentSettings = pszSettings;
  } while( FALSE );

  // ggfs. leeren Settings-String anlegen, damit ScanSetupString
  // auf jeden fall die Notebook Page notifiziert
  if( _pszCurrentSettings == NULL ) {
    _pszCurrentSettings   = _wpAllocMem( somSelf, 1, &rc );
    *_pszCurrentSettings  = 0;
  }

  // Settings verwenden
  ScanSetupString( _hwndNotebookPage, _pcnrrec, _pszCurrentSettings, FALSE, TRUE );

  return WPAnimatedMousePointer_parent_WPMouse_wpRestoreState( somSelf,
                                                               ulReserved );
}

// -------------------------------------------------------------------------------------

SOM_Scope BOOL SOMLINK
AWptr_wpSetup( WPAnimatedMousePointer* somSelf, PSZ pszSetupString )
{
  PSZ   pszSetupCopy = NULL;
  ULONG ulAnimationInitDelay = 0;
  BOOL  fResult;

  WPAnimatedMousePointerData* somThis = WPAnimatedMousePointerGetData( somSelf );

  WPAnimatedMousePointerMethodDebug( "WPAnimatedMousePointer", "AWptr_wpSetup" );
  FUNCENTER();

  // make a duplicate of the setup string, so that we may modify it
  pszSetupCopy = strdup( pszSetupString );

  if( pszSetupString != NULL ) {
    DEBUGMSG( "SOM: setup with data: %s" NEWLINE, pszSetupCopy );

    // falls Klasse noch nicht initialisiert wurde
    // Initialisierung verzgern
    if( !IsSettingsInitialized()) {
      // numerischen Wert fr Animtion Init delay holen
      ulAnimationInitDelay = getAnimationInitDelay();
      setAnimationInitDelay( ulAnimationInitDelay );

      ScanSetupString( _hwndNotebookPage, _pcnrrec, pszSetupCopy, TRUE, TRUE );
    } else {
      ScanSetupString( _hwndNotebookPage, _pcnrrec, pszSetupCopy, TRUE, FALSE );
    }

    fResult = WPAnimatedMousePointer_parent_WPMouse_wpSetup( somSelf,
                                                             pszSetupCopy );
    free( pszSetupCopy );
  } else {
    DEBUGMSG( "SOM: not enough memory for strdup !" NEWLINE, 0 );
    fResult = WPAnimatedMousePointer_parent_WPMouse_wpSetup( somSelf,
                                                             pszSetupString );
  }

  return fResult;
}

// -------------------------------------------------------------------------------------

SOM_Scope HMODULE SOMLINK
AWptrM_clsQueryResourceModuleHandle( M_WPAnimatedMousePointer* somSelf )
{
  M_WPAnimatedMousePointerData* somThis = M_WPAnimatedMousePointerGetData( somSelf );

  M_WPAnimatedMousePointerMethodDebug( "M_WPAnimatedMousePointer", "AWptrM_clsQueryResourceModuleHandle" );
  FUNCENTER();

  return _hmodResource;
}

// -------------------------------------------------------------------------------------

SOM_Scope BOOL SOMLINK
AWptrM_clsQueryClassReplaceActive( M_WPAnimatedMousePointer* somSelf )
{
  M_WPAnimatedMousePointerData* somThis = M_WPAnimatedMousePointerGetData( somSelf );

  M_WPAnimatedMousePointerMethodDebug( "M_WPAnimatedMousePointer", "AWptrM_clsQueryClassReplaceActive" );
  FUNCENTER();

  /* Return statement to be customized: */
  return _fClassReplaceActive;
}

// -------------------------------------------------------------------------------------

SOM_Scope PSZ SOMLINK
AWptrM_clsQueryHelpLibrary( M_WPAnimatedMousePointer* somSelf )
{
  M_WPAnimatedMousePointerData* somThis = M_WPAnimatedMousePointerGetData( somSelf );

  M_WPAnimatedMousePointerMethodDebug( "M_WPAnimatedMousePointer", "AWptrM_clsQueryHelpLibrary" );
  FUNCENTER();

  /* Return statement to be customized: */
  return _szHelpLibrary;
}

// -------------------------------------------------------------------------------------

SOM_Scope void SOMLINK
AWptrM_wpclsInitData( M_WPAnimatedMousePointer* somSelf )
{
  APIRET rc;

  M_WPAnimatedMousePointerData* somThis = M_WPAnimatedMousePointerGetData( somSelf );

  M_WPAnimatedMousePointerMethodDebug( "M_WPAnimatedMousePointer", "AWptrM_wpclsInitData" );
  FUNCENTER();

  M_WPAnimatedMousePointer_parent_M_WPMouse_wpclsInitData( somSelf );

  // Load res module
  rc = LoadResourceLib( &_hmodResource );

  // start loader
  _fClassReplaceActive = InitDll();

  // retrieve help library name
  rc = GetHelpLibName( _szHelpLibrary,  sizeof( _szHelpLibrary ));
}

// -------------------------------------------------------------------------------------

SOM_Scope void SOMLINK
AWptrM_wpclsUnInitData( M_WPAnimatedMousePointer* somSelf )
{
  APIRET rc;

  M_WPAnimatedMousePointerData* somThis = M_WPAnimatedMousePointerGetData( somSelf );

  M_WPAnimatedMousePointerMethodDebug( "M_WPAnimatedMousePointer", "AWptrM_wpclsUnInitData" );
  FUNCENTER();

  // unload loader
  UnInitDll();

  // Unload DLL
  if( _hmodResource ) {
    rc = DosFreeModule( _hmodResource );
    _hmodResource = NULLHANDLE;
  }

  M_WPAnimatedMousePointer_parent_M_WPMouse_wpclsUnInitData( somSelf );
}

// -------------------------------------------------------------------------------------

SOM_Scope BOOL SOMLINK
AWptrM_wpclsQuerySettingsPageSize( M_WPAnimatedMousePointer* somSelf, PSIZEL pSizl )
{
  BOOL fResult;

  M_WPAnimatedMousePointerData* somThis = M_WPAnimatedMousePointerGetData( somSelf );

  M_WPAnimatedMousePointerMethodDebug( "M_WPAnimatedMousePointer", "AWptrM_wpclsQuerySettingsPageSize" );
  FUNCENTER();

  fResult = M_WPAnimatedMousePointer_parent_M_WPMouse_wpclsQuerySettingsPageSize( somSelf,
                                                                                  pSizl );

  // fr WARP 3 ein wenig hher
  if( IsWARP3()) {
    pSizl->cy += 20;
  }

  return fResult;
}

/* ------------------------------------------------- */

BOOL
DisplayHelp( PVOID somSelf, ULONG ulHelpPanelId )
{
  PSZ pszHelpLibrary = _clsQueryHelpLibrary( _WPAnimatedMousePointer );
  return _wpDisplayHelp( somSelf, ulHelpPanelId, pszHelpLibrary );
}

