/* REXX *********************************************/
/*                                                  */
/* Program name.: Date2000                          */
/*                                                  */
/* Function.....: Test procedur Date2000            */
/*                Date with years century           */
/* Author.......: Janosch R. Kowalczyk              */
/* Creation date: 1996.11.05                        */
/* Version......: 1.0                               */
/*                                                  */
/* Changes......: No                                */
/*                                                  */
/****************************************************/

Say 'Date()  =' Date2000()
Say 'Date(B) =' Date2000(B)
Say 'Date(D) =' Date2000(Days)
Say 'Date(E) =' Date2000(E)
Say 'Date(J) =' Date2000(Julian)
Say 'Date(L) =' Date2000(L)
Say 'Date(M) =' Date2000(M)
Say 'Date(N) =' Date2000(N)
Say 'Date(O) =' Date2000(O)
Say 'Date(S) =' Date2000(S)
Say 'Date(U) =' Date2000(U)
Say 'Date(W) =' Date2000(W)

/*-------------------(End program)------------------*/
Call CharOut , "Press enter to exit "
pull y

Exit

/*=================(PROCEDURES)==================*/
Date2000: Procedure
Parse Value Arg(1) With Option +1 .

/*-----------------------------------*/
/*   = dd Mmm yyyy                   */
/* B = dddddd days since 01.01.0001  */
/* D = ddd - days                    */
/* E = dd/mm/yy ===> dd/mm/yyyy      */
/* J = yyyy.ddd - julians date       */
/* L = dd Month yyyy                 */
/* M = Month                         */
/* N = dd Mmm yyyy                   */
/* O = yy/mm/dd ===> yyyy/mm/dd      */
/* S = yyyymmdd                      */
/* U = mm/dd/yy ===> mm/dd/yyyy      */
/* W = Weekday                       */
/*-----------------------------------*/

If Option = '' Then Return Date()
If Verify('EJOU', Option, 'M') > 0 Then Do
  Parse Value Date() With . . yyyy
  If Option = 'J' Then Return yyyy || '.' || Date('D')
  Else If Option = 'O' Then Do
    Parse Value Date(Option) With . +2 Rest
    Return yyyy || Rest
  End
  Else Do
    Parse Value Date(Option) With Rest +6 .
    Return Rest || yyyy
  End
End
Else Return Date(Option)
