/* REXX */
/* ランダムにデスクトップの壁紙を設定する */
/* (C) Copyright 1997 kyo */

options 'ETMODE'; options 'EXMODE';
arg wallpdir fext itype '@' tr
trace value tr;
/* Load functions */
if RxFuncQuery('SysLoadFuncs') then call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Default Wallpaper directory */
if wallpdir = '' then
do
	wallpdir = 'f:\os2\bitmap\'
end
/* Default file extention */
if fext = '' then
do
	fext = 'bmp'
end
/* Default image type */
if itype = '' then
do
	itype = 'N'
end

/* Get image file info */
numjpeg = SysFileTree(wallpdir||'*.'||fext, 'file', 'O')
if numjpeg <> 0 | file.0 = 0 then
do
	signal error
end
/* 乱数 */
r = random(1, file.0)
param = 'BACKGROUND='||file.r||','||itype
call SysSetObjectData'', param
exit

error:
say 'Error !'
exit