/* REXX */
/* カレントディレクトリにサムネイルHTMLファイルを作成する
 * JPEGファイル、GIFファイル、WAVファイルを対象とする
 * JPEGファイルと同名のWAVファイルはまとめる
 * AVI、MPGファイルを追加
 * FATの拡張属性のLong file nameを考慮する
 */
/* (C) Copyright 1999 kyo */
/* パラメータ
再帰的:Y/N（デフォルトN）
ファイル名/日時切替:N/D（デフォルトN）
サムネイルイメージ作成:Y/N（デフォルトN）
1行に入るサムネイルの数:n（デフォルト5）
サムネイルファイル上書き:Y/N（デフォルトN）
サムネイルファイル名（デフォルトthumb.htm）
 */

options 'ETMODE'; options 'EXMODE';
parse arg prm '@' tr
trace value tr;

/* OSとコマンド名取得 */
parse source os . cmdname

/* コマンド名取得 */
/* 文字列を反転して'.'と最初の'\'で分解 */
rvcmdname = reverse(cmdname)
parse var rvcmdname rvcmdext '.' rvcmdbody '\' rvcmddir
cmdname = reverse(rvcmdbody) || '.' || reverse(rvcmdext)

/* ヘルプ */
if pos("HELP", translate(prm)) > 0 then signal usage

/* get current directory */
trgt = directory()
/* Load functions */
if RxFuncQuery('SysLoadFuncs') then call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Parameters */
/* (Defaults) */
parse var prm recur nord thmimg numcol ovwr fn
if recur = '' then
do
	recur = 'N'
end
recur = translate(recur)
if (recur <> 'Y') & (recur <> 'N') then signal usage

if nord = '' then
do
	nord = 'N'
end
nord = translate(nord)
if (nord <> 'N') & (nord <> 'D') then signal usage

if thmimg = '' then
do
	thmimg = 'N'
end
thmimg = translate(thmimg)
if (thmimg <> 'Y') & (thmimg <> 'N') then signal usage
if numcol = '' then
do
	numcol = 5
end
if datatype(numcol) <> "NUM" then signal usage
if numcol <> trunc(numcol) then signal usage

if ovwr = '' then
do
	ovwr = 'Y'
end
ovwr = translate(ovwr)
if (ovwr <> "Y") & (ovwr <> "N") then signal usage
if fn = '' then
do
	fn = "thumb.htm"
end

/* Calculated numbers */
colwid = trunc(100 / numcol)||'%'
thumbx = trunc(600 / numcol)
thumby = trunc(thumbx * 3 / 4)

/* Constants */
templlbl = "$$templ$"
sepchar = '|'
thmimghd = "$$"

/* Target */
trgt = strip(trgt)

/* Get template */
j = 0
do i = 1 to sourceline()
	if left(sourceline(i), length(templlbl)) = templlbl then
	do
		j = j + 1
		templlinenum.j = i
		/* say sourceline(i) */
	end
end

templlinenum.0 = j 

/* Overwrite? */
/* if exists */
if stream(fn, 'C', "QUERY EXISTS") <> '' then
do
	if ovwr = 'N' then
	do
		say directory()||'\'||fn exists.
		exit
	end
	else
	do
		"@del" fn
	end
end

/* Temp files */
tempdir = value("TEMP", , "OS2ENVIRONMENT")
if tempdir = '' then tempdir = directory()
rc = SysFileTree(tempdir, "tempext", 'D')
if tempext.0 = 0 then tempdir = directory()
if right(tempdir, 1) <> '\' then tempdir = tempdir||'\'

tempfn1 = tempdir||SysTempFileName("$$temp1.???")
do while stream(tempfn1, 'C', "QUERY EXISTS") <> ''
	tempfn1 = tempdir||SysTempFileName("$$temp1.???")
end
tempfn2 = tempdir||SysTempFileName("$$temp2.???")
do while stream(tempfn2, 'C', "QUERY EXISTS") <> ''
	tempfn2 = tempdir||SysTempFileName("$$temp2.???")
end

/* Get subdirectories if any */
rc = SysFileTree("*.*", "subdir", "DO")

/* Get file names and long file names if any */
rc = SysFileTree("*.avi", "avi", "FO")
rc = SysFileTree("*.gif", "gif", "FO")
rc = SysFileTree("*.jpg", "jpg", "FO")
rc = SysFileTree("*.mpg", "mpg", "FO")
rc = SysFileTree("*.wav", "wav", "FO")

/* If no subdirectories or image files, return */
if ( subdir.0 = 0 ) & ( avi.0 = 0 ) & ( gif.0 = 0 ) & ( jpg.0 = 0 ) & ( mpg.0 = 0 ) & ( wav.0 = 0 ) then
do
	say directory()||" has no subdirectories or image files."
	return
end

/* Create HTML file */
/* 出力ファイルを開く */
rc = stream(fn, 'C', "OPEN WRITE")

/* HTML comment */
numtempl = 1
str1 = sourceline(templlinenum.numtempl + 1)
str2 = replstr(str1, "%s", fn)
str3 = replstr(str2, "%s", cmdname)
call lineout fn, str3

/* HTML header 1 */
numtempl = numtempl + 1
numtemple = numtempl + 1
do i = templlinenum.numtempl + 1 to templlinenum.numtemple - 1
	call lineout fn, sourceline(i)
end

/* Title */
numtempl = numtempl + 1
str1 = sourceline(templlinenum.numtempl + 1)
str2 = replstr(str1, "%s", newfilespec("Name", directory()))
call lineout fn, str2

/* HTML header 2 */
numtempl = numtempl + 1
numtemple = numtempl + 1
do i = templlinenum.numtempl + 1 to templlinenum.numtemple - 1
	call lineout fn, sourceline(i)
end

/* Directory name */
numtempl = numtempl + 1
numtemple = numtempl + 1
str1 = sourceline(templlinenum.numtempl + 1)
str2 = replstr(str1, "%s", newfilespec("Name", directory()))
call lineout fn, str2
do i = templlinenum.numtempl + 2 to templlinenum.numtemple - 1
	call lineout fn, sourceline(i)
end

/* Create parent directory entry if thumbnail of the parent directory exists */
numtempl = numtempl + 1
if stream("..\"fn, 'C', "QUERY EXISTS") <> '' then
do
	str1 = sourceline(templlinenum.numtempl + 1)
	str2 = replstr(str1, "%s", fn)
	call lineout fn, str2
end

/* Create subdirectory entry if any */
if subdir.0 > 0 then
do
	/* Beginning of subdirectories section */
	numtempl = numtempl + 1
	numtemple = numtempl + 1
	do i = templlinenum.numtempl + 1 to templlinenum.numtemple - 1
		call lineout fn, sourceline(i)
	end

	/* Subdirectory entries */
	numtempl = numtempl + 1

	/* Sort subdirectory entries */
	rc = stream(tempfn1, 'C', "OPEN WRITE")
	do i = 1 to subdir.0
		call lineout tempfn1, newfilespec("Name", subdir.i)
		if recur <> 'N' then
		do
			/* Call mkthumb.cmd recursively with subdirectory */
			curdir = directory()
			rc = directory(subdir.i)
			call 'mkthumb' recur nord thmimg numcol ovwr fn
			rc = directory(curdir)
		end
	end
	rc = stream(tempfn1, 'C', "CLOSE")
	/* sort by subdirectory names */
	"@sort <"||tempfn1||" >"||tempfn2

	/* Create subdirectory entry if thumbnail of the subdirectory is created */
	rc = stream(tempfn2, 'C', "OPEN READ")
	do i = 1 to subdir.0
		/* Create if subdirectory thumbnail exists */
		subfn = linein(tempfn2)
		if stream(subfn||"\"fn, 'C', "QUERY EXISTS") <> '' then
		do
			str1 = sourceline(templlinenum.numtempl + 1)
			str2 = replstr(str1, "%s", newfilespec("Name", subfn))
			str3 = replstr(str2, "%s", fn)
			str4 = replstr(str3, "%s", newfilespec("Name", subfn))
			call lineout fn, str4
		end
	end
	rc = stream(tempfn2, 'C', "CLOSE")
end
else
do
	numtempl = numtempl + 2
end

/* Create thumbnail if any */
if ( avi.0 > 0 ) | ( gif.0 > 0 ) | ( jpg.0 > 0 ) | ( mpg.0 > 0 ) | ( wav.0 > 0 ) then
do
	/* Thumbnail headers */
	numtempl = numtempl + 1
	numtemple = numtempl + 1
	do i = templlinenum.numtempl + 1 to templlinenum.numtemple - 1
		call lineout fn, sourceline(i)
	end

	/* Row entry */
	numtempl = numtempl + 1
	rowentry = sourceline(templlinenum.numtempl + 1)
	call lineout fn, rowentry
	numc = 0

	/* Put file names and long file names into a temporary file */
	if stream(tempfn1, 'C', "QUERY EXISTS") <> '' then
	do
		"@del" tempfn1
	end
	rc = stream(tempfn1, 'C', "OPEN WRITE")

	numgif = 0
	if gif.0 > 0 then
	do i = 1 to gif.0
		/* Thumbnail image file ? */
		if left(newfilespec("Name", gif.i), length(thmimghd)) = thmimghd then iterate
		numgif = numgif + 1

		/* .wav exists? */
		rc = SysFileTree(left(gif.i, length(gif.i) - 3) || "wav", "wavfn", "FO")
		if wavfn.0 = 0 then
		do
			wavsz = 0
		end
		else
		do
			wavsz = trunc(stream(wavfn.1, 'C', "QUERY SIZE") / 1024 + 0.5)
		end
		if nord = 'N' then
		do
			/* Get long file name */
			ln = getln(gif.i)
			if wavsz = 0 then
			do
				call lineout tempfn1, ln||sepchar||newfilespec("Name", gif.i)
			end
			else
			do
				call lineout tempfn1, ln||sepchar||newfilespec("Name", gif.i) ,
					||sepchar||newfilespec("Name", wavfn.1)||sepchar||wavsz
			end
		end
		else
		do
			/* Get date & time */
			fd = getfiledate(gif.i)
			if wavsz = 0 then
			do
				call lineout tempfn1, fd||sepchar||newfilespec("Name", gif.i)
			end
			else
			do
				call lineout tempfn1, fd||sepchar||newfilespec("Name", gif.i) ,
					||sepchar||newfilespec("Name", wavfn.1)||sepchar||wavsz
			end
		end
	end
	gif.0 = numgif

	numjpeg = 0
	if jpg.0 > 0 then
	do i = 1 to jpg.0
		/* Thumbnail image file ? */
		if left(newfilespec("Name", jpg.i), length(thmimghd)) = thmimghd then iterate
		numjpeg = numjpeg + 1

		/* .wav exists? */
		rc = SysFileTree(left(jpg.i, length(jpg.i) - 3) || "wav", "wavfn", "FO")
		if wavfn.0 = 0 then
		do
			wavsz = 0
		end
		else
		do
			wavsz = trunc(stream(wavfn.1, 'C', "QUERY SIZE") / 1024 + 0.5)
		end
		if nord = 'N' then
		do
			/* Get long file name */
			ln = getln(jpg.i)
			if wavsz = 0 then
			do
				call lineout tempfn1, ln||sepchar||newfilespec("Name", jpg.i)
			end
			else
			do
				call lineout tempfn1, ln||sepchar||newfilespec("Name", jpg.i) ,
					||sepchar||newfilespec("Name", wavfn.1)||sepchar||wavsz
			end
		end
		else
		do
			/* Get date & time */
			fd = getfiledate(jpg.i)
			if wavsz = 0 then
			do
				call lineout tempfn1, fd||sepchar||newfilespec("Name", jpg.i)
			end
			else
			do
				call lineout tempfn1, fd||sepchar||newfilespec("Name", jpg.i) ,
					||sepchar||newfilespec("Name", wavfn.1)||sepchar||wavsz
			end
		end
	end
	jpg.0 = numjpeg

	numwav = 0
	if wav.0 > 0 then
	do i = 1 to wav.0
		/* .gif exists? */
		giffn = left(wav.i, length(wav.i) - 3) || "gif"
		if stream(giffn, 'C', "QUERY EXISTS") <> '' then iterate

		/* .jpg exists? */
		jpegfn = left(wav.i, length(wav.i) - 3) || "jpg"
		if stream(jpegfn, 'C', "QUERY EXISTS") <> '' then iterate

		numwav = numwav + 1
		if nord = 'N' then
		do
			/* Get long file name */
			ln = getln(wav.i)
			call lineout tempfn1, ln||sepchar||newfilespec("Name", wav.i)
		end
		else
		do
			/* Get date & time */
			fd = getfiledate(wav.i)||"<BR>Wave file"
			call lineout tempfn1, fd||sepchar||newfilespec("Name", wav.i)
		end
	end
	wav.0 = numwav

	/* avi */
	if avi.0 > 0 then
	do i = 1 to avi.0
		if nord = 'N' then
		do
			/* Get long file name */
			ln = getln(avi.i)
			call lineout tempfn1, ln||sepchar||newfilespec("Name", avi.i)
		end
		else
		do
			/* Get date & time */
			fd = getfiledate(avi.i)
			call lineout tempfn1, fd||sepchar||newfilespec("Name", avi.i)
		end
	end

	/* mpg */
	if mpg.0 > 0 then
	do i = 1 to mpg.0
		if nord = 'N' then
		do
			/* Get long file name */
			ln = getln(mpg.i)
			call lineout tempfn1, ln||sepchar||newfilespec("Name", mpg.i)
		end
		else
		do
			/* Get date & time */
			fd = getfiledate(mpg.i)
			call lineout tempfn1, fd||sepchar||newfilespec("Name", mpg.i)
		end
	end

	rc = stream(tempfn1, 'C', "CLOSE")

	/* sort by long file names */
	"@sort <"||tempfn1||" >"||tempfn2

	/* Thumbnail entry */
	numtempl = numtempl + 1
	imgstr = sourceline(templlinenum.numtempl + 1)
	/* Thumbnail entry w/ WAV file */
	numtempl = numtempl + 1
	imgwavstr = sourceline(templlinenum.numtempl + 1)
	/* Wav entry */
	numtempl = numtempl + 1
	wavstr = sourceline(templlinenum.numtempl + 1)
	/* Empty entry */
	numtempl = numtempl + 1
	emptystr = sourceline(templlinenum.numtempl + 1)
	/* Row end */
	numtempl = numtempl + 1
	rowend = sourceline(templlinenum.numtempl + 1)

	rc = stream(tempfn2, 'C', "OPEN READ")
	do i = 1 to avi.0 + gif.0 + jpg.0 + mpg.0 + wav.0
		numc = numc + 1
		if numc > numcol then
		do
			numc = 1
			call lineout fn, rowend
			call lineout fn, rowentry
		end
		/* sepchar='|' */
		parse value linein(tempfn2) with ln2 '|' fn2 '|' wavfn2 '|' wavsz2
		/* File size */
		sz = '('||trunc(stream(fn2, 'C', "QUERY SIZE") / 1024 + 0.5)||"k)"
		select
			when (translate(right(fn2, 3)) = "GIF") | (translate(right(fn2, 3)) = "JPG") then
			do
				/* Thumbnail image file? */
				if thmimg = 'Y' then
				do
					thmimgfn = thmimghd || substr(fn2, length(thmimghd) + 1)
					/* Use ImageMagick 4.2+ */
					"@convert -geometry " || thumbx || " " || fn2 || " " || thmimgfn
				end
				else
				do
					thmimgfn = fn2
				end
				if wavfn2 = '' then
				do
					str1 = replstr(imgstr, "%s", colwid)
					str2 = replstr(str1, "%s", fn2)
					str3 = replstr(str2, "%s", thmimgfn)
					str4 = replstr(str3, "%s", thumbx)
					str5 = replstr(str4, "%s", thumby)
					str6 = replstr(str5, "%s", fn2)
					str7 = replstr(str6, "%s", ln2)
					str8 = replstr(str7, "%s", "<BR>"||sz)
					call lineout fn, str8
				end
				else
				do
					str1 = replstr(imgwavstr, "%s", colwid)
					str2 = replstr(str1, "%s", fn2)
					str3 = replstr(str2, "%s", thmimgfn)
					str4 = replstr(str3, "%s", thumbx)
					str5 = replstr(str4, "%s", thumby)
					str6 = replstr(str5, "%s", fn2)
					str7 = replstr(str6, "%s", ln2)
					str8 = replstr(str7, "%s", "<BR>"||sz)
					str9 = replstr(str8, "%s", wavfn2)
					str10 = replstr(str9, "%s", '('||wavsz2||"k)")
					call lineout fn, str10
				end
			end
			otherwise
			do
				str1 = replstr(wavstr, "%s", colwid)
				str2 = replstr(str1, "%s", fn2)
				str3 = replstr(str2, "%s", ln2)
				str4 = replstr(str3, "%s", "<BR>"||sz)
				call lineout fn, str4
			end
		end
	end
	rc = stream(tempfn2, 'C', "CLOSE")

	/* Add empty entry */
	if numc < numcol then
	do i = numc + 1 to numcol
		str1 = replstr(emptystr, "%s", colwid)
		call lineout fn, str1
	end
	call lineout fn, rowend
end
else
do
	numtempl = numtempl + 7
end

/* Footer 1 */
numtempl = numtempl + 1
numtemple = numtempl + 1
do i = templlinenum.numtempl + 1 to templlinenum.numtemple - 1
	call lineout fn, sourceline(i)
end
/* Modified date/time */
numtempl = numtempl + 1
/* str1 = replstr(sourceline(templlinenum.numtempl + 1), "%s", left(date('W'), 3)||', '||date('N')||', '||time('C')) */
str1 = replstr(sourceline(templlinenum.numtempl + 1), "%s", left(date('W'), 3)||' '||left(date('M'), 3)||' '||left(date('E'), 2)||' '||time()||' '||right(date('N'), 4))
call lineout fn, str1
/* Footer 2 */
numtempl = numtempl + 1
numtemple = numtempl + 1
do i = templlinenum.numtempl + 1 to templlinenum.numtemple - 1
	call lineout fn, sourceline(i)
end

/* Close */
rc = stream(fn, 'C', "CLOSE")
if stream(tempfn1, 'C', "QUERY EXISTS") <> '' then
do
	"@del" tempfn1
end
if stream(tempfn2, 'C', "QUERY EXISTS") <> '' then
do
	"@del" tempfn2
end
say "Thumbnail file for "||newfilespec("Name", directory())||" generated."

exit

getln:
arg fname

call SysGetEA fname, ".longname", "ln"
if ln <> '' then
do
	ln = substr(ln, 5)
end
else
do
	ln = newfilespec("Name", fname)
end

return ln

getfiledate:
arg fname
dt1 = stream(fname, 'C', "QUERY DATETIME")
dt2 = substr(dt1, 7, 2)||'/'||substr(dt1, 1, 2)||'/'||substr(dt1, 4, 2)||"<BR>"||substr(dt1, 11, 8)

return dt2

/* filespecがoptions 'EXMODE';でASCII 1文字のファイル名に対して */
/* 空白を返すため、空白ならoptions 'NOEXMODE';で実行する */
newfilespec:
parse arg opt, nm
fs = filespec(opt, nm)

if fs = "" then
do
	options 'NOEXMODE';
	fs = filespec(opt, nm)
	options 'EXMODE';
end

return fs

usage:
say "Usage:"
say cmdname "再帰的(Y/N) ファイル名/日時切替(N/D) サムネイルイメージ作成(Y/N) 1行に入るサムネイルの数 サムネイルファイル上書き(Y/N) サムネイルファイル名"
do i = 1 to sourceline()
	if pos("パラメータ", sourceline(i)) > 0 then
	do
		i = i + 1
		n = 1
		do while pos("*/", sourceline(i)) = 0
			say n||': '||sourceline(i)
			i = i + 1
			n = n + 1
		end
		exit
	end
end

exit

/* Lines below are HTML templates
$$templ$ Start of HTML template
<!-- This file "%s" was generated by %s -->
$$templ$ HTML header 1
<HTML>
<HEAD>
$$templ$ Title
<TITLE>Directory "%s" thumbnails</TITLE>
$$templ$ HTML header 2
</HEAD>

<BODY text=Black>
<BASEFONT SIZE=3>
<A NAME="top"></A>
<CENTER>
<FONT SIZE=6 COLOR=Brown>
$$templ$ Directory name
<B>Directory "%s" thumbnails</B><BR>
</FONT>
</CENTER>
<P>
$$templ$ Parent directory
<A HREF="../%s">Back to the parent directory</A><P>
$$templ$ Beginning of subdirectories section
Subdirectories
<P>
$$templ$ Subdirectory entries
<A HREF="%s/%s">%s</A><BR>
$$templ$ Thumbnail headers
<P>
<HR>
<P>
Click to show the full picuture. Image titles(if any) are OS/2 long file names.<BR>
$$templ$ Row entry
<TABLE BORDER WIDTH=100%><TR VALIGN="TOP">
$$templ$ Thumbnail entry
<TD WIDTH="%s"><A HREF="%s"><IMG SRC="%s" WIDTH="%s" HIGHT="%s" ALIGN="TOP" ALT="%s"><BR CLEAR="ALL">%s</A>%s</TD>
$$templ$ Thumbnail w/WAV entry
<TD WIDTH="%s"><A HREF="%s"><IMG SRC="%s" WIDTH="%s" HIGHT="%s" ALIGN="TOP" ALT="%s"><BR CLEAR="ALL">%s</A>%s<BR<>A HREF="%s">WAV file</A>%s</TD>
$$templ$ Wav, AVI, MPG entry
<TD WIDTH="%s"><A HREF="%s">%s</A>%s</TD>
$$templ$ Empty entry
<TD WIDTH="%s"> </TD>
$$templ$ Row end
</TR></TABLE>
$$templ$ HTML Footer 1
<BR>
<!-- hhmts start -->
$$templ$ Modified date/time
Last modified: %s
$$templ$ HTML Footer 2
<!-- hhmts end -->
<BR>
<DIV ALIGN="RIGHT">
<A HREF="#top">Return to top</A>
</DIV>
</BODY>
</HTML>
$$templ$ End of HTML template
*/