/* REXX */
/* lzh内のJPEGファイルをテンポラリのライトテーブルに解凍して開く */
/* (C) Copyright 1999 kyo */
options 'ETMODE'; options 'EXMODE';
arg prm '@' tr
trace value tr;

/* Load functions */
if RxFuncQuery('SysLoadFuncs') then call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* OSとコマンド名取得 */
parse source os . cmdname

/* コマンド名取得 */
/* 文字列を反転して'.'と最初の'\'で分解 */
rvcmdname = reverse(cmdname)
parse var rvcmdname rvcmdext '.' rvcmdbody '\' rvcmddir
cmdname = reverse(rvcmdbody) || '.' || reverse(rvcmdext)

/* パラメータ処理 */
if prm = '' then signal usage
parse var prm fname otherprm
if fname = '' then signal usage

/* 余分なパラメータはエラー */
if otherprm <> '' then signal usage

/* 対象ファイルの存在確認 */
if stream(fname, 'C', "QUERY EXISTS") = "" then signal usage

/* 対象ファイル名を分割 */
rvfname = reverse(fname)
parse var rvfname rvext '.' rvbody '\' rvdir
if rvbody = '' then
do /* 拡張子なしのファイル */
	parse var rvfname rvbody '\' rvdir
	rvext = ''
end
body = reverse(rvbody)
ext = reverse(rvext)
dir = reverse(rvdir)

/* 拡張子が"lzh"あるいは"zip" */
if translate(ext) <> "LZH" & translate(ext) <> "ZIP" then signal usage

/* 環境変数temp取得 */
tempdir = value("TEMP", , "OS2ENVIRONMENT")
if tempdir = "" then signal notemp

/* テンポラリのライトテーブル作成; 圧縮ファイル名の拡張子を省いた形式 */
classname = "MMFolder"
title = body
trgt = tempdir
setup = ""

/* テンポラリのライトテーブル作成 */
rc = SysCreateObject(classname, title, trgt, setup, 'R')

/* ファイル解凍 */
if translate(ext) = "LZH" then
do
	"lha e "fname tempdir||"\"||body||"\"
end
else
do
	"unzip "fname" -d "tempdir||"\"||body||"\"
end

/* テンポラリのライトテーブルを開く */
rc = SysSetObjectData(tempdir||"\"||body, 'OPEN=ICON')

/* 待機 */
say "Hit ENTER key to delete temporary files"
pull

/* テンポラリのライトテーブル削除 */
rc = SysDestroyObject(tempdir||"\"||body)

exit

notemp:
say "環境変数tempが定義されてません"
exit

usage:
say "Usage:"
say cmdname "圧縮ファイル名"
exit