/* REXX */
/* MULTIPLE DIGITS OF E */
/* (C) Copyright 1997 kyo */
ARG PN '@' TR
IF PN = '' THEN PN = 10    /* DIGITS */
FN = 100                   /* FACTORIALS */
DN = PN + 10               /* DIGITS */
DGT = 5
LIM = 10 ** DGT
F.1 = LIM / 2
E.1 = F.1
DO I = 2 TO DN; E.I = 0; F.I = 0; END
P = 1
TRACE VALUE TR
DVS = 3
DO WHILE P <= PN & DVS < FN
    C = 0; R = 0
    DO I = P TO DN
        DVD = F.I + R * LIM
        R = DVD // DVS
        F.I = DVD % DVS
        E.I = E.I + F.I
    END
    IF F.P = 0 THEN P = P + 1
    DVS = DVS + 1
END
CALL OVFLW
CALL PRTANS
EXIT

OVFLW:
C = 0
DO K = DN TO 1 BY -1
    E.K = E.K + C
    IF E.K >= LIM THEN
        DO
            C = E.K % LIM
            E.K = E.K // LIM
        END
    ELSE C = 0
END
RETURN
PRTANS:
SAY 'CALC UNTIL 1/'DVS - 1'!'
SAY 'E = 2.'
DO L = 1 TO DN BY 10
    ANS = ''
    DO M = L TO MIN(L + 9, PN)
        ANS = ANS RIGHT(E.M, DGT, '0')
    END
    SAY ANS
END
RETURN