; $Id: int13ldr.asm,v 1.2 2001/07/18 21:29:06 root Exp $
;
; This snippet is a wrapper for ft_muRead, which intercepts INT 13h calls
; to write invalidated header as soon as the original header is read.

		push	bx
		sub	bx, bx
		mov	fs, bx
		mov	bx, word ptr fs:[004Ch]
		mov	word ptr cs:int13old, bx
		mov	bx, word ptr fs:[004Eh]
		mov	word ptr cs:int13old+2, bx
		mov	word ptr fs:[004Ch], offset int13hdl
		mov	word ptr fs:[004Eh], cs
		pop	bx
		call	dword ptr ds:EX_muRead
		push	bx
		sub	bx, bx
		mov	fs, bx
		mov	bx, word ptr cs:int13old
		mov	word ptr fs:[004Ch], bx
		mov	bx, word ptr cs:int13old+2
		mov	word ptr fs:[004Eh], bx
		pop	bx
		jmp	EX_retpoint

; Handler body

int13hdl:
		pusha
		push	ds
		push	es
		mov	byte ptr cs:int13func, ah
		pushf
		call	dword ptr cs:int13old
		pushf
		pop	word ptr ret_flags
		jc	int13exit	; Pass the faulty case to the OS2LDR
		mov	ah, byte ptr cs:int13func
		cmp	ah, 42h
		je	int13rd42
		cmp	ah, 2
		jne	int13exit

int13rd2:				; Old-style read function
		mov	si, offset EX_Hybernating
		push	cs
		pop	ds
		mov	di, bx
		push	cx
		mov	cx, 6
		repe	cmpsw
		pop	cx
		jnz	int13exit
		mov	byte ptr es:[bx], 'X'
		mov	ax, 301h
		int	13h
		jmp	int13exit

int13rd42:				; INT 13h Extensions
		cmp	word ptr ds:[si+2], 0
		jz	int13exit	; Nothing read
		push	ds
		push	si
		mov	di, word ptr ds:[si+4]
		mov	es, word ptr ds:[si+6]
		push	cs
		pop	ds
		mov	si, offset EX_Hybernating
		mov	cx, 6
		repe	cmpsw
		pop	si
		pop	ds
		jnz	int13exit
		mov	di, word ptr ds:[si+4]
		mov	es, word ptr ds:[si+6]
		mov	byte ptr es:[di], 'X'
		mov	ax, 4300h
		int	13h

int13exit:				
		pop	es
		pop	ds
		popa
		push	ax		; Flip the stack, garbling the flags
		push	bx
		mov	ax, cs:ret_flags
		mov	bx, sp
		mov	word ptr ss:[bx+8], ax
		pop	bx
		pop	ax
		iret
		
; Data area

int13old	dd	0
ret_flags	dw	0
int13func       db	0
		