/*
 * dumpbdf.c - read BDF font file and dumps font informations
 */

#include <stdio.h>
#include <stdlib.h>
#include "font.h"

FontPtr ReadBdfFont(FILE *fp) ;     /* in readbdf.c */

int main(int ac, char *av[])
{
    int     i  ;
    FILE    *filePtr ;
    FontPtr fontPtr  ;

    _wildcard(&ac, &av) ;

    for (i = 1 ; i < ac ; i++) {
        if ((filePtr = fopen(av[i], "r")) == NULL) {
	    fprintf(stderr, "cannot open %s\n", av[i]) ;
	    continue ;
	}
	if ((fontPtr = ReadBdfFont(filePtr)) == NULL) {
	    fprintf(stderr, "failed to get BDF font in %s\n", av[i]) ;
	} else {
	    DumpFontInfo(fontPtr) ;
	    FreeFontInfo(fontPtr) ;
	}
        fclose(filePtr) ;
    }
    return 0 ;
}
