//
// C(hange)F(ont) v0.01
//
//=============================================================
// (c) VicTor Smirnoff, 1998            <root@water.karelia.su>
//-------------------------------------------------------------
// tFont v1.0 by Tomas Oegren was used as prototype
// (c) Tomas Oegren, 1996                <stric@freenet.hut.fi>
//=============================================================
#define INCL_VIO
#define INCL_DOSERRORS

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define MY_ERROR_SIZE   ERROR_USER_DEFINED_BASE+1

void main( int, char ** );
void PrintError( APIRET, char * );
void HowUse( void );
APIRET ReadFromFile( char *, char *, int );

void main( int argc, char ** argv )
{
   VIOFONTINFO font;
   VIOMODEINFO mode;
   APIRET      rc;
   PVOID       buf;
   USHORT      cp;
   BOOL        onlyShow;
   char        fontFile[_MAX_PATH];

   onlyShow = (argc<=1);

   if ( argc>2 )
   {
      HowUse();
      return;
   }

   if ( argc==2 )
   {
      if ( !strcmp(argv[1],"-?") ||
           !strcmp(argv[1],"-h") ||
           !strcmp(argv[1],"-H") )
      {
         HowUse();
         return;
      } else strcpy(fontFile,argv[1]);
   }

   mode.cb = sizeof(VIOMODEINFO);

   rc = VioGetMode( &mode, 0 );
   if (rc)
   {
      PrintError( rc , "VioGetMode" );
      return;
   }

   if ( onlyShow )
   {
      printf("\n  Mode: 0x0%x\n Color: %lu\nColumn: %lu\n   Row: %lu\n H-res: %lu\n V-res: %lu\n",
         mode.fbType, mode.color, mode.col, mode.row, mode.hres, mode.vres);

      rc = VioGetCp( 0, &cp, 0 );
      if (rc)
      {
         if (rc!=ERROR_VIO_USER_FONT)
         {
            PrintError( rc , "VioGetCp" );
            return;
         }
      }
      
      if (rc!=ERROR_VIO_USER_FONT)  printf("\nCodepage: %lu\n", cp);
      else  printf("\nCodepage: selected user font table\n");
   }

   if ( !onlyShow && ((mode.hres>640) || (mode.vres>400)) )
   {
      if (mode.hres>640) mode.hres = 640;
      if (mode.vres>400) mode.vres = 400;

      mode.cb = 12;

      rc = VioSetMode( &mode, 0 );
      if (rc)
      {
         PrintError( rc , "VioSetMode" );
         return;
      }

   }

   font.cb = sizeof(VIOFONTINFO);
   font.type = 0;
   font.cbData = 0;
   font.pbData = NULLHANDLE;

   rc = VioGetFont( &font, 0 );
   if (rc)
   {
      PrintError( rc , "VioGetFont" );
      return;
   }

   if ( onlyShow )
   {
      printf("\nFontsize: %lux%lu\nTotal bytes needed for font: %lu\n",
         font.cxCell, font.cyCell, font.cbData);
      return;
   }

   rc = DosAllocMem( (PPVOID)&buf,
                     (ULONG)font.cbData,
           PAG_WRITE | PAG_READ | PAG_COMMIT | OBJ_TILE );
   if (rc)
   {
      PrintError( rc , "DosAllocMem" );
      return;
   }

   rc = ReadFromFile( fontFile, buf, font.cbData );
   if (rc)
   {
      PrintError( rc , fontFile );
      DosFreeMem( buf );
      return;
   }

   font.cb = sizeof(VIOFONTINFO);
   font.type = 0;
   font.pbData = buf;    // thunk pointer32 to pointer16

   rc = VioSetFont( &font, 0 );
   if (rc)  PrintError( rc , "VioSetFont" );
   DosFreeMem( buf );

   return;

}

void HowUse(void)
{
   printf("\nC(hange)F(ont) v0.01\n\n");
   printf("Usage:\tcf.exe [-?|-h|<filename>]\n");
   printf("\twithout params      Display status only\n");
   printf("\t<filename>          Name of a font file\n");
   printf("\t-?                  This help\n");
   printf("\t-h                  This help\n");
   printf("\nThis program changes the current font in a fullscreen OS/2 VIO\n\n");
}

void PrintError( APIRET rc, char * t )
{
   switch (rc)
   {
   case ERROR_VIO_EXTENDED_SG:
      printf("\nYou can't run this program in an Windowed session.\n");
      break;
   case ERROR_VIO_MODE:
      printf("\nSorry, your drivers does not support this call.\nYou must exit this session, since it's \"broken\" now.\n");
      break;
   case MY_ERROR_SIZE:
      printf("\nFilesize differs from size needed for the font or\nan read error has occurred\n");
      break;
   default:
      printf("\n%s: an error has occurred, errorcode = %ld\n",t,rc);
      break;
   }
}

APIRET ReadFromFile( char * fileName, char * dataBuffer, int dataSize )
{
   ULONG        FileInfoLevel;
   FILESTATUS3  FileInfoBuf;
   ULONG        FileInfoBufSize;
   ULONG userAct, fileSize;
   HFILE hFile;
   APIRET rc;

   userAct = FILE_EXISTED;
   rc = DosOpen( fileName,
                 &hFile,
                 &userAct,
                 (ULONG)0L,
                 FILE_NORMAL,
                 OPEN_ACTION_OPEN_IF_EXISTS,
                 OPEN_FLAGS_FAIL_ON_ERROR |
                 OPEN_SHARE_DENYWRITE |
                 OPEN_ACCESS_READONLY,
                 NULL );
   if ( rc ) return(rc);

   FileInfoLevel = 1;
   FileInfoBufSize = sizeof(FILESTATUS3);
   rc = DosQueryFileInfo(hFile, FileInfoLevel,
                         &FileInfoBuf, FileInfoBufSize);
   fileSize = FileInfoBuf.cbFile;
   if ( rc ) return(rc);
   if ( fileSize!=dataSize ) return(MY_ERROR_SIZE);

   rc = DosRead( hFile,
                 dataBuffer,
                 fileSize,
                 &userAct );
   if ( rc )
   {
      DosClose(hFile);
      return(rc);
   }
   DosClose(hFile);
   if ( userAct!=dataSize ) return(MY_ERROR_SIZE);
   return(0);
}


