/*23 Nove 1999. Daniel Hellerstein (danielh@crosslink.net)
     Test the rxGDIFF procedure. See GDIFF.DOC for the details
*/

if rxfuncquery('rxGdiff')=1  then do
  call RXFuncAdd 'RXGdiffLoad', 'RXGDIFF', 'RxGdiffLoad'
  call RxGdiffLoad
end
if rxfuncquery('rxGdiff')=1  then do
  say "ERROR could not load  RxGdiff.DLL"
  exit
end


say "This program demonstrates the rxGdiff procedure"

oldfile='tst\dir.doc'            /* the "original file" */
newfile='tst\dirnew.doc'        /* the "new file " */
diffile='dir.dif'               /* the difference file */

newfile2='dir.nu2'              /* recreate the newfile, using diffile */

/* Create the difference file */
say "Computing difference file between: "
say "   "oldfile ' and ' newfile
stat=rxGdiff(oldfile,newfile,diffile,'-q')
if stat<>0 then do
  say "Error creating  difference file: "stat
  exit
end
ii=stream(diffile,'c','query size')
say diffile ' created ('ii 'bytes)'

/* using the difference file, "undifference" and create the duplicate newfile */
stat=rxGdiff(oldfile,diffile,newfile2,'-u','-q')
if stat<>0 then do
  say "Error undifferencing: "stat
  exit
end
ii=stream(newfile2,'c','query size')
say newfile2 ' created (from undifferencing) ('ii 'bytes)'

/* check the md4s of the newfile and newfile2 */
/* results are written to stdout */
say "Md4s of "newfile " and " newfile2|| ":"
stat=rxGdiff(newfile,newfile2,'-md4')
if stat<>0 then do
  say "Error computing md4: "stat
  exit
end

exit



