/* replacer.cmd
by Marko Zarkovic, Ottawa Canada
February 2000

Instructions
~~~~~~~~~
Replacer searches for instances of a master file <filename> on x: and replaces each instance. 
I use Replacer to update certain drivers for my Warp Connect installations. I keep all
the update drivers in a single directory, then run Replacer as follows:
for %1 in (*.*) do replacer %1 x: 
*/

'@echo off'

parse arg filename searchpath
if (filename = '') | (searchpath = '') then do
 say "Need two arguments: [path\]filename [x: || x:\path]"
 exit
end
st=time()
call findargs
call endofit
exit


/*###############################################
*/

findargs:
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

parse upper var filename filename
rc=SysFileTree(filename, sfstr, F)
if sfstr.0=0 then do
 say "Could not find the source file."
 exit
end
parse var sfstr.1 sdate stime ssize satt spath
say "Searching for" filename "with attributes"
say sdate stime ssize satt 
say "in" searchpath || "..."
parse upper var filename p1 "." p2
if p2 = "" then 
 p2 = ".*"
rc=SysFileTree(searchpath||'\*.' || p2, fstr, 'SF')
if fstr.0 > 0 then 
 do i=1 to fstr.0
  parse var fstr.i fdate ftime fsize fatt fpath
  fname=filespec("name", fpath)
  rc=compare(filename, fname)
  if rc = 0 then do
   beep(1500,50)
   say "Found an instance of" filename "in" filespec("drive", fpath)||filespec("path", fpath)
   say "Attributes of" fname
   say fdate ftime fsize fatt
   COPY filename fpath
  end
 end
return

talker:
beep(1500,50)
beep(500,50)
beep(1500,50)
return

endofit:
et=time()
say "replacer started at >>>" st "; ended at >>>" et
call talker
return
