/* TreeSize - (c) Torsten Balle Koefoed of Sirius Cybernetics 1998 */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Parse Arg BaseDir

Numeric Digits 12

If BaseDir = '' then
    BaseDir = Directory()

If SubStr(BaseDir, 1, 3) = '...' then
Do
    DotCount = '-1'
    Do While SubStr(BaseDir, 1, 1) = '.'
        DotCount = DotCount + 1
        BaseDir = SubStr(BaseDir, 2)
    End
    BaseDir = SubStr(BaseDir, 2)
    Do DotCount
        BaseDir = '..\' || BaseDir
    End
End

If SubStr(BaseDir, Length(BaseDir)) = '\' then
    BaseDir = SubStr(BaseDir, 1, Length(BaseDir) - 1)

If SubStr(BaseDir, 1, 1) = '"' then
    BaseDir = SubStr(BaseDir, 2)

If  SubStr(BaseDir, Length(BaseDir)) = '"' then
    BaseDir = SubStr(BaseDir, 1, Length(BaseDir) - 1)

If SubStr(BaseDir, 2, 1) \= ':' then
Do
    CurrentDir = Directory()
    BaseDir = Directory(BaseDir)
    Call Directory CurrentDir
End

If SysFileTree(BaseDir'\*', FoundFiles, S) = 0 then
Do
    TreeSize = '0'
    AllocSize = '0'
    DirCount = '0'
    FileCount = '0'
    Do i = 1 to FoundFiles.0
        CurrentSize = SubWord(FoundFiles.i, 3, 1)
        TreeSize = TreeSize + CurrentSize
        If SubStr(SubWord(FoundFiles.i, 4, 1), 2, 1) = 'D' then
        Do
            AllocSize = AllocSize + 512
            DirCount = DirCount + 1
        End
        Else
        Do
            AllocCurrent = Format((CurrentSize / 512) + 0.5, , 0) * 512
            AllocSize = AllocSize + AllocCurrent
            FileCount = FileCount + 1
        End
    End
    If TreeSize \= '0' & TreeSize > '999' then
    Do
        i = '3'
        Do until i > Length(TreeSize) - 1
            TreeSize = Insert('.', TreeSize, Length(TreeSize) - i)
            i = i + 4
        End
    End
    If AllocSize \= '0' & AllocSize > '999' then
    Do
        i = '3'
        Do until i > Length(AllocSize) - 1
            AllocSize = Insert('.', AllocSize, Length(AllocSize) - i)
            i = i + 4
        End
    End
    If FileCount = '1' then
        FileName = 'file'
    else
        FileName = 'files'
    If DirCount = '1' then
        DirName = 'dir'
    else
        DirName = 'dirs'
    Say '"'BaseDir'\"'" and subtree contains:"
    Say TreeSize' bytes in 'FileCount' 'FileName' and 'DirCount' 'DirName'   'AllocSize' bytes allocated'
End
Else
Do
    Say 'No files found'
End

Call SysDropFuncs
