#include <os2.h>

#include <stdlib.h>
#include <stdio.h>

int is_hab_initd=0;
HAB hab;

static void the_open( char *fname , const char *setup_string , int active )
{
  char buffer[ FILENAME_MAX ];
  if( fname[0] != '<' ){
    _fullpath( buffer , fname , sizeof(buffer) );
    fname = buffer;
  }

  char *p=fname;
  char *lastp=NULL , *last2p=NULL;
  const char *title;

  while( *p != '\0' ){
    last2p = lastp;
    lastp  = p;
    
    if( *p == '/' )
      *p = '\\';
    p++;
  }
  *p = '\0';
  
  if(   lastp != NULL  &&  *lastp  == '\\' 
     && last2p != NULL &&  *last2p != ':'  ){
    *lastp = '\0' ;
  }
  printf("open %s\n",fname);
  
  HOBJECT hObject=WinQueryObject( (PSZ)fname );
  WinSetObjectData( hObject , (PCSZ) setup_string );
  if( active )
    WinSetObjectData( hObject , (PCSZ) setup_string );
}

int main(int argc , char **argv)
{
  int number = 0; /* OPEN  */
  BOOL flag=TRUE; /* ł open ĂEChE𗘗p̂H*/
  const char *setup_string="OPEN=DEFAULT";
  int nopens=0;
  int active = 0;

  for(int i=1;i<argc;i++){
    const char *arg=argv[i];
    
    if( arg[0] == '-' ){
      switch( arg[1] ){
      default:
	fprintf(stderr,"open: bad option `%s'\n",arg);
	break;
	
      case 'a':
	active ^= 1;
	break;
	
      case 'p': /* vpeB[IvV */
      case 's':
	setup_string = "OPEN=SETTINGS";
	break;

      case 't':
	setup_string = "OPEN=TREE";
	break;

      case 'd':
	setup_string = "OPEN=DETAILS";
	break;
	
      case 'i':
	setup_string = "OPEN=ICON";
	break;

      case 'o':
	if( i+1 < argc ){
	  int len=strlen(argv[++i]);
	  char *tmp=(char*)alloca(len+7);
	  sprintf( tmp , "OPEN=%s" , argv[i] );
	  setup_string=tmp;
	}
	break;
      }
    }else{
      the_open(argv[i] , setup_string , active );
      nopens++;
    }
  }
  if( nopens == 0 )
    the_open("." , setup_string , active );

  return 0;
}
