/*
 *  ************************************************************************
 *                      	OS/2 Command-Line Utilities
 *  (c) Copyright 1991-2002 Jonathan de Boyne Pollard.  All Rights Reserved.
 *  ************************************************************************
 */

/* "@(#)MAKEOBJ.CMD version 1.0.2" */

'@echo off'

call RxFuncAdd 'SysGetMessage','RexxUtil','SysGetMessage'
call RxFuncAdd 'SysCreateObject','RexxUtil','SysCreateObject'
call RxFuncAdd 'SysOpenObject','RexxUtil','SysOpenObject'
call RxFuncAdd 'SysCreateShadow','RexxUtil','SysCreateShadow'

parse source opsys mode script
ApplicationDir = filespec('Drive',script)||filespec('Path',script)||"..\"
ReadMeDir = left(ApplicationDir,length(ApplicationDir)-15)||"ReadMe\"

startupdir = "STARTUPDIR="||ApplicationDir||"..\"
FolderID = "<WP_CLU>"

ContainingFolder = "<WP_PROGRAMSFOLDER>"
If 0 == SysOpenObject(ContainingFolder, "DEFAULT", 0) Then do
	Say "Unable to open the Programs folder"
	ContainingFolder = "<WP_DESKTOP>"
end

If 0 == SysCreateObject("WPFolder", "Command-Line Utilities", ContainingFolder, "OBJECTID=<WP_CLU>", "Update") Then do
	Say "Unable to create folder for command-line utilities"
end

If 0 == SysCreateShadow(FolderID, "<WP_DESKTOP>") Then do
	Say "Unable to create shadow of the folder for the command-line utilities"
end

If 0 == SysCreateObject("WPProgram", "Digital Clock", FolderID,
					   ,"EXENAME="ApplicationDir||"DIGCLOCK.EXE;"||startupdir, "Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysCreateObject("WPProgram", "Analogue Clock", FolderID,
					   ,"EXENAME="ApplicationDir||"ANACLOCK.EXE;"||startupdir, "Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysCreateObject("WPProgram", "Timezone string calculator", FolderID,
					   ,"EXENAME="ApplicationDir||"CALCTZ.EXE;"||startupdir, "Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysCreateObject("WPProgram", "PM Window tree", FolderID,
					   ,"EXENAME="ApplicationDir||"WINSIGHT.EXE;"||startupdir, "Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysCreateObject("WPProgram", "Boot Manager settings", FolderID,
					   ,"EXENAME="ApplicationDir||"SETBOOTG.EXE;"||startupdir, "Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysCreateObject("WPProgram", "CPU Information", FolderID,
					   ,"EXENAME="ApplicationDir||"CPUIDG.EXE;"||startupdir, "Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysCreateObject("WPProgram", "Description Editor", FolderID,
					   ,"EXENAME="ApplicationDir||"DESCEDIT.EXE;PARAMETERS=[Wildcard file/directory name to expand];"||startupdir, "Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysCreateObject("WPShadow", "ReadMe.TXT", FolderID,
					   ,"SHADOWID="||ReadMeDir||"ReadMe.TXT", "Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysCreateObject("WPProgram", "Documentation", FolderID,
					   ,"EXENAME=VIEW.EXE;PARAMETERS=Book\CLU21.INF;"||startupdir, "Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysCreateObject("WPUrl", "Blurb", FolderID,
					   ,"LOCATOR=file:///"||ReadMeDir||"Blurb.HTML;"||startupdir, "Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysCreateObject("WPUrl", "Web Page", FolderID,
					   ,"LOCATOR=http://homepages.tesco.net./~J.deBoynePollard/Softwares/clu.html;"||startupdir,"Update") Then do
	Say "Unable to create program object for command-line utilities"
end

If 0 == SysOpenObject(FolderID, "DEFAULT", 0) Then do
	Say "Unable to open the command-line utilities folder"
end
