/* VOLS.CMD   REXX CMD by Gord Snider  v1.1  2003/02/17  */
/* PURPOSE: to display a list of LOCAL, writeable volumes available with their
       partition letters, partition labels, actual used space,
       per cent used space, actual free space, per cent free space
       and total space.  
       Default is to show all such volumes in MegaBytes.  
       1 KB = 1024 B,       1 MB = 1024 KB = 1,048,576 B

   SYNTAX:  VOLS [partitions] [switches]

       where optional partitions is a list of one or more partition letters 
             with colons and spaces,
             e.g.  VOLS C: D: E: 
             will show stats for volumes C: D: and E:  which must exist 
             on your system
       where optional switches may be 
       '/B'   to show the results in bytes
       '/?'   to show a small help screen and exit
       '/T'   for debug to turn on the Trace function with ?i
*/
if LRU() then exit
arg argvols '/' switches  

numeric digits 15                                                 /* for large hard drives */

if pos('T', switches) > 0 then trace ?i                           /* check for trace request     */

if pos('?', switches) > 0 then do                                 /* check for help screen request */
    do l = 1 until substr(sourceline(l), 1, 2) = '*/'
      say sourceline(l)
    end l
  exit
end  /* if */

MB = 1048576                                                     /* define MegaByte  */

vols = ''                                                         /* verify arguments */
do i = 1 to words(argvols)                            
   if wordpos( word( argvols, i), SysDriveMap( , 'LOCAL')) > 0 then vols = vols word( argvols, i)
      else say word( argvols, i) 'is not a local volume.'
end i                                                 
if vols = '' then vols = SysDriveMap( , 'LOCAL')                  /* set default display   */

totused  = 0                                                      /* total used space  */
totfree  = 0                                                      /* total free space  */
tottotal = 0                                                      /* hard drive size   */

say
if pos('B', switches) > 0 then do                                 /* create bytes display */
  say '   Label           Bytes Used    PC      Bytes Free    PC           Total'
  do i = 1 to words(vols)                                         /* split the map into drives */
     parse value SysDriveInfo(word(vols, i)) with drive free total label .
     if drive = '' then do
        totused  = totused  + (total - free)
        totfree  = totfree  + free 
        tottotal = tottotal + total
        say drive ,                                               /* output line for each drive */
            left(label, 10) ,                                  
            right(commas(total - free), 15) ,                     /* used space    */
            format(((total - free) / total * 100),3,1) ,          /* per cent used */
            right(commas(free), 15) ,                             /* free space    */
            format((free / total * 100),3,1) ,                    /* per cent free */
            right(commas(total), 15)                              /* total space   */
     end /* if then do */
  end i
  say; say,                                                       /* totals line */
            copies(' ', 3) ||,                                    /* spacer for drive letter */
           left('Totals', 11) ||,                     
           right(commas(totused), 15) ||,                         /* Total used space */
           copies(' ',  7) ||,                                    /* spacer for per cent used */
           right(commas(totfree), 15) ||,                         /* Total free space */
           copies(' ', 7) ||,                                     /* spacer for per cent free */
           right(commas(tottotal), 15)                            /* Total local drive space in system */
     end
else do                                                           /* create megabyte display */
  say '   Label              MB Used    PC         MB Free    PC           Total'
  do i = 1 to words(vols)                                         /* split the map into drives */
     parse value SysDriveInfo(word(vols, i)) with drive free total label .
     if drive = '' then do
        totused  = totused  + (total - free)
        totfree  = totfree  + free 
        tottotal = tottotal + total
        say drive ,                                               /* output line for each drive */
            left(label, 10) ,                                  
            right(commas(format((total - free) / MB,,1)), 15) ,   /* used space    */
            format(((total - free) / total * 100),3,1) ,          /* per cent used */
            right(commas(format(free / MB,,1)), 15) ,             /* free space    */
            format((free / total * 100),3,1) ,                    /* per cent free */
            right(commas(format(total / MB,,1)), 15)              /* total space   */
     end /* if then do */
  end i
  say; say,                                                       /* totals line */
           copies(' ', 3) ||,                                     /* spacer for drive letter */
           left('Totals', 11) ||,                     
           right(commas(format(totused / MB,,1)), 15) ||,         /* Total used space */
           copies(' ',  7) ||,                                    /* spacer for per cent used */
           right(commas(format(totfree / MB,,1)), 15) ||,         /* Total free space */
           copies(' ', 7) ||,                                     /* spacer for per cent free */
           right(commas(format(tottotal / MB,,1)), 15)            /* Total local drive space in system */
  end  /* do */
exit 0

commas: procedure 
arg whole '.' decimal
output = ''
reversed = reverse(whole)
do while length(reversed) > 0
   parse var reversed 1 part 4 reversed
   partfwd = reverse(part)
   if length(reversed) > 0 then partfwd = ','partfwd
   output = partfwd || output 
end /* do */
if decimal = '' then output = output || '.' || decimal
return output
