/* RDD.CMD         REXX CMD by Gord Snider  V1.2  2003/02/17 */
/* PURPOSE: From the current directory, prune a branch starting with
   the subdirectory of the current directory named as an argument. 

   SYNTAX:  RDD /?
       or   RDD subdirectory [switches]

   Optional switches (none, or /? only, or one or more of the 
   others):
   /? (HELP)   Shows a small help screen and exits.
   /S (SILENT) Skips the 'Really prune ...?' question and the 
      confirmation message.
   /L (LIST)   Lists each directory as it is entered. 
   /D (DIRECTORY) Lists each directory as it is removed.
   /F (FILE)   Lists each file as it is deleted.
   /T (TRACE)  Turns on the TRACE ?I command.
*/
/* There are 2 conditions that prevent the deleting of a directory:
   a. there are files in the directory, or
   b. there are subdirectories in the directory.
   This Exec takes these actions:
   1  Calls the recursive procedure NEXT: passing the target directory,
   2  NEXT: Switches to the subdirectory specified as an argument,
   3  Executes SysFileTree looking for any subdirectories,
      and records their names in a list as a compound variable. 
      A loop is set up to handle them, if any, in turn.
      a. If there are subdirectories, takes the next unhandled one and
         calls NEXT: procedure recursively, passing the name of that 
         first unhandled one, i.e. back to step 1. but one step closer 
         to a 'leaf' directory.  Because of the PROCEDURE statement of 
         the NEXT: routine the names of any unhandled directories are 
         preserved by REXX until the execution of the RETURN statement 
         and a new set of directory names in compound variables is 
         initiated.  
         This is true for each level of directories until a 
         leaf directory is reached.
      b. If there are no subdirectories in this directory then a 'leaf'
         directory has been reached so SysFileTree is called looking for
         files.  If any are found they are deleted.
   4  The RETURN statement executes.  All variables associated with the
      leaf directory just searched are abandoned, and the list and loop
      of sub- directories of this level is re-exposed and re-activated.
   5  Control passes to the statement following the CALL.
   6  The current directory is changed to be the parent of this 'leaf'
      one.
   7  The leaf directory is deleted.
   8  The next unhandled directory in the list is handled.
*/
if LRU() then exit
                   
parse arg target '/' switches
if pos('"', target) > 0 then parse var target . '"' target '"' .
target = strip(target, 'T')
switches = translate(switches)

if target = '' | pos('?', switches) > 0 then do         /* if no target is named, or help is asked for */
    do l = 1 until substr(sourceline(l), 1, 2) = '*/'
      say sourceline(l)
    end l
  exit
  end  /* if target */

if pos('T', switches) > 0 then trace ?i

msg.SFT.0   = 'SysFileTree successful'
msg.SFT.2   = 'Error: Not enough memory'
msg.SFD.0   = 'Deleting'
msg.SFD.2   = 'Error: File not found'
msg.SFD.3   = 'Error: Path not found'
msg.SFD.5   = 'Error: Access denied'
msg.SFD.87  = 'Error: Invalid parameter'
msg.SRD.0   = 'Removing'
msg.SRD.2   = 'Error: File not found'
msg.SRD.3   = 'Error: Path not found'
msg.SRD.5   = 'Error: Access denied'
msg.SRD.16  = 'Error: Current directory'
msg.SRD.108 = 'Error: Drive locked'
msg.SRD.206 = 'Error: Filename exceeds range'

current = directory()                     /* save fully qualified current directory for return */
call SysFileTree '*', 'test.', 'DO'       /* get list of fully qualified valid target candidates */
testword = ''
do i = 1 to test.0
   testword = testword test.i             /* concatenate */
end i                                     /* then conditionally construct a fully qualified target */
if pos(current || '\' || target, testword) > 0 then target = current || '\' || target 
   else do
      say 'Argument must be an unqualified subdirectory of the current directory.' 
      exit
      end

call directory current                    /* and return to start */

if pos('S', switches) = 0 then do
    say
    say 'Really prune branch starting at' target'?'
    say 'Enter ''Y'' to prune, anything else to exit.'
    pull go .
    end
  else go = 'Y'

if go = 'Y' then do
  call next target                                  /* call to NEXT: PROCEDURE */
  call directory ..                                 /* switch to parent */
  if pos('L', switches) > 0 then say 'Entering' directory() 
  call SysRmDir target 
  if result = 0 
    then if pos('D', switches) > 0 
            then say msg.SRD.result target
            else nop
    else say msg.SRD.result 'for' target
  say
  if pos('S', switches) = 0 then say 'Pruned branch' target
end  /* if go then do */
exit 0


next: procedure expose msg. switches                      /* hide old set of variables, enable new set */
parse arg nextdir
call directory nextdir                                    /* make the passed directory the current directory */
if pos('L', switches) > 0 then say 'Entering' directory()  

call SysFileTree '*', 'dir.', 'DO',,'-*---'               /* any subfolders stored in compound variable list */
if result > 0 then do
   say msg.SFT.result 'for directory listing.'
   exit
   end /* if result do */
do dir = 1 to dir.0                                       /* make a loop to process list of directories */
  call next dir.dir                                       /* pivot point of the recursion */
  call directory ..                                       /* step back to parent to delete child */
  if pos('L', switches) > 0 then say 'Entering' directory()
  call SysRmDir dir.dir                                   /* remove the subdirectory  */
  if result = 0 then
      if if pos('D', switches) > 0 then say msg.SRD.result dir.dir; else nop
    else do
      say msg.SRD.result 'for' dir.dir
      exit
      end
end dir                                                   /* back to top of dir loop */

call SysFileTree '*', 'file.', 'FO',,'-*---'              /* any files stored in compound variable list */
if result > 0 then do
   say msg.SFT.result 'for file listing.'
   exit
   end /* do */
do file = 1 to file.0                                     /* make a loop to process list */
  call SysFileDelete file.file                            /* if so, delete them */
  if result = 0 then 
      if pos('F', switches) > 0 then say msg.SFD.result file.file; else nop
    else do
      say msg.SFD.result 'for' file.file
      exit
      end
end file

return                                                    /* a leaf has been reached */
