/* REXX file to install the DH-Grep-PM on the desktop     */
/* if you use this script as a starting point for your   */
/* own install script and make improvements, please send */
/* me a copy ---  dwhawk@southwind.net                   */

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs                /* register system functions */
address cmd '@echo off'          /* echo is turned off */

call SysCLS

say "DH-Grep-PM installation"
say "Enter destination drive and directory"
say "for example C:\OS2\APPS"
say "to install in the curent directory just press enter"

pull dest
call setup_dir(dest) 

say " "
say "Select regular or large font version of the online help"
say "Enter R for regular font version"
say "Enter L for large font version"
pull helpFont
say "You have entered "helpFont" for the help file version to install"
Call Check_Ok  /* your check routine */


call copy_files
call MKOBJ
exit

check_ok:
  say  'Okay to continue(Y/n) ? '        
  k = SysGetKey('NOECHO') 
  if k = 'Y' | k = 'y'  then return
  say 'halting'
    exit


mkdir:  /* Procedure for creating dir */
  Parse Arg dir
  rc = SysMkDir(dir)
  If (rc = 0 | rc = 5) Then Return
  Say 'Problem creating destination directory "'dir'"'
  Exit


MKOBJ:
Settings = 'EXENAME='direct||'\dhgrep-s.exe;'
Settings = Settings||'PROGTYPE=PM;MINIMIZED=NO;'
Settings = Settings||'CCVIEW=YES;'
Settings = Settings||'STARTUPDIR='||direct';'
rc=SysCreateObject('WPProgram','DH-Grep-PM','<WP_DESKTOP>',Settings,'R');

if rc = 1 then Say "DH-Grep-PM installed on desktop"
return

setup_dir:      /* accept install path and create it if needed */
                /* the desired install path is in ARG(1) */
                /* if no path is specified current directory is used*/

Parse Arg destin  /* parameter of setup_dir */

save_dest = destin    /*  save original destin to */
                      /*  determine if copy needed */

If destin = "" Then destin = Directory()

Say "Shall I install in "destin" ?"
Call Check_Ok  /* your check routine */

Parse Var destin direct ':\' destin   /* get drive name only */
direct=direct':'

Do Until destin = ""     /* No matter how many sub dirs present */
  Parse Var destin sub '\' destin
  direct=direct'\'sub
  Call mkdir direct
End
return

copy_files:

   if helpFont = "L" then do
      'COPY dhg_lrg.hlp dhgreppm.hlp'
   end
   if helpFont = "R" then do
      'COPY dhg_reg.hlp dhgreppm.hlp'
   end

if save_dest \= ""  then do
   'COPY dhgrep-s.exe' direct
   'COPY dhgreppm.hlp' direct

   if helpFont = "L" then do
      'COPY dhg_lrg.hlp dhgreppm.hlp'
      'COPY dhgreppm.hlp' direct
   end
   if helpFont = "R" then do
      'COPY dhg_reg.hlp dhgreppm.hlp'
      'COPY dhgreppm.hlp' direct
   end

   'COPY dhgreppm.doc' direct
   'COPY edit_cmd.cmd' direct
   'COPY _order.frm' direct
   'COPY license.txt' direct

end
return
