/* */
/* 
   copyright (c) 2004 Curtis Systems Software P.C. all rights Reserved  
   
   this rexx script will fixup snapshot list files that
   were generated with OS/2 3.1 cssdir to new format required
   by versions /Sscm of 3.2 and beyond

   usage is:
   ss31_32  fileToConvert  > newfilename
*/
parse arg infile

if (strip(infile) == "") then do
   say "usage: ss31_32 fileToConvert > newFileName"
   return 0
end
infile = strip(infile)
line = 0
do while(lines(infile))
   rec = linein(infile)
   line = line +1
   say rec
   if (strip(rec) == "++*@@@BegForDiffing@@@*") then do
      found = 1
      leave
   end
end

dumpOnly = 0

do while(lines(infile))
   rec = linein(infile)
   line = line + 1
   if (dumpOnly) then do
      say rec
      iterate
   end
   else if (strip(rec) == "++*@@@EndForDiffing@@@*") then do
      dumpOnly = 1
      say rec
      iterate
   end
   if (left(rec,3) == "sl>") then do
      say rec
      iterate
   end
   if (left(rec,3) == "GT>") then do
      say rec
      iterate
   end
   if (left(rec,3) == "gt>") then do
      say rec
      iterate
   end
   inpos = pos("; <",rec)
   if ((inpos < 1) | (length(rec) < 50) | (substr(rec,28,1) <> " ")) then do
      x=lineout("stderr:","error at line:" line)
      x=lineout("stderr:",rec)
      x =lineout("stderr:", "FILE:'"infile"' is corrupt or NOT a cssdir ver 3.1 snapshot file")
      exit 1
   end
   attribFld = substr(rec,22,5)
   hex = 0
   if (pos("a",attribFld) > 0) then hex = hex + 32
   if (pos("d",attribFld) > 0) then hex = hex + 16
   if (pos("h",attribFld) > 0) then hex = hex +  2
   if (pos("r",attribFld) > 0) then hex = hex +  1
   if (pos("s",attribFld) > 0) then hex = hex +  4
   hex = right(d2x(hex),2,0)
   rec = left(rec,20)||"000000"hex":"substr(rec,21,6)||"---------"||substr(rec,27,1)substr(rec,28)
   inpos = pos("; <",rec)
   if (inpos < 1) then do
      x=lineout("stderr:","Error at line:" line)
      x=lineout("stderr:",rec)
      x =lineout("stderr:", "FILE:'"infile"' is corrupt or NOT a cssdir ver 3.1 snapshot file")
      exit 1
   end
   inpos = inpos + 2
   endpos= pos(">",rec,inpos)
   len = endpos -inpos
   if (len < 5) then do
      rec1 = left(rec,inpos)||copies(" ",5-len)||substr(rec,inpos+1)
      say rec1
   end
   else do
      say rec
   end
end

