/****************************************************************************
*
*  lateautocheck.cmd
*
*  utility to do the autockeck of your volumes in parallel
*
****************************************************************************/


IF RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs") = 0 THEN
   CALL SysLoadFuncs

opt.includefs = ""
opt.excludefs = "CDFS NTFS"
opt.lvmonly = 0

/* 1st: fetch a list of your local drives */
drvlist = SysDriveMap(, 'local')

/* 2nd: exclude boot drive */
drvlist = Exclude(drvlist, SysBootDrive())
SAY drvlist

/* 3rd: filter file systems */
drvlist = FSFilter(drvlist, opt.excludefs, opt.includefs)
SAY drvlist

/* 4th: check wich of these drives are dirty */
drvlist = DirtyCheck(drvlist)

/* 5th: check which volumes are on the same physical disk */
lvminfo = ReadLVMInfo()
/*SAY lvminfo*/
jobs = 0
diskindex = ''
DO i = 1 TO WORDS(drvlist)
   drv = WORD(drvlist, i)
   p = WORDPOS(drv, lvminfo)
   IF p \= 0 THEN
      /* disk known */
      disk = WORD(lvminfo, p+1)
    ELSE IF opt.lvmonly THEN
      ITERATE
    ELSE
      disk = 'FF'x
   p = WORDPOS(disk, diskindex)
   IF p = 0 | disk = 'FF'x THEN DO /* no disk info defaults to a new job */
      /* new job */
      jobs = jobs +1
      job.jobs = drv
      diskindex = diskindex||disk' '
      END
    ELSE
      /* disk with other jobs */
      job.p = job.p' 'drv
   END

/* 6th: execute jobs in parallel */
/*SAY diskindex*/
DO i = 1 TO jobs
   disk = WORD(diskindex, i)
   IF disk = 'FF'x THEN
      disk = '(unknown)'
   CALL Execute job.i, disk
   END

EXIT

Execute: PROCEDURE
   tmpfile = MyTmpFile('cdk?????.cmd')
   DO i = 1 TO WORDS(ARG(1))
      CALL LINEOUT tmpfile, 'chkdsk 'WORD(ARG(1), i)' /C /F'
      END
   CALL LINEOUT tmpfile, 'pause'
   CALL LINEOUT tmpfile, 'del "'tmpfile'"' /* well, kicking off the file under cmd.exe's ass seems to work */
   CALL STREAM tmpfile, 'c', 'close'
   '@start /C "checking disk 'ARG(2)'" /PGM "'tmpfile'"'
   RETURN

Exclude: PROCEDURE
   ret = ''
   DO i = 1 TO WORDS(ARG(1))
      IF WORDPOS(WORD(ARG(1), i), ARG(2)) = 0 THEN
         ret = ret||WORD(ARG(1), i)' '
      END
   RETURN ret

FSFilter: PROCEDURE
   ret = ''
   DO i = 1 TO WORDS(ARG(1))
      fs = SysFileSystemType(WORD(ARG(1), i))
      IF fs = '' THEN /* empty CD or whatever */
         ITERATE
      IF POS(fs, ARG(2)) = 0 & (ARG(3) = '' | POS(fs, ARG(3)) \= 0) THEN
         ret = ret||WORD(ARG(1), i)' '
      END
   RETURN ret

DirtyCheck: PROCEDURE
   ret = ''
   DO i = 1 TO WORDS(ARG(1))
      IF SysDriveInfo(WORD(ARG(1), i)) = '' THEN
         ret = ret||WORD(ARG(1), i)' '
      END
   RETURN ret

ReadLVMInfo: PROCEDURE
   tmpfile = MyTmpFile('lvm?????.tmp')
   IF tmpfile = '' THEN DO
      CALL LINEOUT STDERR, 'Failed to create temporary file.'
      RETURN ''
      END
   '@LVM /QUERY:VOLUMES >'tmpfile' 2>&1'
   ret = ''
   DO FOREVER
      l = LINEIN(tmpfile)
      IF STREAM(tmpfile, 's') \= 'READY' THEN
         LEAVE
      IF LEFT(l, 1) = ' ' THEN
         ITERATE
      DO FOREVER /* skip at least one line, but ignore drive lines without details */
         l2 = LINEIN(tmpfile)
         IF LEFT(l2, 1) = ' ' THEN
            LEAVE
         l = l2
         END
      drv = WORD(l, 1)
      l2 = LINEIN(tmpfile)
      disk = TRANSLATE(STRIP(SUBSTR(l2, 35), 'T'), 'FF'x, ' ') /* translate spaces to avoid confusion */
      ret = ret||drv' 'disk' '
      END
   CALL STREAM tmpfile, 'c', 'close'
   CALL SysFileDelete tmpfile
   RETURN ret

MyTmpFile: PROCEDURE
   path = VALUE('TEMP',,'OS2ENVIRONMENT')
   IF path \= '' & POS(RIGHT(path, 1), '\/') = 0 THEN
      path = path'\'
   RETURN SysTempFileName(path||ARG(1))

