/* * Last edited: Aug 19 14:51 1994 (david) */

/* V1.1 CD-ROM bug fix. Would bring up a requester when a cdrom drive
 *      did not contain a (filesystem) cd-rom.
 * Patches sent by Michael D. Godfrey
 */

#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#include <os2.h>
#include <stdio.h>

void process_drive(int drive) ;
void read_drive_info(ULONG *drivemap) ;
void display_header() ;

typedef struct _tagFSInfo1 {
    ULONG fs_ID ;
    ULONG fs_SN ;
    ULONG fs_UN ;
    ULONG fs_UA ;
    ULONG fs_BN ;
} FSInfo1 ;

typedef struct _tagFSInfo2 {
    ULONG fs_SERIAL ;
    BYTE  fs_cbVol ;
    CHAR  fs_Vol[30] ;
} FSInfo2 ;

typedef struct _tagDriveBuffer {
    FSQBUFFER2 qbuffer ;
    UCHAR  padding[100] ;
} DriveBuffer ;

void display_drive_info(DriveBuffer *pdata, FSInfo1 *pfsinfo1, FSInfo2 *pfsinfo2 ) ;

ULONG totalsize ;
ULONG totalfree ;

void
read_drive_info(ULONG *drivemap) {
    ULONG drive ;
    APIRET rc ;

    rc = DosQueryCurrentDisk(&drive, drivemap) ;
    (*drivemap) >>= 2 ;
}

void
display_header()
{
    printf("Disk             Free      Used     Total  Capacity   Cluster    File System\n");
}

main()
{
    ULONG drivemap ;
    int index ;

    totalsize = 0;
    totalfree = 0;

    DosError( 0L);			/* Prevent requester for invalid drives */
    read_drive_info(&drivemap);
    display_header() ;

    for (index = 2 ; index < 25; index ++) {
	if (drivemap & 0x01)
	    process_drive(index);
	drivemap >>= 1 ;
    }

    printf("\nTotal:       %8luk %8luk %8luk  %4u%%\n",
	   totalfree/1024, (totalsize-totalfree)/1024, totalsize/1024,
	   (totalsize-totalfree)/(totalsize/100)) ;
}

void
display_drive_info(DriveBuffer *pdata,
                   FSInfo1 *pfsinfo1,
		   FSInfo2 *pfsinfo2 )
{

    ULONG sector = (pfsinfo1->fs_BN * pfsinfo1->fs_SN) ;
    ULONG size = pfsinfo1->fs_UN * sector ;
    ULONG free = pfsinfo1->fs_UA * sector ;
    char meg ;
    ULONG limit = 99*1024*1024 ;
    ULONG fact ;
    
    
    if (pfsinfo1->fs_UA == -1)
    	free = 0 ;

#define key(x) meg = (x) > limit?'M':'k'; fact = (meg == 'M')?1024*1024:1024

    key(free);
    
    printf(pdata->qbuffer.szName);
    printf("%-11s",pfsinfo2->fs_Vol) ;
    printf("%8lu%c",free/fact,meg) ;

    key(size-free) ;
    printf(" %8lu%c",(size-free)/fact,meg);

    key(size) ;
    printf(" %8lu%c",size/fact,meg);
    printf("  %4lu%%",(size-free)/(size/100));
    printf("   %5lu bytes.",pfsinfo1->fs_BN * pfsinfo1->fs_SN) ;
    printf("     %s\n", pdata->qbuffer.szFSDName+pdata->qbuffer.cbName);

    totalsize += size ;
    totalfree += free ;
}

void process_drive(int drive)
{
    APIRET rc ;
    DriveBuffer data ;
    char szName[3] ;
    
    static FSInfo1 fsinfo1;
    FSInfo2 fsinfo2;

    ULONG  ndatabuffer ;

    sprintf(szName,"%c:",'A'+drive);

    ndatabuffer = sizeof(DriveBuffer) ;
    rc = DosQueryFSAttach(szName,0,1,&(data.qbuffer),&ndatabuffer ) ;
    if( rc != 0){ printf("%s Not Available.\n", szName); return; }
    rc = DosQueryFSInfo(drive+1,FSIL_ALLOC,&fsinfo1,sizeof(FSInfo1)) ;
    if( rc != 0) return;
    rc = DosQueryFSInfo(drive+1,FSIL_VOLSER,&fsinfo2,sizeof(FSInfo2)) ;
    if( rc != 0) return;
    display_drive_info(&data,&fsinfo1,&fsinfo2);
}
