/*
	Randomizer 4.0
	(c) 2001 by Don Eitner

	Selects random items from a user-defined set of fields.

	This code is neither supported nor under warranty.  Feel free to
	examine and modify this script for your own purposes.  See the
	included readme.txt for additional information.
*/

parse arg CmdLine
parse var CmdLine CL1 CmdLine
CL1 = translate(CL1)

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call SysCls

DataFile = ''
delim = '09'x
delim2 = ','

call ParseInput

call SysCls

Fields = linein(DataFile,,1)
Count = puns(Fields, delim)

RC = SysFileDelete("data.out")

do Num = 1 to Count
	Item.Num = linein(DataFile,,1)
	Field.Num = pun(Fields, delim, Num)

	if Pos('',Field.Num) = 1 then
		do
			Count2 = random(pun(Field.Num, delim2, 2), pun(Field.Num, delim2, 3))
			Field.Num = substr(Field.Num,2)
		end
	else
		Count2 = 1

	do Rands = 1 to Count2
		Rand = random(1, puns(Item.Num, delim))
		Data.Num = pun(Item.Num, delim, Rand)
		Item.Num = delpun(Item.Num, delim, Rand, 1)
		say pun(Field.Num, delim2, 1) ':' pun(Data.Num, delim2, 1)
		call lineout "data.out", pun(Field.Num, delim2, 1) ':' pun(Data.Num, delim2, 1)
	end

end

call lineout("data.out")
call lineout(DataFile)

exit


ParseInput:

Again:

	if (CL1 = '/Y') then
	do
		if DataInput = 'N' then
			signal GiveHelp
		DataInput = 'Y'
		parse var CmdLine CL1 CmdLine
		CL1 = translate(CL1)
		signal Again
	end

	if (CL1 = '/N') then
	do
		if DataInput = 'Y' then
			signal GiveHelp
		DataInput = 'N'
		parse var CmdLine CL1 CmdLine
		CL1 = translate(CL1)
		signal Again
	end

	if (CL1 = '/D') then
	do
		parse var CmdLine CL1 CmdLine
		DataFile = CL1
		parse var CmdLine CL1 CmdLine
		CL1 = translate(CL1)
		signal Again
	end

	if (CL1 = '/?') then
	do
		signal GiveHelp
	end

	if DataFile = '' then
		DataFile = 'RandomData.txt'

	select
		when DataInput = 'N' then
			return
		when DataInput = 'Y' then
			call DataInput(DataFile)
		otherwise
		do
			do until (datatype(Junk) = 'CHAR') & (Junk = 'Y' | Junk = 'N')
				say 'Would you like to edit the list of fields & items (Y/N)?'
				Junk = translate(SysGetKey('NOECHO'))
			end
			if (Junk = 'Y') then
			call DataInput(DataFile)
		end
	end

return


GiveHelp:

	say 'Randomizer v4.0, 2001 by Don Eitner'
	say 'Universal random item selector.'
	say ''
	say ' Usage:  Randomizer [[/Y | /N] [/D DataFile]] [/?]'
	say ''
	say '  Only one or the other of /Y or /N may be given, or neither.'
	say '  If neither is given, program will prompt for input mode.'
	say ''
	say '  /Y = sets input mode on so you can add fields and items'
	say '       to selected data file (datainput.cmd)'
	say '  /N = sets input mode off so you just get random selection'
	say '       from selected data file'
	say '  /D = allows you to choose the name of the data file to use'
	say '  /? = shows this help screen'

exit


puns: procedure

	PARSE ARG string, delim
	CALL split string, delim

RETURN substring.0


pun: procedure

	PARSE ARG string, delim, word
	CALL split string, delim

RETURN substring.word


delpun: procedure

	PARSE ARG string, delim, word, length
	CALL split string, delim
	DO x = word to (word - 1 + length)
		substring.x = ''
	END
	DO y = 1 to substring.0
		IF substring.y = '' THEN
			iterate
		IF string = '' THEN
			string = substring.y
		ELSE
			string = string||delim||substring.y
	END

RETURN string


split:

	PARSE ARG string, delim
	num = 0
	DO WHILE string <> ''
		num = num + 1
		stop = pos(delim, string)
		IF stop = 0 THEN
			stop = length(string)+1
		substring.num = substr(string, 1, stop-1)
		string = substr(string, stop+1)
	END
	substring.0 = num

	IF delim = ',' | delim = ';' | delim = ':' THEN
		DO x = 1 to substring.0
			substring.x = strip(substring.x,b,'"')
		END

RETURN

