/**************************************************************************************
** ODBCDR1
**
** Version 1
**
** This file contains a list of the files/drivers to be searched for
** If the files are found then the driver is listed as available to
** install.
**
** You can modify this file for new ODBC driver that need to be install
**
** (The install process also needs a ODBCDR2 file which contains the
** setup information for each driver listed in this file)
**
**
** NOTE:  File names must be in UPPER CASE
**
***************************************************************************************/


RxReturnByName("ODBCDrv ODBCReq")      /* RXU function for returning varible values */


ODBCDrv.0 = 39                 /* Number of entries (highest number after first dot in stem var */

ODBCDrv.1.0=2
ODBCDrv.1.1='IBDBF08.DLL'      /* dBase */
ODBCDrv.1.2='IBDBF08.HLP'
ODBCDrv.1.T="INTERSOLV 2.11 dBase"
ODBCDrv.1.S=1
ODBCDrv.1.R=4

ODBCDrv.2.0=5
ODBCDrv.2.1='IBORA08.DLL'      /* Oracle 6 */
ODBCDrv.2.2='IBORA08.HLP'
ODBCDrv.2.3='ORA632.DLL'       /* located in LotusW4/COMPNENT directory */
ODBCDrv.2.4='OSNT32.DLL'
ODBCDrv.2.5='LITB32.DLL'
ODBCDrv.2.T="INTERSOLV 2.11 Oracle"
ODBCDrv.2.S=2
ODBCDrv.2.R=4

ODBCDrv.3.0=4
ODBCDrv.3.1='IBOR708.DLL'      /* Oracle 7 */
ODBCDrv.3.2='IBOR708.HLP'
ODBCDrv.3.3='ORA7O32.DLL'
ODBCDrv.3.4='COREO32.DLL'
ODBCDrv.3.T="INTERSOLV 2.11 Oracle 7"
ODBCDrv.3.S=3
ODBCDrv.3.R=4

ODBCDrv.4.0=2
ODBCDrv.4.1='IBSS08.DLL'       /* MS SQL Server */
ODBCDrv.4.2='IBSS08.HLP'
ODBCDrv.4.T="INTERSOLV 2.11 SQLServer"
ODBCDrv.4.S=4
ODBCDrv.4.R=4

ODBCDrv.5.0=2
ODBCDrv.5.1='IBSYB08.DLL'      /* Sybase */
ODBCDrv.5.2='IBSYB08.HLP'
ODBCDrv.5.T ="INTERSOLV 2.11 Sybase System 10"
ODBCDrv.5.S=5
ODBCDrv.5.R=4

ODBCDrv.6.0=2
ODBCDrv.6.1='IBTXT08.DLL'      /* Text */
ODBCDrv.6.2='IBTXT08.HLP'
ODBCDrv.6.T ="INTERSOLV 2.11 Text"
ODBCDrv.6.S=6
ODBCDrv.6.R=4

ODBCDrv.7.0=1
ODBCDrv.7.1='WOD502.DLL'       /* SQL Anywhere  */
ODBCDrv.7.T ="Sybase SQL Anywhere 5.0"
ODBCDrv.7.S=7


ODBCDrv.8.0=0
ODBCDrv.8.1='----------'       /* Dirk Ohme Oracle not ready yet  */

ODBCDrv.9.0=0
ODBCDrv.9.1='----------'       /* miniSQL - not ready yet          */

ODBCDrv.10.0=0
ODBCDrv.10.1='----------'      /* mySQL  - not ready yet           */


ODBCDrv.11.0=2
ODBCDrv.11.1='PSQLODBC.DLL'    /* postgreSql 7.01 */
ODBCDrv.11.2='PSQLODBS.DLL'    /* postgreSql */
ODBCDrv.11.T ="Postgres SQL 7.01"
ODBCDrv.11.S=11

ODBCDrv.12.0=2
ODBCDrv.12.1 ='L2BTR12.DLL'    /* Btrieve */
ODBCDrv.12.2 ='L2BTR12.HLP'
ODBCDrv.12.T ="INTERSOLV 3.01 Btrieve"
ODBCDrv.12.S=12
ODBCDrv.12.R=5

ODBCDrv.13.0=2
ODBCDrv.13.1 ='L2DB212.DLL'    /* DB2 */
ODBCDrv.13.2 ='L2DB212.HLP'
ODBCDrv.13.T ="INTERSOLV 3.01 DB2"
ODBCDrv.13.S=13

ODBCDrv.14.0=2
ODBCDrv.14.1 ='L2DBF12.DLL'    /* dBase */
ODBCDrv.14.2 ='L2DBF12.HLP'
ODBCDrv.14.T="INTERSOLV 3.01 dBase"
ODBCDrv.14.S=14

ODBCDrv.15.0=2
ODBCDrv.15.1 ='L2INF512.DLL'   /* Informix */
ODBCDrv.15.2 ='L2INF512.HLP'
ODBCDrv.15.T="INTERSOLV 3.01 Informix 5"
ODBCDrv.15.S=15

ODBCDrv.16.0=2
ODBCDrv.16.1 ='L2OR712.DLL'    /* Oracle 7 */
ODBCDrv.16.2 ='L2OR712.HLP'
ODBCDrv.16.T="INTERSOLV 3.01 Oracle 7"
ODBCDrv.16.S=16

ODBCDrv.17.0=2
ODBCDrv.17.1 ='L2SYB12.DLL'    /* Sybase */
ODBCDrv.17.2 ='L2SYB12.HLP'
ODBCDrv.17.T ="INTERSOLV 3.01 Sybase System 10"
ODBCDrv.17.S=17

ODBCDrv.18.0=2
ODBCDrv.18.1 ='L2TXT12.DLL'    /* Text */
ODBCDrv.18.2 ='L2TXT12.HLP'
ODBCDrv.18.T ="INTERSOLV 3.01 Text"
ODBCDrv.18.S=18

ODBCDrv.19.0=2
ODBCDrv.19.1='WOD402.DLL'        /* Watcom SQL 4 */
ODBCDrv.19.2='WSQLODBC.HLP'      /* Watcom SQL 4 */
ODBCDrv.19.T ="Watcom SQL 4"
ODBCDrv.19.S=19


/*  ----- ODBCDEMO files ----- */

ODBCDrv.20.0=2
ODBCDrv.20.A='IVINF5.ZIP'         /* Informix 5   */
ODBCDrv.20.1='IVINF508.DLL'      /* Informix 5   */
ODBCDrv.20.2='IVINF508.HLP'
ODBCDrv.20.T="INTERSOLV 2.11 Informix5"
ODBCDrv.20.S=20
ODBCDrv.20.R="1 2 3"

ODBCDrv.21.0=2
ODBCDrv.21.A='IVMDI.ZIP'        /* MicroDecisionware */
ODBCDrv.21.1='IVMDI08.DLL'      /* MicroDecisionware */
ODBCDrv.21.2='IVMDI08.HLP'
ODBCDrv.21.T="INTERSOLV 2.11 MDI-DB2 via MicroDecisionware"
ODBCDrv.21.S=21
ODBCDrv.21.R="1 2 3"

ODBCDrv.22.0=2
ODBCDrv.22.A='IVGUP.ZIP'        /* Gupta */
ODBCDrv.22.1='IVGUP08.DLL'      /* Gupta */
ODBCDrv.22.2='IVGUP08.HLP'
ODBCDrv.22.T ="INTERSOLV 2.11 Gupta SQLBase"
ODBCDrv.22.S=24
ODBCDrv.22.R="1 2 3"

ODBCDrv.23.0=2
ODBCDrv.23.A='IVING4.ZIP'        /* Ingress */
ODBCDrv.23.1='IVNG408.DLL'      /* Ingress */
ODBCDrv.23.2='IVNG408.HLP'
ODBCDrv.23.T="INTERSOLV 2.11 INGRES 6.4/04"
ODBCDrv.23.S=22
ODBCDrv.23.R="1 2 3"

ODBCDrv.24.0=5
ODBCDrv.24.A='IVORA.ZIP'        /* Oracle A (ORA) */
ODBCDrv.24.1='IVORA08.DLL'      /* Oracle A (ORA) */
ODBCDrv.24.2='IVORA08.HLP'
ODBCDrv.24.3='ORA632.DLL'
ODBCDrv.24.4='OSTN32.DLL'
ODBCDrv.24.5='LITB32.DLL'
ODBCDrv.24.T="INTERSOLV 2.11 Oracle"
ODBCDrv.24.S=2
ODBCDrv.24.R="1 2 3"

ODBCDrv.25.0=2
ODBCDrv.25.A='IVDBF.ZIP'        /* dbase */
ODBCDrv.25.1='IVDBF08.DLL'      /* dbase */
ODBCDrv.25.2='IVDBF08.HLP'
ODBCDrv.25.T="INTERSOLV 2.11 dBase"
ODBCDrv.25.S=1
ODBCDrv.25.R="1 2 3"

ODBCDrv.26.0=4
ODBCDrv.26.A='IVOR7.ZIP'        /* Oracle 7 */
ODBCDrv.26.1='IVOR708.DLL'      /* Oracle 7 */
ODBCDrv.26.2='IVOR708.HLP'
ODBCDrv.26.3='ORA7O32.DLL'
ODBCDrv.26.4='COREO32.DLL'
ODBCDrv.26.T="INTERSOLV 2.11 Oracle 7"
ODBCDrv.26.S=3
ODBCDrv.26.R="1 2 3"

ODBCDrv.27.0=2
ODBCDrv.27.A ='IVTXT.ZIP'      /* Text */
ODBCDrv.27.1 ='IVTXT08.DLL'    /* Text */
ODBCDrv.27.2 ='IVTXT08.HLP'
ODBCDrv.27.T ="INTERSOLV 2.11 Text"
ODBCDrv.27.S=3
ODBCDrv.27.R="1 2 3"

ODBCDrv.28.0=8
ODBCDrv.28.A ='IVDB2.ZIP'      /* DB2  */
ODBCDrv.28.1 ='IVDB208.DLL'    /* DB2  */
ODBCDrv.28.2 ='IVDB208.HLP'
ODBCDrv.28.3 ='QECSV1.BND'
ODBCDrv.28.4 ='QECWHV11.BND'
ODBCDrv.28.5 ='QERRV1.BND'
ODBCDrv.28.6 ='QERRWHV1.BND'
ODBCDrv.28.7 ='QEURV1.BND'
ODBCDrv.28.8 ='QEURWHV1.BND'
ODBCDrv.28.T ="INTERSOLV 2.11 DB2"
ODBCDrv.28.S=23
ODBCDrv.28.R="1 2 3"

ODBCDrv.29.0=2
ODBCDrv.29.A ='IVSYB.ZIP'      /* Text */
ODBCDrv.29.1 ='IVSYB08.DLL'    /* Text */
ODBCDrv.29.2 ='IVSYB08.HLP'
ODBCDrv.29.T ="INTERSOLV 2.11 Sybase System 10"
ODBCDrv.29.S=5
ODBCDrv.29.R="1 2 3"

ODBCDrv.30.0=2
ODBCDrv.30.A='IVSS.ZIP'        /* MS SQL Server */
ODBCDrv.30.1='IVSS08.DLL'      /* MS SQL Server */
ODBCDrv.30.2='IVSS08.HLP'
ODBCDrv.30.T="INTERSOLV 2.11 SQLServer"
ODBCDrv.30.S=4
ODBCDrv.30.R="1 2 3"


ODBCDrv.31.0=2
ODBCDrv.31.1='DB2CLI.DLL'      /* DB2 ODBC Driver */
ODBCDrv.31.2='DB2ODBC.DLL'     /* postgreSql */
ODBCDrv.31.T ="IBM DB2 ODBC Driver"
ODBCDrv.31.S=27


ODBCDrv.32.0=2
ODBCDrv.32.1='PSQLODBC.DL_'    /* postgreSql 7.01 */
ODBCDrv.32.2='CPPOM30.DL_'     /* postgreSql */
ODBCDrv.32.T ="Insight Postgres SQL 7.1"
ODBCDrv.32.S=26


ODBCDrv.33.0=2
ODBCDrv.33.1 ='IBBTR12.DL_'    /* Btrieve */
ODBCDrv.33.2 ='IBBTR12.HL_'
ODBCDrv.33.T ="INTERSOLV 3.01 Btrieve"
ODBCDrv.33.S=12
ODBCDrv.33.R=6

ODBCDrv.34.0=2
ODBCDrv.34.1 ='IBDB212.DL_'    /* DB2 */
ODBCDrv.34.2 ='IBDB212.HL_'
ODBCDrv.34.T ="INTERSOLV 3.01 DB2"
ODBCDrv.34.S=13
ODBCDrv.34.R=6

ODBCDrv.35.0=2
ODBCDrv.35.1 ='IBDBF12.DL_'    /* dBase */
ODBCDrv.35.2 ='L2DBF12.HL_'
ODBCDrv.35.T="INTERSOLV 3.01 dBase"
ODBCDrv.35.S=14
ODBCDrv.35.R=6

ODBCDrv.36.0=2
ODBCDrv.36.1 ='IBOR712.DL_'    /* Oracle 7 */
ODBCDrv.36.2 ='IBOR712.HL_'
ODBCDrv.36.T="INTERSOLV 3.01 Oracle 7"
ODBCDrv.36.S=16
ODBCDrv.36.R=6

ODBCDrv.37.0=2
ODBCDrv.37.1 ='IBSYB12.DL_'    /* Sybase */
ODBCDrv.37.2 ='IBSYB12.HL_'
ODBCDrv.37.T ="INTERSOLV 3.01 Sybase System 10"
ODBCDrv.37.S=17
ODBCDrv.37.R=6

ODBCDrv.38.0=2
ODBCDrv.38.1 ='IBTXT12.DL_'    /* Text */
ODBCDrv.38.2 ='IBTXT12.HL_'
ODBCDrv.38.T ="INTERSOLV 3.01 Text"
ODBCDrv.38.S=18
ODBCDrv.38.R=6

ODBCDrv.39.0=2
ODBCDrv.39.1 ='IBINF512.DL_'   /* Informix */
ODBCDrv.39.2 ='IBINF512.HL_'
ODBCDrv.39.T="INTERSOLV 3.01 Informix 5"
ODBCDrv.39.S=15
ODBCDrv.39.R=6

/* --- Required Files    This allows files that are required */
/*     by multiple drivers to be specified in one spot */


/*  ODBCDEMO.ZIP  required files */
ODBCReq.1.0=1
ODBCReq.1.A="IVTRN.ZIP"   /* Alternative zipped file */
ODBCReq.1.1="IVTRN08.DLL" /* character translate (OEM-Ansi)*/

ODBCReq.2.0=2
ODBCReq.2.1="IVODBC.LIC"  /* license file */
ODBCReq.2.2="ISLVINST.DAT" /*  ??   */

ODBCReq.3.0=6
ODBCReq.3.A="IVBAS.ZIP"   /* Alternative zipped file */
ODBCReq.3.1="IVBAS08.DLL"
ODBCReq.3.2="IVFLT08.DLL"
ODBCReq.3.3="IVUTL08.DLL"
ODBCReq.3.4="IVINFO.EXE"
ODBCReq.3.5="IOM.DLL"
ODBCReq.3.6="IPPOM30.DLL"

/*  ----- DAX11   required files */
ODBCReq.4.0=8
ODBCReq.4.1="IBBAS08.DLL"
ODBCReq.4.2="IBFLT08.DLL"
ODBCReq.4.3="IBUTL08.DLL"
ODBCReq.4.4="IVINFO.EXE"
ODBCReq.4.5="IOM.DLL"
ODBCReq.4.6="IPPOM30.DLL"
ODBCReq.4.7="IVIB.LIC"
ODBCReq.4.8="IVTRN08.DLL" /* character translate (OEM-Ansi)*/


/* ---- Lotus SmartSuite Distribution ---- */
ODBCReq.5.0 = 5
ODBCReq.5.1 ='coreo32.dll'
ODBCReq.5.2 ='iom.dll'
ODBCReq.5.3 ='ivl2.lic'
ODBCReq.5.4 ='LTPLR10.DLL'
ODBCReq.5.5 ='LTPLR30.DLL'


ODBCReq.6.0=5
ODBCReq.6.1="IBFLT12.DL_"   /* Alternative zipped file */
ODBCReq.6.2="IBUTL12.DL_" /* character translate (OEM-Ansi)*/
ODBCReq.6.3="IBBAS12.DL_" /* character translate (OEM-Ansi)*/
ODBCReq.6.4="IOM.DL_"     /* character translate (OEM-Ansi)*/
ODBCReq.6.5="IVIB.LI_"     /* character translate (OEM-Ansi)*/
return ODBCDrv.0