/* Install.cmd - Install / UnInstall for Text Converter */

PARSE ARG action
IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL SysCls
action = TRANSLATE(LEFT(action,1))
SELECT
    WHEN action = 'I' THEN CALL InstallMe
    WHEN action = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL WhatAction
END
Exit /* End of Install.cmd */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY 'Please enter installation parameter (I=Install, U=UnInstall, other=Enter):'
PARSE PULL action
SELECT
    WHEN TRANSLATE(LEFT(action,1)) = 'I' THEN CALL InstallMe
    WHEN TRANSLATE(LEFT(action,1)) = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL NoAction 'Installation failed.'
END
RETURN /* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

CALL SysCls
PARSE ARG noinstmsg
SAY noinstmsg
SAY 'Press Enter to exit ...'
PULL answer
CALL SysCls
Exit /* End of NoAction */

/* InstallMe - install Text Converter */

InstallMe:  PROCEDURE

prgname = 'Text Converter 0.9.2'
cfgfiles = 'TextConv.exe TextConv.dll CHARSETS.INI ENGLISH.INI English.inf'
IF RIGHT(Directory(),2) = ':\' THEN DO
    SAY 'Problem! '||prgname||' can not be installed in root directory.'
    SAY 'Create directory for '||prgname||', copy files: '||cfgfiles||' there and start this procedure again.'
    SAY 'Press Enter to exit ...'
    PULL answer
    Exit
END
oldver = SysIni('USER','ToolsByGoran','TextConverterWorkDir')
IF oldver <> 'ERROR:' THEN DO
    SAY 'Previous version of Text Converter is installed in directory:'
    SAY oldver
    SAY 'Uninstall previous version of Text Converter, then install '||prgname
    SAY 'Press Enter to exit ...'
    PULL answer
    Exit
END

CALL SysCls
SAY 'Welcome to '||prgname||' Installation procedure!'
SAY ' '
SAY 'Your files are in directory: '||Directory()
SAY 'Program object for '||prgname||' will be created on your Desktop,'
SAY 'Press "Y" (and Enter) to start Installation, any other key to exit...'

PARSE PULL answer

IF TRANSLATE(LEFT(answer,1)) <> "Y" THEN DO
    CALL NoAction 'Installation aborted'
END

SAY ' '
SAY 'Checking files:'
DO i = 1 TO WORDS(cfgfiles)
    CALL SysFiletree Directory()||'\'||WORD(cfgfiles,i), 'chkfile', 'FO'
    SELECT
	WHEN chkfile.0 = 1 THEN SAY '- '||LEFT(WORD(cfgfiles,i),12)||' - OK'
	OTHERWISE CALL NoAction LEFT(WORD(cfgfiles,i),12)||' - Missing file. Installation failed!'
    END
END

SAY 'Writing values to TEXTCONV.INI'
CALL SysIni 'TEXTCONV.INI', 'Language', 'ENGLISH', 'English.inf'
CALL SysIni 'TEXTCONV.INI', 'Language', 'CROATIAN', 'English.inf'
CALL SysIni 'TEXTCONV.INI', 'Language', 'DUTCH', 'English.inf'
CALL SysIni 'TEXTCONV.INI', 'Language', 'FRENCH', 'French.inf'
CALL SysIni 'TEXTCONV.INI', 'Language', 'GERMAN', 'English.inf'
CALL SysIni 'TEXTCONV.INI', 'Language', 'POLISH', 'Polish.inf'
CALL SysIni 'TEXTCONV.INI', 'Language', 'RUSSIAN', 'English.inf'
CALL SysIni 'TEXTCONV.INI', 'Language', 'SLOVENIA', 'English.inf'
CALL SysIni 'TEXTCONV.INI', 'Language', 'SWEDISH', 'Swedish.inf'
CALL SysIni 'TEXTCONV.INI', 'Settings', 'CurrLang', 'ENGLISH'

ProgTitle = prgname
EXE = 'TextConv.exe'
ICO = 'TextConv.ico'
InstallDir = Directory()
WorkDir = Directory()
Setup = 'OBJECTID=<TEXT_CONVERTER_PROGRAM>;EXENAME='InstallDir'\'EXE';ICONFILE='InstallDir'\'ICO';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WP_DESKTOP>',Setup,Action)
SELECT
    WHEN dummy = 1 THEN SAY 'Creating '||prgname||' Program object - OK'
    OTHERWISE SAY 'Creating '||prgname||' Program object - Error!'
END

SAY ' '
SAY 'Installation finished! Press Enter to exit ...'
PULL answer
CALL SysCls
RETURN /* End of InstallMe */

/* UnInstallMe - uninstall Text Converter */

UnInstallMe: PROCEDURE

prgname = 'Text Converter 0.9.2'
CALL SysCls
SAY 'This is '||prgname||' UnInstallation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will destroy '||prgname||' Program object'
SAY 'Press "Y" (and Enter) to start UnInstall, any other key to exit...'
PULL answer
IF answer <> "Y" THEN DO
    CALL NoAction 'UnInstall terminated.'
END
SAY ' '
SAY 'Destroying Program object'
CALL SysDestroyObject '<TEXT_CONVERTER_PROGRAM>'
SAY ' '
SAY 'UnInstallation complete. You can delete files in directory '||Directory()
SAY 'To install '||prgname||' again, start Install I. Press Enter to exit...'
PULL answer
RETURN /* End of UnInstallMe */
