/* 
   drvJAVA.cpp : This file is part of pstoedit
   backend to generate a Java(TM) applet

   Copyright (C) 1993,1994,1995,1996 Wolfgang Glunz, Wolfgang.Glunz@zfe.siemens.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "drvjava.h"

drvJAVA::drvJAVA(const char * driveroptions_p,ostream & theoutStream,ostream & theerrStream): // Constructor
	drvbase(driveroptions_p,theoutStream,theerrStream,
		0, // if backend supports subpathes, else 0
		   // if subpathes are supported, the backend must deal with
		   // sequences of the following form
		   // moveto (start of subpath)
		   // lineto (a line segment)
		   // lineto 
		   // moveto (start of a new subpath)
		   // lineto (a line segment)
		   // lineto 
		   //
		   // If this argument is set to 0 each subpath is drawn 
		   // individually which might not necessarily represent
		   // the original drawing.

		0,  // if backend supports curves, else 0
		0  // if backend supports elements with fill and edges
	)
{
// driver specific initializations
// and writing of header to output file
	outf << "import java.applet.*;" << endl;
	outf << "import java.awt.*;" << endl;
	outf << "public class PsDrawing extends Applet" << endl;
	outf << "{" << endl;
	outf << "    public void init()" << endl;
	outf << "    {" << endl;
	outf << "        setBackground( Color.white );" << endl;
	outf << "    }" << endl;
	outf << "    public void paint( Graphics g )" << endl;
	outf << "    {" << endl;
}

drvJAVA::~drvJAVA() {
// driver specific deallocations
// and writing of trailer to output file
	outf << "    }" << endl;
	outf << "}" << endl;
}

void drvJAVA::print_coords()
{
    outf << "\tPolygon p = new Polygon();" << endl;;
    for (unsigned int n = 0; n < numberOfElementsInPath(); n++) {
	const basedrawingelement & elem = pathElement(n);
	switch (elem.getType()) {
		case moveto: {
			const Point & p = elem.getPoint(0);
			outf << "\tp.addPoint(";
        		outf  << (int) (p.x_ + x_offset) << "," 
	     			<<     (int) (currentDeviceHeight -     p.y_ + y_offset) << ");" ;
			}
			break;
		case lineto: {
			const Point & p = elem.getPoint(0);
			outf << "\tp.addPoint(";
        		outf  << (int) (p.x_ + x_offset) << "," 
	     			<<     (int) (currentDeviceHeight -     p.y_ + y_offset) << ");" ;
			}
			break;
		case closepath: 
			// outf << "\t\tclosepath ";
			break;
		case curveto:{
			errf << "\t\tFatal: unexpected case in drvpdf " << endl;
			abort();
			}
			break;
		default:
			errf << "\t\tFatal: unexpected case in drvpdf " << endl;
			abort();
			break;
	}
	outf << endl;
    }
}


void drvJAVA::open_page()
{
	outf << "//Opening page: " << currentPageNumber << endl;
}

void drvJAVA::close_page()
{
	outf << "//Closing page: " << (currentPageNumber) << endl;
}

void drvJAVA::show_text(const TextInfo & textinfo)
{
	outf << "\t{" << endl;
	outf << "\tColor c = new Color(" << currentR()<< "F," << currentG() << "F," << currentB()<< "F);" << endl;
	outf << "\tg.setColor(c);" << endl;
	outf << "\tg.setFont(new Font(new String(\"" <<	textinfo.currentFontName.value() << "\"),Font.PLAIN,"<< (int) (textinfo.currentFontSize +0.5) <<  ")); " << endl;
	outf << "\tg.drawString(new String(\"" ;
	// << textinfo.thetext 
	for (const char * p = textinfo.thetext; (*p) != 0; p++ ){
		if ((*p) == '"') {
			outf << '\\' << *p;
		} else if ((*p) == '\\') {
			outf << '\\' << *p;
		} else if ((*p) == (char) 13 ) { // ^M
			outf << ' ';
		} else {
			outf << *p;
		}
	}
	outf << "\")," << (int) (textinfo.x + x_offset) << "," << (int) (currentDeviceHeight - textinfo.y + y_offset) << ");" << endl;
	outf << "\t}" << endl;
}

void drvJAVA::show_path()
{
	outf << "\t{" << endl;
	outf << "\t// Path # " << pathnumber << endl;;
	outf << "\tColor c = new Color(" << currentR()<< "F," << currentG() << "F," << currentB()<< "F);" << endl;
	outf << "\tg.setColor(c);" << endl;

// if fill then use a polygon
// else use line-segments.
    	switch (currentShowType() ) {
    	case drvbase::stroke : {
		for(unsigned int t=1;t<numberOfElementsInPath();t++) {
			const Point & p = pathElement(t-1).getPoint(0);
			const Point & q = pathElement(t).getPoint(0);
			outf << "\tg.drawLine(" ;
       	 		outf  << (int) (p.x_ + x_offset) << "," 
		     	      << (int) (currentDeviceHeight -     p.y_ + y_offset) << "," ;
       	 		outf  << (int) (q.x_ + x_offset) << "," 
	     		      << (int) (currentDeviceHeight -  q.y_ + y_offset) << ");\n" ;
		}
		}
      		break;
    	case drvbase::fill :
    	case drvbase::eofill :
		print_coords();
    		if (!isPolygon())  {
			// make closed polygon anyway
			const basedrawingelement & elem = pathElement(0);
			const Point & p = elem.getPoint(0);
			outf << "\tp.addPoint(";
       	 		outf  << (int) (p.x_ + x_offset) << "," 
		     	      << (int) (currentDeviceHeight -     p.y_ + y_offset) << ");\n " ;
		}
		outf << "\tg.fillPolygon(p);" << endl;
      		break;
    	default: 
	// cannot happen
      		outf << "unexpected ShowType " << (int) currentShowType() ;
      		break;
    	}
	outf << "\t}" << endl;
	// outf << "\tcurrentLineWidth: " <<  currentLineWidth() << endl;
};

void drvJAVA::show_rectangle(const float llx, const float lly, const float urx, const float ury)
{
//	outf << "Rectangle ( " << llx << "," << lly << ") (" << urx << "," << ury << ")" << endl;
// just do show_path for a first guess
  	unused(&llx); unused(&lly); unused(&urx); unused(&ury);
	show_path();
}
