#include <stdio.h>
#include <stdlib.h>

#include "global.h"
#include "matrixio.h"
#include "makematrix.h"

long double ** readmatrix( char *filename, long dim, int mode, long skip )
{
    FILE        *fid;
    long double *data, **matrix, dummy;
    long        z, s, max;
    float       f;

    if ( (fid = fopen( filename, "rb" ) ) == NULL )
    {
        fprintf( stderr, "can't open input file %s\n", filename );
        exit( 1);
    }

    matrix = makematrix( dim );

    fseek( fid, skip, SEEK_SET );

    switch ( mode ) {
    case HEPRO:
        fscanf( fid, "%Le", &dummy );
        for (;;)
        {
            fscanf( fid, "%Le", &dummy );
            fscanf( fid, "%Le", &dummy );
            max = dummy;
            if ( max > dim )
            {
                fprintf( stderr, "dimension error: read columns: %li  entered dimension: %li\n", max, dim  );
            }
            fscanf( fid, "%Le", &dummy );
            fscanf( fid, "%Le", &dummy );

            for ( s=0; s<max; s++ )
            {
                if ( s>=dim )
                {
                    for ( ;s<max; s++ )
                        if ( fscanf( fid, "%Le", &dummy ) == 0)
                        {
                            fprintf( stderr, "structure error in row %Li\n", z );
                            exit( 1 );
                        }
                    fprintf( stdout, "%Li elements dismissed\n", max-dim );
                }
                else
                    if ( fscanf( fid, "%Le", &matrix[z][s] ) == 0)
                    {
                        z=dim;
                        fprintf( stderr, "line %li not read\n", z );
                        break;
                    }
            }
            z++;
            if ( z >= dim )
                break;
        }
        break;

    case BINTRI8:
        for ( z=0; z<dim; z++ )
            for ( s=z; s<dim; s++ )
            {
                if ( fread( &(matrix[z][s]), sizeof( long double ), 1, fid ) == 0)
                {
                    fprintf( stderr, "structure error in row %li\n", z );
                    exit(1);
                }
            }
        break;

    case BINSQUARE4:
        for ( z=0; z < dim; z++ )
            for ( s=0; s<dim; s++ )
            {
                if ( fread( &f, sizeof( float ), 1, fid ) == 0 )
                {
                    fprintf( stderr, "structure error in row %li\n", z );
                    exit(1);
                }
                matrix[z][s] = ( long double)f;
            }
        break;

    case MATHMATRIX:
        for ( z=0; z < dim; z++ )
        {
            for ( s=0; s<dim; s++ )
            {
                if ( feof( fid ) )
                {
                    fprintf( stderr, "structure error in row %li\n", z+1 );
                    exit(1);
                }
                if ( fscanf( fid, "%Le", &matrix[z][s] ) == 0 )
                {
                    fseek( fid, 1, SEEK_CUR );
                    --s;
                }
            }
            if ( feof( fid ) )
                break;
        }
        break;
    }

    fclose( fid );

    return matrix;
}


void writematrix( long double** matrix, long dim, char *filename, int flip )
{
    FILE    *fid;
    long    z, s;

    if ( (fid = fopen( filename, "wb" ) ) == NULL )
    {
        fprintf( stderr, "can't open output file %s\n", filename );
        exit( 1 );
    }

    for ( z=0; z<dim; z++ )
    {
        for ( s=0; s<dim; s++ )
            if ( flip )
                fprintf( fid, "%.18Le ", matrix[s][z] );
            else
                fprintf( fid, "%.18Le ", matrix[z][s] );
        fprintf( fid, "\n" );
    }
    fprintf( fid,"\n" );

    fclose( fid );
}

