@echo off
:: ORexxG - Set up session to run Dmitry's OBJREXX 6.05 (REXX LA v5) - Glassman

:: Copyright (c) 2021-2022 Steven Levine and Associates, Inc.
:: All rights reserved.

:: This program is free software licensed under the terms of the GNU
:: General Public License.  The GPL Software License can be found in
:: gnugpl2.txt or at http://www.gnu.org/licenses/licenses.html#GPL

:: 2021-09-16 SHL Baseline - clone from elsewhere
:: 2021-10-06 SHL Escape prompt command line better
:: 2021-11-06 SHL Try to avoid intermittent rexxtry errors
:: 2021-12-22 SHL Allow switch from ClassicRexx
:: 2022-02-17 SHL Sync with templates
:: 2022-02-17 SHL Support -v

if "%@eval[0]" == "0" goto is4xxx
  echo Must run with 4OS2
  pause
  goto eof
:is4xxx

loadbtm on
on errormsg pause
setlocal

:Main

  for %X in ( V ) set %X=
  do while %# != 0
    set A=%1
    set X=%@substr[%A,0,1]
    iff "%X" eq "/" .or. "%X" eq "-" then
      :: Got switch
      set X=%@lower[%@substr[%A,1,260]]
      if "%X" == "h" .or. "%X" == "?" goto UsageHelp
      iff "%X" == "v" then
        set V=v
      elseiff "%X" == "-" then
        :: End of local args - pass rest on
        shift /1
        leave
      else
        echo Switch %A unexpected
        goto UsageError
      endiff
      shift /1
      iterate
    endiff
    :: Got argument
    if "%A" == "?" ( gosub ShowSettings %+ quit )
    :: Use remaining args for command line
    leave
  enddo

  if "%@search[rexxtry.cmd]" == "" ( echo Cannot access rexxtry.cmd %+ beep %+ cancel )

  set X=%@execstr[rexxtry parse version v1 v2 . ; say v1 v2]
  if %@index["%X",OBJ] eq 1 .and. "%X" gt "OBJREXX 6.00" ( echo Already running %X %+ beep %+ cancel )

  set REXXDIR=%TMP\OREXXG
  if not isdir %REXXDIR ( echo Cannot access %REXXDIR %+ beep %+ cancel )

  iff defined V then
    echo.
    echo Preparing Object REXX environment
  endiff

  set OBLP=%BEGINLIBPATH
  set OLPS=%LIBPATHSTRICT

  set BEGINLIBPATH=%REXXDIR;%BEGINLIBPATH
  set LIBPATHSTRICT=T

  set PATH=%REXXDIR;%PATH
  set DPATH=%REXXDIR;%DPATH
  set HELP=%REXXDIR;%HELP
  set BOOKSHELF=%REXXDIR;%BOOKSHELF

  set REXXDIR=

  if defined V history /a rexxtry parse version v ; say 'Running' v

  iff %# != 0 then
    :: If have args assume script to invoke
    %COMSPEC /c %$
  else
    iff defined V then
      echo.
      echo %X selected for this session
      echo Type exit to restore
      echo.
    endiff
    :: FIXME try to avoid intermittent execstr errors - maybe DLLs not quite loaded
    :: FIXME to always activate - may not be possible - current workaround is new shell session
    %COMSPEC `call rexxtry a=1 %%+ prompt {%%_SHELL} %%@execstr[rexxtry parse version v1 v2 . ; say v1 v2] $p$_$g`
  endiff

  set LIBPATHSTRICT=%OLPS
  set BEGINLIBPATH=%OBLP

  quit

:: end Main

::=== ShowSettings () Show current settings ===

:ShowSettings
  for %X in ( UNIXROOT BEGINLIBPATH LIBPATHSTRICT ) echo %X is %[%X]
  :: if isalias g echo.
  setdos /x-
  :: for %X in ( g ) if isalias %X ( echos alias %X` ` %+ alias %X )
  setdos /x+
  call rexxtry parse version v ; say 'Running' v
  return
  :: end ShowSettings

::=== UsageError() Report usage error ===

:UsageError
  beep
  echo Usage: %@lower[%0] `[-h] [-v] [-?] [args...]`
  cancel

::=== UsageHelp() Display usage help ===

:UsageHelp
  echo.
  echo Set up session to run Dmitry's Object REXX 6.05 (REXX LA v5) - Glassman
  echo Requires rexxtry.cmd
  echo Expects to find required Object REXX files in %TMP\CREXX
  echo.
  echo Usage: %@lower[%0] `[-h] [-v] [-?] [args...]`
  echo.
  echo `  -h -?   Display this message`
  echo `  -v      Be more verbose`
  echo.
  echo `  arg...  Args passed to Object5 REXX session`
  cancel

:eof
