/* FIX CONFIG.SYS for new installs & copy dirs from CD - DGD 02-03-2008 */
/* released into public domain for use on OS/2 - ECS systems only */

call rxfuncadd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call sysloadfuncs

zky= x2c('00'); xky= ''; /* prefixes for some extended keys */
k_esc= x2c('1b');  k_enter= x2c('0d');

dr= directory() /* orient toward current drive; handy for testing on Z:\ */
if dr = 'Z:\' then 'copy config.org config.sys' /* FOR TESTING ON RAMDRIVE */
if dr <> 'Z:\' then do 
  say 'HEY! If this is FOR REAL on boot drive, comment out this safety check!'
  exit
end /* FOR TESTING! */

i_cs= dr||'CONFIG.SYS'
b_cs= dr||'CONFIG.FCS'
o_cs= dr||'CONFIG.SYS'

/* read original into stem var lin. as lines of text */
if stream(i_cs, 'c', 'query exists') <> '' then do
  say 'Reading...'
  ndx= 1
  do until lines(i_cs) = 0
    lin.ndx= linein(i_cs)
    ndx= ndx + 1
  end
  ok= stream(i_cs, 'c', 'close')
  lin.0= ndx - 1
end /* file exists */
else do
  say 'Cannot find 'i_cs'!'
  exit
end

/* CAUTION: simplistic, possibility of saving modified BAD version! */
/* make a backup - this way tests my save routine... */
rc= stream(b_cs, 'c', 'open write')
rc= stream(b_cs, 'c', 'seek =0')
do ndx= 1 to lin.0
  call charout b_cs, lin.ndx||d2c(13)||d2c(10)
end
rc= stream(b_cs, 'c', 'close')

do ndx= 1 to lin.0  /* clean up AFTER copying */
  lin.ndx= strip(lin.ndx, 'B', ' ') /* ensures pos() finds in column 1 */
end  /* doubt this is ever a problem... */

/* ==== begin changes ==== */

/* remove 'PROGRAMS,' from SET AUTOSTART= line; prevents a nasty loop in which
  a program that just crashed the system is re-opened upon re-boot */
call modify_line 'SET AUTOSTART=', 'PROGRAMS,', ''

/* hmm... call modify_line 'SET AUTOSTART=', ',WARPCENTER', ''
  instead put WarpCenter in StartUp folder
  has advantage in avoiding some rare hangs on boot-up */

/* change OS/2 PROMPTs to "OS/2" with date, time and path */
call modify_line 'SET PROMPT=', '$i[$p]', 'OS/2 $d $t $p$g'

call add_to_line 'LIBPATH=', 'C:\EMX\DLL;'
call add_to_line 'SET PATH=', 'C:\EMX\BIN;'

/* increase FILES (syntax with '' here actually replaces entire line) */
call modify_line 'FILES=', '', 'FILES=60'

/* after FILES line, to prevent annoying pop-up dialogs add */
call add_after 'FILES=', 'AUTOFAIL=YES'

/* increase BUFFERS; very little effect, but might as well use the memory */
call modify_line 'BUFFERS=', '', 'BUFFERS=90'

/* insert helpful note that you might someday need */
call add_after 'MEMMAN=', 'rem ^ may be useful: VIRTUALADDRESSLIMIT=1024'

call remark_line 'BASEDEV=IBM2FLPY.ADD' /* unless a microchannel machine */
/* OR, to clear the line: call modify_line 'BASEDEV=IBM2FLPY.ADD', '', '' */ 

call remark_line 'BASEDEV=XDFLOPPY.FLT' /* also not likely to need */

/* add '/W' to CDFS.IFS, allows long file names from CD */
call add_to_line 'IFS=C:\OS2\BOOT\CDFS.IFS', ' /W'

/* set local TZ and updated daylight savings adjustment info */
call modify_line 'SET TZ=', 'est5edt', 'CST6CDT,3,2,0,7200,11,1,0,7200,3600'

/* having copied RAMFS121 files, place after CDFS line */
call add_after 'IFS=C:\OS2\BOOT\CDFS.IFS', 'IFS=C:\RAMFS121\RAMFS.IFS /S:128M'
/* place its driver program at last line */
call add_after '', 'CALL=C:\RAMFS121\RAMDISK.EXE Z:'

/* ==== Optional DANI IDE driver section - HIGHLY recommended ===== */
/* of course, you'll need to have put the files in \OS2\BOOT */
/* IBM drivers just remmed out in case you need to revert */
/* NOTE: rename DaniATAPI.FLT to DaniATAP.FLT in case of copy to floppy */

/*
call add_after 'BASEDEV=IBM1S506.ADD', 'BASEDEV=DaniS506.ADD'
call remark_line 'BASEDEV=IBM1S506.ADD'

call add_after 'BASEDEV=IBMATAPI.FLT', 'BASEDEV=DaniATAP.FLT'
call remark_line 'BASEDEV=IBMATAPI.FLT' /* either or both may exist */
call remark_line 'BASEDEV=IBMIDECD.FLT'

call add_after 'BASEDEV=OS2DASD.DMD', 'BASEDEV=DaniDASD.DMD'
call remark_line 'BASEDEV=OS2DASD.DMD'
*/

/* ===================== Presumed ready to risk it!!! ===================== */

say
say
say 'Deleting existing; immediately writing the new...'
'DEL 'I_CS
rc= stream(o_cs, 'c', 'open write')  /* output, hope is quick and accurate */
do ndx= 1 to lin.0
  call charout o_cs, lin.ndx||d2c(13)||d2c(10)
end
rc= stream(o_cs, 'c', 'close')
if rc = 'READY:' then do /* note: REXX .INF does not show the ":", hmm */
  say
  say 'Whew! Appears to have written it OK!'
  say
  say
end
else do
  say '==================================='
  say
  say 'UH-OH. SOME SORT OF ERROR WRITING THE NEW CONFIG.SYS.'
  say 'Copying from backup. You should give it a look, kind of essential...'
  'copy 'b_cs' 'o_cs
  exit
end

/* exit remove if doing the below */

/* ==== Done with CONFIG.SYS ==== */

say '==== Optional directory copying (mostly from custom CD). ===='

dm= sysdrivemap('C:', 'local')  /* try to find (first) CD drive */
n= 0
do until (dfs = '') | (n >= words(dm))
  n= n + 1
  d= word(dm, n)
  dfs= word(SysDriveInfo(d), 2) /* if 2nd word returns nil, then likely CD */
end
if n <= words(dm) then source= word(dm, n)
else source= word(dm, words(dm))
say
say 'Looks as though the first CD drive is 'source' -- Copy from here?'

avail_dr= sysdrivemap('C:', 'used')  /* now get all to show choices */
do while pos(':', avail_dr) > 0  /* delete colons */
  n= pos(':', avail_dr)
  avail_dr= delstr(avail_dr, n, 1)
end
avail_dr= 'A B '||avail_dr /* uh, you're not LIKELY to have a B, but I do */
say                        /* greatly simplifies code, no harm if chosen */
say 'Available drives: 'avail_dr
say
avail_dr= avail_dr||k_enter /* the CR otherwise screws up display */

key= ''
do until pos(key, avail_dr) > 0
  say '<enter> to accept, or type a drive letter from above'
  do until (chars() > 0)
    call syssleep 1
  end
  key= translate(ex_read_key())
  if key = ' ' then key= '' /* prohibit <space> tho used to format string */
say 'Will copy FROM: 'key
end
if key = k_enter then source= source||'\'
else source= key||':\'

say
key= ''
target= 'C:\'
say 'Choose destination, currently 'target
do until pos(key, avail_dr) > 0
  say '<enter> to accept, or type a drive letter from above'
  do until (chars() > 0)
    call syssleep 1
  end
  key= translate(ex_read_key())
  if key = ' ' then key= ''
end
if key <> k_enter then target= key||':\'
say 'Will copy TO: 'key
say

/* EXAMPLES: here specify directories on source (CD) to copy to target (HD) */

call do_xcopy 'PROGRF'
call do_xcopy 'PMP210'
call do_xcopy 'RAMFS121'
call do_xcopy 'EMX'

/* install icons on desktop; desktop name (just for display), path and .exe */
call make_object 'PROGREF', target||'PROGRF\PROGREF.EXE'
call make_object 'PMPATROL', target||'PMP210\PMPATROL.EXE'

exit /* ====================== end of main routine ======================= */

do_xcopy:  /* checks that dir on source drive exists and is not empty */
parse arg cdpath
  rc= sysfiletree(source||cdpath||'\*', 'n', 'BSO')
  if (rc = 0) & (n.0 > 0) then do
    'mkdir 'target||cdpath /* making dir avoids annoying xcopy create check */
    'xcopy 'source||cdpath||'\* 'target||cdpath' /s /e'
  end
  else say source||cdpath||' was not found.'
return

make_object:  /* checks that file exists */
parse arg dtn, fp
if stream(fp, 'c', 'query exists') <> '' then do
  filepath=filespec("Path", fp)
  filedrive=filespec("Drive", fp)
  if SysCreateObject("WPProgram", dtn,,
    "<WP_DESKTOP>", "EXENAME="||fp,
    ";STARTUPDIR="||filedrive||filepath, "REPLACE") then say dtn' created'
  else do
    call beep 2000, 500
    say 'Failed to create 'dtn
  end
end
else say fp' was not found; object not created.'
return
/* there are several more keywords for setup strings; see KEYWORDS.TXT
   which is abstracted from http://www.lesbell.com.au/rexxobj.html */

/* ==== all text changes are done by one of four PROCEDURES: ==== */

/* add_after: 'line_starting', 'new line'
               ^ '' adds after present last line */
add_after:
parse arg ls, nt
  n= found_in(nt)
  ndx= starts_with_ndx(ls)
  if n > 0 then do
    p= duplicate(n, nt)
    if p = 'Y' then n= 0
  end
  if n = 0 then do 
    if ls = '' then do
      ndx= lin.0 + 1
      lin.ndx= nt
      lin.0= lin.0 + 1 /* adjust */
    end
    else do
      if ndx > lin.0 then do
        say
        say '!!! Did not find a line which starts:'
        say ls
        say
        say 'So no place to put the following new line:'
        say nt
        say
        say 'Hit "Y" to add the above after current end.'
        do until (chars() > 0)
          call syssleep 1
        end
        key= translate(ex_read_key())
        if key = 'Y' then do /* the same as ls = '' above */
          ndx= lin.0 + 1
          lin.ndx= nt
          lin.0= lin.0 + 1 /* adjust */
        end
      end
      else do
        do n= lin.0 + 1 to ndx + 2 by - 1  /* copy existing lines down 1 */
          p= n - 1
          lin.n= lin.p
        end
        ndx= ndx + 1
        lin.ndx= nt   /* overwrite with new line */
        lin.0= lin.0 + 1 /* adjust */
      end
    end
  end
return

/* modify_line: 'line_starting', 'find text', 'new text'
     existing parameters can vary ^ so '' here deletes all of line, to be
     replaced in whole; if 'new text' is then '' too, line is cleared */
modify_line:
parse arg ls, ft, nt
  n= found_in(nt)
  ndx= starts_with_ndx(ls)
  if n > 0 then do
    p= duplicate()
    if p = 'Y' then n= 0
  end
  if n = 0 then do
    if ndx <= lin.0 then do
      if ft = '' then do /* replace entire line */
        lin.ndx= nt
      end
      else do
        pft= pos(ft, lin.ndx)
        if pft > 0 then do
          lin.ndx= delstr(lin.ndx, pft, length(ft))
          lin.ndx= insert(nt, lin.ndx, pft - 1)
        end
        else do
          say
          say '!!! Did not find specified text:'
          say ft
          say 'in line # 'ndx', which reads:'
          say lin.ndx
          say
          say 'LINE NOT MODIFIED. Hit any key to continue.'
          do until (chars() > 0)
            call syssleep 1
          end
          key= translate(ex_read_key())
        end
      end
    end
  end
return

/* remark_line: 'line_starting' */
remark_line:
parse arg ls
  ndx= starts_with_ndx(ls)
  if ndx <= lin.0 then do
    lin.ndx= 'rem '||lin.ndx
  end
return

/* add_to_line: 'line_starting', 'new text'
  'new text' must include any required semi-colon or space
  at present only adds at end of line -- after duplication check */
add_to_line:
parse arg ls, nt
  ndx= starts_with_ndx(ls)
  if (ndx <= lin.0) & (pos(nt, lin.ndx) = 0) then lin.ndx= lin.ndx||nt
return

/* finds the index of (first) line starting with ls */
starts_with_ndx:
  fn= 0
  do until (pos(ls, lin.fn) = 1) | (fn > lin.0)
    fn= fn + 1
  end
return fn

/* some guard against duplication, finds index of any line containing arg */
found_in:
parse arg no_dup
  fn= 0
  do f= 1 to lin.0  /* searches EVERY line */
   if pos(no_dup, lin.f) > 0 then fn= f
  end
return fn

duplicate:   /* okay... after simplistic check, ask for a decision */
/* no reasonable code could okay or reject all possibles, SO IS UP TO YOU */
  call beep 1000, 300
  say
  say
  say 'In line # 'ndx', the following text would duplicate some in line # 'n
  say nt
  say
  say 'THIS IS A GLOBAL CHECK, SO MAY BE ENTIRELY SAFE AND UN-RELATED!'
  say
  say 'The existing line reads:'
  say lin.n
  say
  say 'Hit "Y" if you wish to insert the text anyway. Any other key exits.'
  do until (chars() > 0)
    call syssleep 1
  end
  key= translate(ex_read_key())
return key

ex_read_key: /* returns two bytes for extended codes */
  xrkey= sysgetkey('noecho')
  if xrkey = zky | xrkey = xky then xrkey= xrkey||sysgetkey('noecho')
return xrkey

