/* InstLang.cmd - Install language support for ConfigTool */

IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END

CALL SysCls
progname = 'ConfigTool 1.3.0'
inifile = 'CFGTOOL.INI'
IF STREAM(inifile,'C','QUERY EXISTS') = "" THEN DO
    SAY 'Problem! '||inifile||' file does not exist.'
    SAY 'Did you install '||progname||'?'
    SAY 'Press Enter to exit and correct error.'
    PULL answer
    Exit
END

SAY 'This procedure will add Language support for '||progname||':'
SAY 'Croatian, French, German, Russian and Swedish.'
SAY 'Press "Y" to start Installation, any other key to exit...'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'Y' THEN NOP
    OTHERWISE CALL NoAction 'Installation aborted.'
END

SAY ' '
CALL SysIni inifile, 'Language', 'CROATIAN', 'English.inf'
CALL SysIni inifile, 'Language', 'FRENCH', 'French.inf'
CALL SysIni inifile, 'Language', 'GERMAN', 'English.inf'
CALL SysIni inifile, 'Language', 'RUSSIAN', 'Russian.inf'
CALL SysIni inifile, 'Language', 'SWEDISH', 'Swedish.inf'

SAY ' '
InstallDir = Directory()
obj_tit.1 = progname||'^manual (French)'
obj_set.1 = 'OBJECTID=<CFGTOOL130_HLPFRE>;EXENAME=View.exe;PARAMETERS='InstallDir'\French.inf;STARTUPDIR='InstallDir''
obj_tit.2 = progname||'^manual (Russian)'
obj_set.2 = 'OBJECTID=<CFGTOOL130_HLPRUS>;EXENAME=View.exe;PARAMETERS='InstallDir'\Russian.inf;STARTUPDIR='InstallDir''
obj_tit.3 = progname||'^manual (Swedish)'
obj_set.3 = 'OBJECTID=<CFGTOOL130_HLPSWE>;EXENAME=View.exe;PARAMETERS='InstallDir'\Swedish.inf;STARTUPDIR='InstallDir''
objects.0 = 3
DO i = 1 TO objects.0
    dummy = SysCreateObject('WPProgram',obj_tit.i,'<GISYSTOOLS_HELP>',obj_set.i,'U')
    SAY TRANSLATE(obj_tit.i,' ','^')||' - '||rc1(dummy)
END

SAY ' '
SAY 'Installation finished! Press Enter to exit ...'
PULL answer
CALL SysCls
Exit

/* NoAction - abort Install */

NoAction:   PROCEDURE

PARSE ARG noinstmsg
SAY ' '
SAY noinstmsg
SAY 'Press any key to exit ...'
ans = SysGetKey('NOECHO')
Exit

/* End of NoAction */

/* rc1 - return code - SysCreateObject */

rc1:        PROCEDURE

PARSE ARG rcSysCreateObject
SELECT
    WHEN rcSysCreateObject = 0 THEN rc1 = 'Error'
    OTHERWISE rc1 = 'OK'
END
RETURN rc1

/* End of rc1 */

/* EOF InstLang.cmd */

