/*This REXX program provides a PMREXX user interface, GUI, to the cleanini.exe program.*/
/*It uses PMREXX to provide a GUI for instructions on running cleanini.exe by selecting one or more of */
/*its options. After the user selects one or more options, the program calls another REXX program,*/
/*CLEANINI2.CMS, to run the cleanini.exe program in an OS/2 command window with the*/
/*selected options passed on to cleanini.exe*/



/*Begin finding the location of this REXX program, the CLEANINI2.CMD REXX program and the cleanini.exe executable file*/
PARSE SOURCE OperatingSystem HowCalled FileSpec
ProgramLocation = ""
FileSpecPortion = FileSpec
DO UNTIL FileSpecPortion = ""
	PARSE Var FileSpecPortion FirstPart "\" SecondPart
	SELECT
		WHEN ProgramLocation = "" & SecondPart \= "" THEN ProgramLocation = FirstPart
		WHEN ProgramLocation \= "" & SecondPart \= "" THEN ProgramLocation = ProgramLocation"\"FirstPart
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
	FileSpecPortion = SecondPart
END	/*Ends "DO UNTIL FileSpecPortion = """ Section*/
/*End finding the location of this REXX program, the CLEANINI2.CMD REXX program and the cleanini.exe executable file*/



/*Begin specifying the desired options for cleanini.exe*/
ErrorChance = 5
TABLE:
SAY "This REXX program provides a PMREXX graphical user interface, GUI, to the cleanini.exe program"
SAY ""
SAY ""
SAY "The following desired commandline options are available for executing cleanini.exe:"
SAY ""
SAY "		OPTION DESCRIPTION									OPTION PARAMETER"
SAY "	No option given. Scan the OS2.INI file and write the problems to the file, CLEANINI.LOG."		
SAY "	Make a backup of OS2.INI. Then, write the required corrections to OS2.INI.  (*****)			/C"
SAY "	Restart the WorkPlace Shell (WPS) after making corrections to OS2.INI.  (*****)				/R"
SAY "	Use the option parameters specified in the response file (the path = ResponseFileName)			/R:ResponseFileName"
SAY "	Specify a name (the path) for the logfile (the default is CLEANINI.LOG).				/L:LogFileName"
SAY "	Delete all unused WPS folder positions (PM_Workplace:FolderPos).					/D:FP"
SAY "	Delete all unused PM folder content (PM_Abstract:FldrContent).						/D:FC"
SAY "	Delete unnecessary PMWP_ASSOC_TYPE, PMWP_ASSOC_FILTER, PMWP_ASSOC_CHECKSUM and PM_Workplace:Startup.	/D:M"
SAY "	Delete all (equivalent to the parameters: '/D:FP /D:FC /D:M).  (*****)					/D:A"
SAY "	Scan multiple times so that all unnecessary handles can be deleted.  (*****)				/M"
SAY "	Delete handles of all remote files.  (*****)								/RFD"
SAY "	Ignore handles of all remote files.									/RFI"
SAY "	Change the number of columns on the screen to M (in a VIO window only).					/COLS:M"
SAY "	Change the number of rows on the screen to N (in a VIO window only).					/ROWS:N"
SAY "	Only show and log those handles that are deleted.  (*****)						/LOGDEL"
SAY "	Do not display a logo.											/NOLOGO"
SAY "	Force a backup if the '/C' option is not specified.							/BACKUP"
SAY "	Restore the OS2.INI from the most recent backup.							/RESTORE"
SAY "	The six (6) preferred options, '/C /R /D:A /M /RFD /LOGDEL', the ones with the five (6) asterisks	/P"
SAY "	Show information, or help.										/?"
SAY ""
SAY ""
SAY "If you want more than 1 option, separate each one with a space. Please select the desired commandline option,"
SAY "or options, as given above. Enter it, or them, on the PMREXX Input line, above. Then press the ENTER key."
PARSE UPPER PULL Options
SAY ""
SAY ""
SELECT
	WHEN ErrorChance = 0 THEN DO
		SAY "You have incorrectly entered the option data 5 times. You will not be able to correct"
		SAY "any more errors. Instead, this program will now terminate. Please try again, this time"
		SAY "correctly entering the desired options."
	END	/*Ends "" Section*/

	OTHERWISE DO
		CALL ERRORCHECKING
		NOP
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/

IF TestFailure = "YES" THEN SIGNAL TABLE



/*Begin re-specifying the options, using the same parameters that cleanini wants and uses*/
SELECT
	WHEN Part.0 = 1 & Part.1 = "/P" THEN
	Options = "/C /RESTART /DELALL /MULTIPASS /REMOTE:DELETE /LOGDEL"

	OTHERWISE DO
		DO M = 1 TO Part.0 BY 1
			SELECT
				WHEN Part.M = "/C" THEN Part.M = "/C"
				WHEN Part.M = "/R" THEN Part.M = "/RESTART"
				WHEN Part.M = "/D:FP" THEN Part.M = "/DELFLDPOS"
				WHEN Part.M = "/D:FC" THEN Part.M = "/DELFLDCONT"
				WHEN Part.M = "/D:M" THEN Part.M = "/DELMISC"
				WHEN Part.M = "/D:A" THEN Part.M = "/DELALL"
				WHEN Part.M = "/M" THEN Part.M = "/MULTIPASS"
				WHEN Part.M = "/RFD" THEN Part.M = "/REMOTE:DELETE"
				WHEN Part.M = "/RFI" THEN Part.M = "/REMOTE:IGNORE"
				WHEN Part.M = "/LOGDEL" THEN Part.M = "/LOGDEL"
				WHEN Part.M = "/NOLOGO" THEN Part.M = "/NOLOGO"
				WHEN Part.M = "/BACKUP" THEN Part.M = "/BACK"
				WHEN Part.M = "/RESTORE" THEN Part.M = "/REST"
				WHEN Part.M = "/?" THEN Part.M = "/?"
				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/
		END M	/*Ends "DO M = 1 TO Part.0 BY 1" Section*/


		Options = ""
		DO M = 1 TO Part.0 BY 1
			Options = Options" "Part.M
		END M	/*Ends "DO M = 1 TO Part.0 BY 1" Section*/
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/
/*End re-specifying the options, using the same parameters that cleanini wants and uses*/
/*End specifying the desired options for cleanini.exe*/



/*Begin calling the CLEANINI2.CMD REXX procedure, which in turn will call the cleanini.exe program*/
Commandline = "CALL "ProgramLocation"\CLEANINI2.CMD "Options
INTERPRET "Commandline"
/*End calling the CLEANINI2.CMD REXX procedure, which in turn will call the cleanini.exe program*/



/*Begin specifying whether or not you wish to open the cleanini log file*/
SAY ""
SAY ""
SAY "Please select whether or not you wish to open the cleanini log file. Enter a 'Y' (or, a 'y') if you"
SAY "want to open the log file. Otherwise, just press the ENTER key."
SAY ""
SAY ""
PARSE UPPER PULL Response
SELECT
	WHEN Response = "Y" THEN DO
		CALL OPENLOGFILE
		NOP
	END

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End specifying whether or not you wish to open the cleanini log file*/
FINISH:
EXIT









ERRORCHECKING:
TestFailure = "NO"
LogFileName = ""
Part. = ""
Test. = ""
Remaining = "Harry"
Selections = Options
M = 0
DO UNTIL Remaining = ""
	M = M + 1
	FileNameTest1 = LEFT(Selections,3)
	SELECT
		WHEN FileNameTest = "/L:" THEN DO	/*Parse the options, when a log file name is specified*/
			PARSE VAR Selections Part.M Remaining
			Selections = Remaining
			PartLength = LENGTH(Part.M)
			DesiredLength = (PartLength - 3)
			LogFileName = SUBSTR(Part.M,4,DesiredLength)
			Part.M = "/LOG:"LogFileName
		END	/*Ends "WHEN LogFileNameTest = "/L" THEN DO" Section*/

		WHEN FileNameTest = "/R:" THEN DO	/*Parse the options, when a response file name is specified*/
			PARSE VAR Selections Part.M Remaining
			Selections = Remaining
			PartLength = LENGTH(Part.M)
			DesiredLength = (PartLength - 3)
			ResponseFileName = SUBSTR(Part.M,4,DesiredLength)
			Part.M = "/RESP:"ResponseFileName
		END	/*Ends "WHEN LogFileNameTest = "/L" THEN DO" Section*/

		OTHERWISE DO	/*Parse the options, when a log file is not specified*/
			PARSE VAR Selections Part.M Remaining
			Selections = Remaining
		END	/*Ends "OTHERWISE DO" Section*/
	END	/*Ends "SELECT" Section*/
END	/*Ends "DO UNTIL Remaining = """ Section*/
Part.0 = M
DO M = 1 TO Part.0 BY 1
	Test = LEFT(Part.M,1)
	SELECT
		WHEN Test \= "/" THEN DO
			ErrorChance = (ErrorChance - 1)
			TestFailure = "YES"
			SAY "You did not enter the options correctly. You left out a preceding '/' on one or more of the options."
			SAY "Please re-enter the desired options correctly. If you do not enter the options correctly, you will"
			SAy "have only "ErrorChance "more chances to correct the mistake(s)."
			SAY ""
			SAY ""
			SAY ""
			SAY ""
			LEAVE
		END	/*Ends "WHEN Test \= "/" THEN DO" Section*/

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END M	/*Ends "DO M = 1 TO Part.0 BY 1" Section*/
RETURN









OPENLOGFILE:
SAY "You must now open the log file by selecting the OS/2 System Editor, using the OS/2 Window List."
SAY "Press the CONTROL-ESCAPE keys to open the OS/2 Window List. Double mouse click on the 'E.EXE'"
SAY "choice in the window list."
SELECT
	WHEN LogFileName = "" THEN LogFile = "CLEANINI.LOG"

	OTHERWISE LogFile = LogFileName
END	/*Ends "SELECT" Section*/
LogFilePath = ProgramLocation"\"LogFile
Commandline = 'E.EXE "'LogFilePath'"'
INTERPRET "Commandline"
RETURN
