/* RX.C (RX.EXE)
 *
 * This is a Presentation Manager program that launches a REXX script and allows it to open and use a PM window
 * with PM controls in order to obtain user input (as opposed to "pull"ing from a command line prompt). It takes 1 arg
 * from OS/2; the name of the REXX script to launch. It uses Rexx Dialog to implement the REXX/PM interface.
 */

#define INCL_WINSYS
#define INCL_WINWINDOWMGR

#include <os2.h>
#include "rx.h"

HMQ hmq;

/********************************** main() ********************************
 * 1. Initializes PM environment: obtains anchor block handle and creates msg queue
 *    that all of the Rexx Dialog windows use.
 * 2. Calls RexxSet() routine (init RXDLG.DLL stuff)
 * 3. Executes REXX script
 * 4. Frees resources
 * 5. Ends program
 *
 * Return: 0 if successful execution, non-zero if error
 *************************************************************************/
int main(int argc, char *argv[], char *envp[])
{
    register ULONG id;

    /* Obtain a PM anchor block. Store it in REXXSPEC */
    if(!(RexxSpec.Hab = WinInitialize(0)))
    {
badinit:
	DosBeep(60, 120);
	return(ERRAPP);
    }

    /* Obtain a PM Message Queue */
    if(!(hmq = WinCreateMsgQueue(RexxSpec.Hab, 0)))
    {
	WinTerminate(RexxSpec.Hab);
	goto badinit;
    }

    /* Is there a REXX script name specified? */
    if (argc>1)
    {
	/* Install REXX support */
	if((id = RexxSet()))
	{
	    DlgErrMsg(id, id+ERRAPP);
	}
	else
	{
	    /* Execute REXX script (if it exists) */
	    RexxRunScript(argv[1]);

	    /* Uninstall REXX support */
	    RexxFree();
	}
    }
    /* Print usage */
    else
    {
	DlgMsgStr("Usage: RX [Rexx script filename]", 0, 0);
    }

    /* Free resources */
    WinDestroyMsgQueue(hmq);
    WinTerminate(RexxSpec.Hab);

    /* Return error code */
    return(RexxSpec.ErrNum);
}
