/*
Ŀ
 OS2Copy.CMD v.2.1.02 GA part 1 of 2.                                  
                                                                       
 REXX script to copy OS/2 2.1 GA HPFS or FAT BootManager system,       
 from one drive letter to another  eg. from D: to E:,                  
 from FAT to FAT, HPFS to HPFS.                                        
                                                                       
 Documentation is found in the file OS2COPY.DOC                        
                                                                       
 Copyright (C): John Sthle                                            
                289A Buddinge Hovedgade                                
                DK-2880 Bagsvrd                                       
                Denmark, Europe                                        
                Phone +45 44 98 66 18                                  
                                                                       
                Internet:            john.staahle@dkb.dk               
                RIME and ILINK OS/2: John Staahle                      
                                                                       
 Disclaimer, warning and what not:                                     
 !! NO responsibility or any other obligation you can ever think of    
    is assumed, honored or anything else.                              
 
*/
Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
CALL SysLoadFuncs

PARSE UPPER Arg all_args

HPFSSys='HPFS' 
FATSys='FAT'

'@ECHO OFF'
'Set PROMPT=$E[1;33m$P$G'
CALL SysCls
CALL Startmeddelelse
CALL FindFiler
CALL GetYesNo
CALL SysCls

CALL HentParametre
CALL SysCls
IF (FromDrive == ToDrive) THEN DO
   SAY 'FromDrive ('FromDrive') is the same as ToDrive ('ToDrive') NO GO!'
   'PAUSE'
   CALL SysCls
   CALL HentParametre
   IF (FromDrive == ToDrive) THEN EXIT
   CALL SysCls
END

CALL Kopimeddelelse
IF (OK \= YesLetter) THEN DO
   SAY
   EXIT
END
CALL SysCls

/* Here goes */

CALL CheckInitFiles
CALL EditInitList
CALL CreateStartupFile
CALL FdiskMsg

'FDISK'

CALL KaldOS2Copy2

EXIT

/**/

Startmeddelelse:
 SAY 'Ŀ'
 SAY ' OS2Copy.1 v.2.1 GA, no. 1 of 2, Copyright John Sthle(C)               '
 SAY '                                                                        '
 SAY ' !!! No other process may be active while this job is running !!!       '
 SAY '                                                                        '
 SAY '          This program will copy the ENTIRE OS/2 partition              '
 SAY '          to another partition (drive-letter or drive)                  '
 SAY '                                                                        '
 SAY ' You may get messages telling that OS2.INI, OS2SYS.INI and SWAPPER.DAT  '
 SAY ' can NOT be copied (this is during the XCOPY part).                     '
 SAY " Don't worry these files will be copied and edited later in the process."
 SAY 'Ĵ'
 SAY '             Press Control C  to STOP  - or                             '
 SAY ''
 SAY 
 'PAUSE'
RETURN

/*.......................................................................*/

FindFiler:
   
   CopyFil = 'OS2COPY2.CMD'
   Os2Copy2Fil = SysSearchPath('PATH',CopyFil)
   IF (Os2Copy2Fil == '') then DO
      NoFileName = CopyFil
      CALL FileNotThere
      CALL GoodBye
   END

   CInitExe = 'InitEdit.EXE'
   InitEditExe = SysSearchPath('PATH',CInitExe)
   IF (InitEditExe == '') then DO
      NoFileName = CInitExe
      CALL FileNotThere
      CALL GoodBye
   END

   YNFile = 'YesNo.LNG'
   YesNoFile = SysSearchPath('PATH',YNFile)
   IF (YesNoFile == '') then DO
      NoFileName = YNFile
      CALL FileNotThere
      CALL GoodBye
   END
   
   IF ((FromFilSys == FATSys) & (ToFilSys == HPFSSys)) THEN DO
      BootStrap = 'OS2BOOT.'SubStr(HPFSSys,1,3)
      CopyBootStrap = SysSearchPath('PATH',BootStrap)
      IF (CopyBootStrap == '') then DO
         NoFileName = YesNoFil
         CALL FileNotThere
         CALL GoodBye
         EXIT
      END
   END
   
   cInitEditSTD = 'InitEdit.STD'
   cInitSTD     = SysSearchPath('PATH',cInitEditSTD)
   IF (cInitSTD == '') then DO
      NoFileName = cInitEditSTD
      CALL FileNotThere
      CALL GoodBye
   END
   
   InitEditList = 'InitEdit.LST'
   cInitList    = SysSearchPath('PATH',InitEditList)
   IF (cInitList \= '') then DO
      'DEL 'cInitList' >NUL'
   END
   cInitList = SubStr(cInitSTD,1,LastPos('.',cInitSTD))||'LST'
   
   FraDrev   = SUBSTR(DIRECTORY(),1,2)

   InitFil = LineIn(cInitSTD,1,1)
   DO WHILE InitFil  \=  '>INIT_FILES'
      InitFil = LineIn(cInitSTD)
   END
   InitFil = LineIn(cInitSTD)
   DO WHILE ((InitFil \= '>BIN_FILES') & (LEFT(InitFil,1) == '\'))
      IndIni    = Substr(InitFil,2,LENGTH(InitFil)-1)
      CInitTest = SysSearchPath('PATH',IndIni)
      IF (CInitTest == '') then DO
         NoFileName = IndIni
         CALL FileNotFound
      END
      InitFil = LineIn(cInitSTD)
   END
RETURN

/*.......................................................................*/

FileNotThere:
   SAY 'Ŀ'
   SAY '' NoFileName' was >> NOT <<  found in your path'
   SAY '' NoFileName' is crucial for the success of this procedure'
   SAY ' !!! Path to 'NoFileName' must be included in your Config.Sys   !!!'
   SAY ' !!! Path to 'NoFileName' must be included in your Autoexec.Bat !!!'
   SAY ''
RETURN

/*.......................................................................*/

FileNotFound:
   SAY 'Ŀ'
   SAY ' 'NoFileName' was >> NOT <<  found in your path'
   SAY '                                                                 '
   SAY ' Place this (and the other files listed in 'cInitSTD')    '
   SAY ' in your PATH - or make sure these files are not needed          '
   SAY ' for your setup, in which case you must remove them from         '
   SAY ' 'cInitSTD' (a file like PMDIARY.INI may not be in use)   '
   SAY '                                                                 '
   SAY ' You can start another thread and make the changes now.          '
   SAY ''
   'PAUSE'
RETURN

/*.......................................................................*/

GetYesNo:
   YesNo = ' '
   DO WHILE (SubStr(YesNo,2,1) \= '/')
      YesNo = LineIn(YesNoFile)
   END
   YesLetter = SubStr(YesNo,1,1)
   NoLetter  = SubStr(YesNo,3,1)
   IF (YesLetter == ' ') THEN YesLetter = 'Y'
   IF (NoLetter  == ' ') THEN NoLetter  = 'N'
   iClose=LineOut(YesNoFile)
RETURN
/*.......................................................................*/

HentParametre:
   
ArgNo = 1
IF (word(all_args,ArgNo) == '') THEN DO
  SAY 'OS2Copy <FromDrive>[:]  [<ToDrive>[:]]  [<To file system>]'
  SAY
  SAY ' <FromDrive>:        Partition with OS/2 installed.'
  SAY 
  SAY ' <ToDrive>:          Partition OS/2 is to be copied to,'
  SAY '                     OPTIONAL in script 1.'
  SAY
  SAY ' <To file system>    file system to be installed on <ToDrive>:'
  SAY '                     OPTIONAL in script 1.'
  SAY 
END

CALL HentFraParametre
CALL HentTilParametre

RETURN

/*.......................................................................*/

HentFraParametre:
   k=SysCurPos()
   FromDrive=word(all_args,ArgNo)
   DO WHILE (FromDrive == '')
      CALL SysCurPos word(k,1), 0
      SAY 'Partition to copy OS/2 system FROM (X:) ?'
      CALL SysCurPos word(k,1), 48
      PULL FromDrive
   END
   IF (SUBSTR(FromDrive,2,1)<>':') THEN FromDrive = FromDrive':'

   'FDISK /Query |'RxQueue
   DO WHILE (QUEUED() > 0)
      PARSE PULL cFilSysInfo
      IF (SubStr(cFilSysInfo,19,2) == FromDrive) THEN DO
         IF (SubStr(cFilSysInfo,30,2) == '07') THEN FromFilSys = HPFSSys
         IF (SubStr(cFilSysInfo,30,2) == '06') THEN FromFilSys = FATSys
      END
   END
RETURN

/*.......................................................................*/
HentTilParametre:
   ArgNo   = ArgNo + 1
   ToDrive = word(all_args,ArgNo)
   k       = SysCurPos()
   IF (ToDrive == '') THEN DO
      CALL SysCurPos word(k,1), 0
      SAY 'Partition to copy your OS/2 system TO (X:) ?'
      SAY '(OPTIONAL in this script).'
      CALL SysCurPos word(k,1), 48
      PULL ToDrive 
   END

   IF (ToDrive\='') THEN DO
      IF (SUBSTR(ToDrive,2,1) \= ':') THEN DO
         ToDrive = ToDrive':'
      END
      ArgNo = ArgNo + 1
      ToFilSys=word(all_args,ArgNo)
      IF (ToFilSys == '') THEN IF (FromFilSys == FATSys) THEN DO
         SAY 
         k = SysCurPos()
         SAY 'File system for new OS/2 system (HPFS/FAT) ?'
         SAY '(OPTIONAL - read OS2Copy.DOC; default is 'FromFilSys').'
         CALL SysCurPos word(k,1), 48
         PULL ToFilSys
      END

      IF (ToFilSys\='') THEN DO
         IF (substr(ToFilSys,1,1) == substr(FATSys,1,1))  THEN ToFilSys = FATSys
         IF (substr(ToFilSys,1,1) == substr(HPFSSys,1,1)) THEN ToFilSys = HPFSSys

         IF ((FromFilSys == HPFSSys) & (ToFilSys == FATSys)) THEN DO
            SAY 'Mission impossible: You cannot copy a HPFS system to a FAT system'
            ToFilSys = ''
            EXIT
         END
         IF ((FromFilSys == FATSys) & (ToFilSys == HPFSSys)) THEN DO
            SAY 'Ŀ'
            SAY ' Copying a 'FATSys' to a 'HPFSSys'                                          '
            SAY ' is not an ideal copy, since several subdirectories               '
            SAY ' and files have different name under 'FATSys' and 'HPFSSys'                 '
            SAY ' The result will become a 'FATSys' OS/2 on a 'HPFSSys' formatted partition. '
            SAY ''
         END
      END
      IF ((ToFilSys\='') & (FromFilSys\=ToFilSys)) THEN DO
         SAY 'Ŀ'
         k = SysCurPos()
         CALL SysCurPos word(k,1), 0
         SAY ' Is the system you copy TO to become a FAT or HPFS system (F/H)   '
         SAY ''
         ToFilSys = ''
         DO WHILE ((ToFilSys\=HPFSSys) & (ToFilSys\=FATSys))
            CALL SysCurPos word(k,1), 65
            CDum  = SysGetKey()
            PARSE UPPER VAR CDum ToFilSys
            IF (substr(ToFilSys,1,1) == substr(FATSys,1,1))  THEN ToFilSys = FATSys
            IF (substr(ToFilSys,1,1) == substr(HPFSSys,1,1)) THEN ToFilSys = HPFSSys
         END
      END
   END

   IF (substr(ToFilSys,1,1) == substr(FATSys,1,1))  THEN ToFilSys = FATSys
   IF (substr(ToFilSys,1,1) == substr(HPFSSys,1,1)) THEN ToFilSys = HPFSSys
   
   CALL SysCurPos word(k,1), 0
   SAY 'Partition to copy OS/2 system   TO = 'ToDrive
   
   IF (ToDrive  ==  '') THEN ToDrive  = ' '
   IF (ToFilSys ==  '') THEN ToFilSys = ' '

RETURN

/*.......................................................................*/

Kopimeddelelse:
   SAY 'Ŀ'
   SAY ' Copy the ENTIRE OS/2 partition FROM  'FromDrive'                      '
   SAY ''
   IF (ToDrive\='') THEN DO
      SAY 'Ŀ'
      SAY ' Copy the ENTIRE OS/2 partition   TO  'ToDrive'                      '
      SAY ''
   END
   IF ((FromFilSys == FATSys) & (ToFilSys == HPFSSys)) THEN DO
      SAY 'Ŀ'
      SAY ' 'FromFilSys'  ----->  'ToFilSys'                                            '
      SAY ''
   END
   k=SysCurPos()
   DO WHILE ((OK<>YesLetter) & (OK<>NoLetter))
      CALL SysCurPos word(k,1),0
      SAY 'Ŀ'
      SAY ' Are you sure ('YesNo') ?                                         '
      SAY ''
      CALL SysCurPos word(k,1)+1,24
      JaNej = SysGetKey()
      PARSE UPPER VAR JaNej OK
   END
RETURN

/*.......................................................................*/
/* If OS2.INI and OS2SYS.INI cannot be found on the FromDrive, we are lost! */

CheckInitFiles:
   FromInis = FromDrive'\*.INI'
   rc = SysFileTree(FromInis,'InitFiles.','FSO')
   IF ((rc \= 0) | (InitFiles.0 < 2)) THEN DO
      CALL NoInitFilesHere
      EXIT
   END
RETURN
   
/*.......................................................................*/
EditInitList:
   cIndRec = LineIn(cInitSTD,1,1)
   rc = LineOut(cInitList, cIndRec,1)
   cIndRec = LineIn(cInitSTD)
   DO WHILE (cIndRec \= '>BIN_FILES')
      rc = LineOut(cInitList, cIndRec)
      cIndRec = LineIn(cInitSTD)
   END
   rc = LineOut(cInitList, cIndRec)
   cIndRec = LineIn(cInitSTD)
   DO WHILE (LEFT(cIndRec,1) == '\')
      rc = LineOut(cInitList, cIndRec)
      cIndRec = LineIn(cInitSTD)
   END
   
   i = 1
   DO WHILE (i <= InitFiles.0)
      IF ((FileSpec('NAME',InitFiles.i) \= 'OS2.INI') & (FileSpec('NAME',InitFiles.i) \= 'OS2SYS.INI')) THEN DO
         StartPos = Pos('\',InitFiles.i)
         SlutPos  = LENGTH(InitFiles.i)-StartPos+1
         rc = LineOut(cInitList,SubStr(InitFiles.i,StartPos,SlutPos))
      END
      i = i + 1
   END
   
   rc = LineOut(cInitList, cIndRec)
   cIndRec = LineIn(cInitSTD)
   DO WHILE (cIndRec \= '>>>THE_END')
      cIndRec = LineIn(cInitSTD)
      rc = LineOut(cInitList, cIndRec)
   END
   rc = LineOut(cInitList)
   
   cInitEditLis2 = SubStr(cInitList,1,LastPos('.',cInitList))'LS2'
   'COPY 'cInitList' 'cInitEditLis2
   cInitLis2    = SysSearchPath('PATH',cInitEditList2)
RETURN

/*.......................................................................*/
NoInitFilesHere:
   SAY 'Mission impossible: Filesearch for 'FromInis' failed.'
   SAY 'Good-bye, cruel world'
   CALL CleanUp
RETURN

/*.......................................................................*/
CreateStartupFile:

   SAY 'Ŀ'
   SAY ' An error message (SYS0002/SYS1083) or two like:            '
   SAY ' SYSxxxx: The system cannot find the file specified.        '
   SAY '                 >>> is  OK <<<                             '
   SAY ''

   FromDrive

   'DEL 'FromDrive'StartUp.@#@'
   cStartFile=FromDrive'\Startup.Cmd'
   rc = SysFileTree(cStartFile,'cStartUp.','FO')
   IF ((rc \= 0) | (cStartUp.0 == 0)) THEN DO
      CALL LineOut cStartFile,'Good morning, Madam or Sir.',1
      iClose=LineOut(cStartFile)
   END
   'REN 'cStartFile' StartUp.@#@'
   
   CALL LineOut cStartFile,'@Echo OFF',1
   IF (Todrive\=' ') THEN DO
      CALL LineOut cStartFile,'OS2Copy2 'FromDrive' 'Todrive' 'ToFilSys
   END
   ELSE DO
      CALL LineOut cStartFile, 'OS2Copy2 'FromDrive
   END
   CALL LineOut cStartFile,'EXIT'
   iClose=LineOut(cStartFile)
   DROP cStartFile
RETURN

/*.......................................................................*/
KaldOS2Copy2:
   IF (Todrive\=' ') THEN DO
      CALL OS2Copy2' 'FromDrive' 'Todrive' 'ToFilSys
   END
   ELSE DO
      CALL OS2Copy2' 'FromDrive
   END
RETURN

/*.......................................................................*/

FdiskMsg:
   SAY
   SAY 'Ŀ'
   SAY ' An error message like:                                     '
   SAY ' SYSxxxx: The specified disk or diskette cannot be accessed '
   SAY '                 >>> is  OK <<<                             '
   SAY ''
   SAY 'Ŀ'
   SAY ' Now starting FDISK                                         '
   SAY ' IF you are copying TO disk 1 of another computer then      '
   SAY '    Remember to create 'ToDrive' as a PRIMARY partition            '
   SAY ' ELSE if you are copying from one partition to another      '
   SAY '    Remember to create 'ToDrive' as a LOGICAL partition            '
   SAY '                                                            '
   SAY ' Insert the partition you created in BootManager            '
   SAY 'Ĵ'
   SAY '             Press Control C  to STOP  - or                 '
   SAY ''
   SAY
   'Pause'
RETURN

/*.......................................................................*/
GoodBye:
   SAY 'Mission impossible. Good-bye, cruel world'
   CALL CleanUp
   EXIT
RETURN

/**/
