/*  DTSaver.cmd
Save OS/2 ini files and the Config.sys

Marko Zarkovic, February 2000
Ottawa, Canada

*/



/*variables to set 
####################################*/

BUval = 20 /*number of files to save before cleaning up*/
CUval = 5 /*number of files to delete*/

/*
####################################*/



'@echo off'
parse arg hostdrive
/* hostdrive is the drive letter and colon
should be set up as a parameter in a shadow */

call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

Tval=1 /*debug only*/
budir = 'DESKTOP.BU'
fname = budir ||'\' || date('B')
list = hostdrive||'\os2\os2.ini' hostdrive||'\os2\os2sys.ini' hostdrive||'\config.sys'
dt = hostdrive||'\Desktop'

/*main ++++++++++++++++++++++++++++++++++++++*/
st=time()
MD 'DESKTOP.BU'  /* this fails if the folder already exists */
Say "Calling Zip..."
call zipcall
call inireport
call MAINTENANCE
say "Done!"
et=time()
say "dtsaver started at >>>" st "; ended at >>>" et
call SysSleep 3
beep(150,100)
beep(300,100)
beep(600,100)
exit


/*###############################################
*/

/*zipcall*/
zipcall:
c=0
UID = 0 /*unique identifier*/
do while UID = 0
 tempname = fname||c
 rc=SysFileTree(tempname||'.zip', fstr, F)
 if fstr.0 > 0 then do /*if there is already a file so named*/
  c=c+1  
 end
 else do
  UID = 1
 end
end
ZIP '-9S' tempname list
ZIP '-r9S' tempname dt
return

/*inireport*/
inireport:
repfile = 'ini_rprt.txt'
os2ini = hostdrive||'\os2\os2.ini'
sysini = hostdrive||'\os2\os2sys.ini'
config = hostdrive||'\config.sys'

call SysFileTree os2ini, os2inistem, 'F'
parse var os2inistem.1 fdate ftime fsize fatt fpath
/* MUST use the rc= with lineout to catch the return value */
rc = lineout(repfile,date() '['||time()||']' '->' fpath '-' fsize '-' fdate '-' ftime)

call SysFileTree sysini, sysinistem, 'F'
parse var sysinistem.1 fdate ftime fsize fatt fpath
rc = lineout(repfile,date() '['||time()||']' '->' fpath '-' fsize '-' fdate '-' ftime)

call SysFileTree config, configstem, 'F'
parse var configstem.1 fdate ftime fsize fatt fpath
rc = lineout(repfile,date() '['||time()||']' '-> ' config '-' fsize '-' fdate '-' ftime)

rc = lineout(repfile,'###################')

return

/*###############################################
*/

/* MAINTENANCE */
MAINTENANCE:
say "Checking the number of backups."
call SysFileTree '.\'||budir||'\*', 'ffiles', 'F'
say "There are " || ffiles.0 || " files."
if ffiles.0>=BUval then do
 DIR budir '/f /o:d > dirlist'
 do i=1 to CUval
  inline=linein('dirlist')
  say 'Deleting' inline
  DEL inline
 end
end
return

