/*Rexx program: Creating WPS objects for CLEAR*/

say "Creating WPS objects for CLEAR"
say "Use this installation program if you want to use CLEAR"
say "together with Info-Zip."
say ""
say "Four necessary files should be listed now."
"@dir clr_rexx.cmd /f"
"@dir OneDrvZp.cmd /f"
"@dir clear.exe /f"
"@dir clear.inf /f"
say "Are they located correct? (Y/N)"
pull YesNo
if \ ((YesNo = "Y") | (YesNo = "y")) then do
  say "Make the directory current where the CLEAR files are located"
  say "before running this installation program"
  "@pause"
  exit
end

Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs
CurrentDir = directory()

say "Enter a name for your individual CLR-textfile, used by CLEAR"
say "for example: MY.CLR"
pull ClrFile
if ClrFile = "" then do
  say "You have to enter a name for your CLR-textfile."
  "@pause"
  exit
end
say "Enter the drive letters for backup and clean up"
say "Pure Operating system- or Software-partitions can't be recommended."
say "Enter drive letters with spaces between, for example"
say "C D E"
pull DrvLetter
if (DrvLetter = "") | (DrvLetter = " ") then do
  say "You have to enter drive letters."
  exit
end 

say "Creating objects..."
/*program object Clear*/
Call SysCreateObject "WPProgram", "Clear", "<WP_DESKTOP>",,
	"OBJECTID=<MVClear>;EXENAME="CurrentDir"\clr_rexx.cmd;STARTUPDIR="CurrentDir"\ClearDat;PROGTYPE=OS2WINDOW;PARAMETERS=% "ClrFile" [from e.g: 5/31/95] "DrvLetter";ICONFILE="CurrentDir"\Broom.ico;"

/*Creating folder ClearDat with shadow on the desktop*/
Call SysCreateObject "WPFolder", "ClearDat", CurrentDir,,
	"OBJECTID=<MVClearDat>;ICONFILE="CurrentDir"\Broom1.ico;ICONNFILE=1,"CurrentDir"\Broom2.ico;"
Call SysCreateObject "WPShadow", "ClearDat", "<WP_DESKTOP>",,
	"SHADOWID=<MVClearDat>;"

/*program object INF Viewer*/
Call SysCreateObject "WPProgram", "Clear Info", "<WP_DESKTOP>",,
	"OBJECTID=<MVClearInfo"LwZahl">;EXENAME=VIEW.EXE;PARAMETERS=% "CurrentDir"\Clear.INF;ICONFILE="CurrentDir"\BroomInf.ico;"


"@type SAMPLE.CLR >ClearDat\"ClrFile
say ""
say "installation finished. Make sure that the Info-Zip programs ZIP.EXE,"
say "UNZIP.EXE and ZIPSPLIT.EXE are located in a directory of your"
say "path statement."

"@pause"
