/* rexx */

BACKUP_PATH='e:/Backup'
HOSTNAME='paperino'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Parse arg Backup_Set_List

if Backup_Set_List = '' then do
	say 'star_rotation [/0] backup_set1 [backup_set2] [backup_set3] [...]'
	exit
end

/* execute pre backup setup */
'call backup_pre.cmd'

TARDUMPS=BACKUP_PATH || '/' || HOSTNAME || '/tardumps'

/* default value for everyday backup */
level = 10
/* do a level 5 every weekend */
if (DATE('W') = 'Saturday') then
   level = 5
/* do a level 0 every first sunday of month */
day_of_month = word( DATE('N'),1)
if ((DATE('W') = 'Sunday') & (day_of_month<8)) then
   level = 0

/* force level 0 flag? */
set = 1
if (WORD( Backup_Set_List, 1) = '/0') then do
   level = 0 /* force level 0 */
   set = 2
end
Backup_Set = WORD( Backup_Set_List, set)

Response_List = ''
do i = set to WORDS(Backup_Set_List)
   Response_List = Response_List ' @'WORD( Backup_Set_List, i)
END

rc = SysMkDir( BACKUP_PATH)
rc = SysMkDir( BACKUP_PATH || '/' || HOSTNAME)
Backup_Set_Dir = BACKUP_PATH || '/' || HOSTNAME || '/' || Backup_Set
rc = SysMkDir( Backup_Set_Dir)


file = Backup_Set_Dir'/'DATE('S')'_L'level'.star'
log_file_stdout = Backup_Set_Dir'.log'
log_file_stderr = Backup_Set_Dir'.err'

options = '-z -time -c -xdev -sparse -acl -link-dirs tardumps='TARDUMPS' level='level' -wtardumps file='file' 'Response_List

/*  -onull -v */

'bin\star_fat.exe ' options ' . >> ' log_file_stdout ' 2>> ' log_file_stderr
/*'idebug bin\star_fat.exe -time -c -xdev -sparse -acl -link-dirs tardumps='TARDUMPS' level='level' -wtardumps file='file' 'Response_List' . '*/
say 'Exit code: 'rc
s = lineout( log_file_stderr, 'Exit code: '||rc)

/* execute post backup setup */
'call backup_post.cmd'
