extproc sh.exe
#
# If you have installed Japanese version of groff:
#          device=nippon
# If not:
#          device=ascii
#
device=nippon
#
if [ -z $1 ] ; then 
	echo 
	echo "Output manpage to standard output"
	echo
	echo "Usage:  outman  x:/foo/bar/manpage.3.gz"
	echo
	exit
fi

case $1 in
	*.gz)  top_line=`gzip -dc $1 | head -1` ;;
	*.bz2) top_line=`bzip2 -dc $1 | head -1` ;;
	*)     top_line=`head -1 $1` ;;
esac

if [ -z "$top_line" ]
then
	case $1 in
		*.gz)  gzip  -d < $1  ;;
		*.bz2) bzip2 -d < $1  ;;
		*)          cat < $1  ;;
	esac
	exit
else
	case $1 in
		*.gz)  gzip  -d < $1 | groff -man -T${device}   ;;
		*.bz2) bzip2 -d < $1 | groff -man -T${device}   ;;
		*)                     groff -man -T${device} $1 ;;
	esac
	exit
fi
